/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.exception.locale.LocalizedFormats;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.invoker.Invoker;

public class DataSourceBuilder {
    private static final Map<String, String> dataSourceAlias = new HashMap<String, String>();
    private final Map<String, String> dataSourceProperties;

    public DataSourceBuilder(Map<String, String> dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    public DataSource build() {
        String dataSourceClassName = null;
        String type = this.dataSourceProperties.get("type");
        dataSourceClassName = StringUtil.isNotBlank(type) ? dataSourceAlias.getOrDefault(type, type) : this.detectDataSourceClass();
        if (StringUtil.isBlank(dataSourceClassName)) {
            if (StringUtil.isBlank(type)) {
                throw FlexExceptions.wrap(LocalizedFormats.DATASOURCE_TYPE_BLANK, new Object[0]);
            }
            throw FlexExceptions.wrap(LocalizedFormats.DATASOURCE_TYPE_NOT_FIND, type);
        }
        try {
            Class<?> dataSourceClass = Class.forName(dataSourceClassName);
            Object dataSourceObject = dataSourceClass.newInstance();
            this.setDataSourceProperties(dataSourceObject);
            return (DataSource)dataSourceObject;
        }
        catch (Exception e) {
            throw FlexExceptions.wrap(LocalizedFormats.DATASOURCE_CAN_NOT_INSTANCE, dataSourceClassName);
        }
    }

    private void setDataSourceProperties(Object dataSourceObject) throws Exception {
        Reflector reflector = new Reflector(dataSourceObject.getClass());
        for (String attr : this.dataSourceProperties.keySet()) {
            String value = this.dataSourceProperties.get(attr);
            String camelAttr = DataSourceBuilder.attrToCamel(attr);
            if ("url".equals(camelAttr) || "jdbcUrl".equals(camelAttr)) {
                if (reflector.hasSetter("url")) {
                    reflector.getSetInvoker("url").invoke(dataSourceObject, new Object[]{value});
                    continue;
                }
                if (!reflector.hasSetter("jdbcUrl")) continue;
                reflector.getSetInvoker("jdbcUrl").invoke(dataSourceObject, new Object[]{value});
                continue;
            }
            if (!reflector.hasSetter(camelAttr)) continue;
            Invoker setInvoker = reflector.getSetInvoker(camelAttr);
            setInvoker.invoke(dataSourceObject, new Object[]{ConvertUtil.convert(value, setInvoker.getType())});
        }
    }

    public static String attrToCamel(String string) {
        int strLen = string.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = string.charAt(i);
            if (c == '-') {
                if (++i >= strLen) continue;
                sb.append(Character.toUpperCase(string.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String detectDataSourceClass() {
        String[] detectClassNames;
        for (String detectClassName : detectClassNames = new String[]{"com.alibaba.druid.pool.DruidDataSource", "com.zaxxer.hikari.HikariDataSource", "cn.beecp.BeeDataSource", "org.apache.commons.dbcp2.BasicDataSource"}) {
            String result = this.doDetectDataSourceClass(detectClassName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String doDetectDataSourceClass(String className) {
        try {
            Class.forName(className);
            return className;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        dataSourceAlias.put("druid", "com.alibaba.druid.pool.DruidDataSource");
        dataSourceAlias.put("hikari", "com.zaxxer.hikari.HikariDataSource");
        dataSourceAlias.put("hikaricp", "com.zaxxer.hikari.HikariDataSource");
        dataSourceAlias.put("bee", "cn.beecp.BeeDataSource");
        dataSourceAlias.put("beecp", "cn.beecp.BeeDataSource");
        dataSourceAlias.put("dbcp", "org.apache.commons.dbcp2.BasicDataSource");
        dataSourceAlias.put("dbcp2", "org.apache.commons.dbcp2.BasicDataSource");
    }
}

