/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collection;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.BeanWrapper;
import org.apache.ibatis.reflection.wrapper.MapWrapper;
import org.apache.ibatis.reflection.wrapper.ObjectWrapper;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

public class FlexWrapperFactory
implements ObjectWrapperFactory {
    public boolean hasWrapperFor(Object object) {
        Class<?> objectClass = object.getClass();
        if (Collection.class.isAssignableFrom(objectClass)) {
            return false;
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            return true;
        }
        return TableInfoFactory.ofEntityClass(objectClass) != null;
    }

    public ObjectWrapper getWrapperFor(MetaObject metaObject, Object object) {
        if (Map.class.isAssignableFrom(object.getClass())) {
            return new FlexMapWrapper(metaObject, (Map)object);
        }
        return new FlexBeanWrapper(metaObject, object);
    }

    static class FlexMapWrapper
    extends MapWrapper {
        public FlexMapWrapper(MetaObject metaObject, Map<String, Object> map) {
            super(metaObject, map);
        }

        public String findProperty(String name, boolean useCamelCaseMapping) {
            return useCamelCaseMapping && name.contains("_") ? StringUtil.underlineToCamel(name) : name;
        }
    }

    static class FlexBeanWrapper
    extends BeanWrapper {
        private final Object entity;
        private final TableInfo tableInfo;

        public FlexBeanWrapper(MetaObject metaObject, Object object) {
            super(metaObject, object);
            this.entity = object;
            this.tableInfo = TableInfoFactory.ofEntityClass(object.getClass());
        }

        public void set(PropertyTokenizer prop, Object value) {
            Object v = this.tableInfo.invokeOnSetListener(this.entity, prop.getName(), value);
            super.set(prop, v);
        }
    }
}

