/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.paginate;

import com.mybatisflex.core.FlexGlobalConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int INIT_VALUE = -1;
    private List<T> records = Collections.emptyList();
    private long pageNumber = 1L;
    private long pageSize = FlexGlobalConfig.getDefaultConfig().getDefaultPageSize();
    private long totalPage = -1L;
    private long totalRow = -1L;
    private boolean optimizeCountQuery = true;

    public static <T> Page<T> of(Number pageNumber, Number pageSize) {
        return new Page<T>(pageNumber, pageSize);
    }

    public static <T> Page<T> of(Number pageNumber, Number pageSize, Number totalRow) {
        return new Page<T>(pageNumber, pageSize, totalRow);
    }

    public Page() {
    }

    public Page(Number pageNumber, Number pageSize) {
        this.setPageNumber(pageNumber.longValue());
        this.setPageSize(pageSize.longValue());
    }

    public Page(Number pageNumber, Number pageSize, Number totalRow) {
        this.setPageNumber(pageNumber.longValue());
        this.setPageSize(pageSize.longValue());
        this.setTotalRow(totalRow.longValue());
    }

    public Page(List<T> records, Number pageNumber, Number pageSize, Number totalRow) {
        this.setRecords(records);
        this.setPageNumber(pageNumber.longValue());
        this.setPageSize(pageSize.longValue());
        this.setTotalRow(totalRow.longValue());
    }

    public List<T> getRecords() {
        return this.records;
    }

    public void setRecords(List<T> records) {
        if (records == null) {
            records = Collections.emptyList();
        }
        this.records = records;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        if (pageNumber < 1L) {
            throw new IllegalArgumentException("pageNumber must greater than or equal 1\uff0ccurrent value is: " + pageNumber);
        }
        this.pageNumber = pageNumber;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        if (pageSize < 0L) {
            throw new IllegalArgumentException("pageSize must greater than or equal 0\uff0ccurrent value is: " + pageSize);
        }
        this.pageSize = pageSize;
        this.calcTotalPage();
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public long getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(long totalRow) {
        this.totalRow = totalRow;
        this.calcTotalPage();
    }

    private void calcTotalPage() {
        this.totalPage = this.pageSize < 0L || this.totalRow < 0L ? -1L : (this.totalRow % this.pageSize == 0L ? this.totalRow / this.pageSize : this.totalRow / this.pageSize + 1L);
    }

    public boolean hasRecords() {
        return this.getTotalRow() > 0L && this.getPageNumber() <= this.getTotalPage();
    }

    public boolean hasNext() {
        return this.getTotalPage() != 0L && this.getPageNumber() < this.getTotalPage();
    }

    public boolean hasPrevious() {
        return this.getPageNumber() > 1L;
    }

    public long offset() {
        return this.getPageSize() * (this.getPageNumber() - 1L);
    }

    public void setOptimizeCountQuery(boolean optimizeCountQuery) {
        this.optimizeCountQuery = optimizeCountQuery;
    }

    public boolean needOptimizeCountQuery() {
        return this.optimizeCountQuery;
    }

    public <R> Page<R> map(Function<? super T, ? extends R> mapper) {
        Page<T> newPage = new Page<T>();
        newPage.pageNumber = this.pageNumber;
        newPage.pageSize = this.pageSize;
        newPage.totalPage = this.totalPage;
        newPage.totalRow = this.totalRow;
        if (this.records != null && !this.records.isEmpty()) {
            ArrayList<T> newRecords = new ArrayList<T>(this.records.size());
            for (T t : this.records) {
                newRecords.add(mapper.apply(t));
            }
            newPage.records = newRecords;
        }
        return newPage;
    }

    public String toString() {
        return "Page{pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", totalPage=" + this.totalPage + ", totalRow=" + this.totalRow + ", records=" + this.records + '}';
    }
}

