/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.relation;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.relation.RelationManager;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.FieldWrapper;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

abstract class AbstractRelation<SelfEntity> {
    protected String name;
    protected String simpleName;
    protected Class<SelfEntity> selfEntityClass;
    protected Field relationField;
    protected FieldWrapper relationFieldWrapper;
    protected Field selfField;
    protected FieldWrapper selfFieldWrapper;
    protected String targetSchema;
    protected String targetTable;
    protected Field targetField;
    protected Class<?> targetEntityClass;
    protected TableInfo targetTableInfo;
    protected FieldWrapper targetFieldWrapper;
    protected String joinTable;
    protected String joinSelfColumn;
    protected String joinTargetColumn;
    protected String dataSource;
    protected String extraConditionSql;
    protected List<String> extraConditionParamKeys;
    protected QueryColumn conditionColumn;
    protected String[] selectColumns;

    public AbstractRelation(String selfField, String targetSchema, String targetTable, String targetField, String joinTable, String joinSelfColumn, String joinTargetColumn, String dataSource, Class<SelfEntity> entityClass, Field relationField, String extraCondition, String[] selectColumns) {
        this.name = entityClass.getSimpleName() + "." + relationField.getName();
        this.simpleName = relationField.getName();
        this.selfEntityClass = entityClass;
        this.relationField = relationField;
        this.relationFieldWrapper = FieldWrapper.of(entityClass, relationField.getName());
        this.joinTable = joinTable;
        this.joinSelfColumn = joinSelfColumn;
        this.joinTargetColumn = joinTargetColumn;
        this.dataSource = dataSource;
        this.selfField = ClassUtil.getFirstField(entityClass, field -> field.getName().equals(selfField));
        this.selfFieldWrapper = FieldWrapper.of(entityClass, selfField);
        this.targetEntityClass = this.relationFieldWrapper.getMappingType();
        this.targetSchema = targetSchema;
        this.targetTable = targetTable;
        this.targetField = ClassUtil.getFirstField(this.targetEntityClass, field -> field.getName().equals(targetField));
        this.targetFieldWrapper = FieldWrapper.of(this.targetEntityClass, targetField);
        this.targetTableInfo = TableInfoFactory.ofEntityClass(this.targetEntityClass);
        this.conditionColumn = QueryMethods.column(targetTable, this.targetTableInfo.getColumnByProperty(this.targetField.getName()));
        if (ArrayUtil.isNotEmpty(selectColumns)) {
            this.selectColumns = ArrayUtil.contains(selectColumns, this.conditionColumn.getName()) ? selectColumns : ArrayUtil.concat(selectColumns, new String[]{this.conditionColumn.getName()});
        }
        this.initExtraCondition(extraCondition);
    }

    protected void initExtraCondition(String extraCondition) {
        if (StringUtil.isBlank(extraCondition)) {
            return;
        }
        List sqlParamKeys = null;
        char[] chars = extraCondition.toCharArray();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(chars[0]);
        boolean keyStart = false;
        StringBuilder currentKey = null;
        for (int i = 1; i < chars.length; ++i) {
            char prev = chars[i - 1];
            char current = chars[i];
            if (prev == ' ' && current == ':') {
                keyStart = true;
                currentKey = new StringBuilder();
                continue;
            }
            if (keyStart) {
                if (current != ' ' && current != ')') {
                    currentKey.append(current);
                    continue;
                }
                if (sqlParamKeys == null) {
                    sqlParamKeys = new ArrayList();
                }
                sqlParamKeys.add(currentKey.toString());
                sqlBuilder.append("?").append(current);
                keyStart = false;
                currentKey = null;
                continue;
            }
            sqlBuilder.append(current);
        }
        if (keyStart && currentKey != null && currentKey.length() > 0) {
            if (sqlParamKeys == null) {
                sqlParamKeys = new ArrayList();
            }
            sqlParamKeys.add(currentKey.toString());
            sqlBuilder.append(" ?");
        }
        this.extraConditionSql = sqlBuilder.toString();
        this.extraConditionParamKeys = sqlParamKeys != null ? sqlParamKeys : Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Class<SelfEntity> getSelfEntityClass() {
        return this.selfEntityClass;
    }

    public void setSelfEntityClass(Class<SelfEntity> selfEntityClass) {
        this.selfEntityClass = selfEntityClass;
    }

    public Field getRelationField() {
        return this.relationField;
    }

    public void setRelationField(Field relationField) {
        this.relationField = relationField;
    }

    public FieldWrapper getRelationFieldWrapper() {
        return this.relationFieldWrapper;
    }

    public void setRelationFieldWrapper(FieldWrapper relationFieldWrapper) {
        this.relationFieldWrapper = relationFieldWrapper;
    }

    public Field getSelfField() {
        return this.selfField;
    }

    public void setSelfField(Field selfField) {
        this.selfField = selfField;
    }

    public FieldWrapper getSelfFieldWrapper() {
        return this.selfFieldWrapper;
    }

    public void setSelfFieldWrapper(FieldWrapper selfFieldWrapper) {
        this.selfFieldWrapper = selfFieldWrapper;
    }

    public Field getTargetField() {
        return this.targetField;
    }

    public void setTargetField(Field targetField) {
        this.targetField = targetField;
    }

    public Class<?> getTargetEntityClass() {
        return this.targetEntityClass;
    }

    public void setTargetEntityClass(Class<?> targetEntityClass) {
        this.targetEntityClass = targetEntityClass;
    }

    public TableInfo getTargetTableInfo() {
        return this.targetTableInfo;
    }

    public void setTargetTableInfo(TableInfo targetTableInfo) {
        this.targetTableInfo = targetTableInfo;
    }

    public FieldWrapper getTargetFieldWrapper() {
        return this.targetFieldWrapper;
    }

    public void setTargetFieldWrapper(FieldWrapper targetFieldWrapper) {
        this.targetFieldWrapper = targetFieldWrapper;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }

    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(String joinTable) {
        this.joinTable = joinTable;
    }

    public String getJoinSelfColumn() {
        return this.joinSelfColumn;
    }

    public void setJoinSelfColumn(String joinSelfColumn) {
        this.joinSelfColumn = joinSelfColumn;
    }

    public String getJoinTargetColumn() {
        return this.joinTargetColumn;
    }

    public void setJoinTargetColumn(String joinTargetColumn) {
        this.joinTargetColumn = joinTargetColumn;
    }

    public Set<Object> getSelfFieldValues(List<SelfEntity> selfEntities) {
        if (selfEntities == null || selfEntities.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
        selfEntities.forEach(self -> {
            Object value = this.selfFieldWrapper.get(self);
            if (value != null && !"".equals(value)) {
                values.add(value);
            }
        });
        return values;
    }

    public Class<?> getMappingType() {
        return this.relationFieldWrapper.getMappingType();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getTargetTableWithSchema() {
        if (StringUtil.isNotBlank(this.targetTable)) {
            return StringUtil.isNotBlank(this.targetSchema) ? this.targetSchema + "." + this.targetTable : this.targetTable;
        }
        return this.targetTableInfo.getTableNameWithSchema();
    }

    protected boolean isRelationByMiddleTable() {
        return StringUtil.isNotBlank(this.joinTable);
    }

    protected static Class<?> getTargetEntityClass(Class<?> entityClass, Field relationField) {
        return FieldWrapper.of(entityClass, relationField.getName()).getMappingType();
    }

    protected static String getDefaultPrimaryProperty(String key, Class<?> entityClass, String message) {
        if (StringUtil.isNotBlank(key)) {
            return key;
        }
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        List<IdInfo> primaryKeyList = tableInfo.getPrimaryKeyList();
        if (primaryKeyList == null || primaryKeyList.size() != 1) {
            throw FlexExceptions.wrap(message, new Object[0]);
        }
        return primaryKeyList.get(0).getProperty();
    }

    public QueryWrapper buildQueryWrapper(Set<Object> targetValues) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        if (ArrayUtil.isNotEmpty(this.selectColumns)) {
            queryWrapper.select(this.selectColumns);
        }
        queryWrapper.from(this.getTargetTableWithSchema());
        if (targetValues.size() > 1) {
            queryWrapper.where((QueryCondition)this.conditionColumn.in(targetValues));
        } else {
            queryWrapper.where(this.conditionColumn.eq(targetValues.iterator().next()));
        }
        if (StringUtil.isNotBlank(this.extraConditionSql)) {
            queryWrapper.and(this.extraConditionSql, RelationManager.getExtraConditionParams(this.extraConditionParamKeys));
        }
        this.customizeQueryWrapper(queryWrapper);
        return queryWrapper;
    }

    public void customizeQueryWrapper(QueryWrapper queryWrapper) {
    }

    public abstract void join(List<SelfEntity> var1, List<?> var2, List<Row> var3);
}

