/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.constant.SqlOperator;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.ArithmeticQueryColumn;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.Conditional;
import com.mybatisflex.core.query.QueryColumnBehavior;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public class QueryColumn
implements CloneSupport<QueryColumn>,
Conditional<QueryCondition> {
    protected QueryTable table;
    protected String name;
    protected String alias;
    private boolean returnCopyByAsMethod = false;

    public QueryColumn() {
    }

    public QueryColumn(String name) {
        SqlUtil.keepColumnSafely(name);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(tableName);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String schema, String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(schema, tableName);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String schema, String tableName, String name, String alias) {
        SqlUtil.keepColumnSafely(name);
        this.returnCopyByAsMethod = true;
        this.table = new QueryTable(schema, tableName);
        this.name = StringUtil.tryTrim(name);
        this.alias = StringUtil.tryTrim(alias);
    }

    public QueryColumn(QueryTable queryTable, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = queryTable;
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(TableDef tableDef, String name) {
        this(tableDef, name, null);
    }

    public QueryColumn(TableDef tableDef, String name, String alias) {
        SqlUtil.keepColumnSafely(name);
        this.returnCopyByAsMethod = true;
        this.table = new QueryTable(tableDef);
        this.name = name;
        this.alias = alias;
    }

    public QueryTable getTable() {
        return this.table;
    }

    public void setTable(QueryTable table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public <T> QueryColumn as(LambdaGetter<T> fn) {
        return this.as(fn, false);
    }

    public <T> QueryColumn as(LambdaGetter<T> fn, boolean withPrefix) {
        return this.as(LambdaUtil.getAliasName(fn, withPrefix));
    }

    public QueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        if (this.returnCopyByAsMethod) {
            QueryColumn newColumn = new QueryColumn();
            newColumn.table = this.table;
            newColumn.name = this.name;
            newColumn.alias = alias;
            return newColumn;
        }
        this.alias = alias;
        return this;
    }

    @Override
    public QueryCondition eq(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.EQUALS, value);
    }

    @Override
    public QueryCondition eq(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.EQUALS, value).when(isEffective);
    }

    @Override
    public QueryCondition eq(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.EQUALS, value).when(isEffective);
    }

    @Override
    public <T> QueryCondition eq(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.EQUALS, value).when(isEffective.test(value));
    }

    @Override
    public QueryCondition ne(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_EQUALS, value);
    }

    @Override
    public QueryCondition ne(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_EQUALS, value).when(isEffective);
    }

    @Override
    public QueryCondition ne(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_EQUALS, value).when(isEffective);
    }

    @Override
    public <T> QueryCondition ne(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_EQUALS, value).when(isEffective.test(value));
    }

    @Override
    public QueryCondition gt(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.GT, value);
    }

    @Override
    public QueryCondition gt(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.GT, value).when(isEffective);
    }

    @Override
    public QueryCondition gt(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.GT, value).when(isEffective);
    }

    @Override
    public <T> QueryCondition gt(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.GT, value).when(isEffective.test(value));
    }

    @Override
    public QueryCondition ge(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.GE, value);
    }

    @Override
    public QueryCondition ge(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.GE, value).when(isEffective);
    }

    @Override
    public QueryCondition ge(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.GE, value).when(isEffective);
    }

    @Override
    public <T> QueryCondition ge(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.GE, value).when(isEffective.test(value));
    }

    @Override
    public QueryCondition lt(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LT, value);
    }

    @Override
    public QueryCondition lt(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LT, value).when(isEffective);
    }

    @Override
    public QueryCondition lt(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LT, value).when(isEffective);
    }

    @Override
    public <T> QueryCondition lt(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LT, value).when(isEffective.test(value));
    }

    @Override
    public QueryCondition le(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LE, value);
    }

    @Override
    public QueryCondition le(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LE, value).when(isEffective);
    }

    @Override
    public QueryCondition le(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LE, value).when(isEffective);
    }

    @Override
    public <T> QueryCondition le(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LE, value).when(isEffective.test(value));
    }

    @Override
    public QueryCondition in(Object ... value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value) || value.length == 0) {
            return QueryCondition.createEmpty();
        }
        if (value.length == 1) {
            if (QueryColumnBehavior.shouldIgnoreValue(value[0])) {
                return QueryCondition.createEmpty();
            }
            if (QueryColumnBehavior.isSmartConvertInToEquals()) {
                return QueryCondition.create(this, SqlOperator.EQUALS, value[0]);
            }
        }
        return QueryCondition.create(this, " IN ", (Object)value);
    }

    @Override
    public QueryCondition in(Object[] value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value) || value.length == 0) {
            return QueryCondition.createEmpty();
        }
        if (value.length == 1) {
            if (QueryColumnBehavior.shouldIgnoreValue(value[0])) {
                return QueryCondition.createEmpty();
            }
            if (QueryColumnBehavior.isSmartConvertInToEquals()) {
                return QueryCondition.create(this, SqlOperator.EQUALS, value[0]).when(isEffective);
            }
        }
        return QueryCondition.create(this, " IN ", (Object)value).when(isEffective);
    }

    @Override
    public QueryCondition in(Object[] value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value) || value.length == 0) {
            return QueryCondition.createEmpty();
        }
        if (value.length == 1) {
            if (QueryColumnBehavior.shouldIgnoreValue(value[0])) {
                return QueryCondition.createEmpty();
            }
            if (QueryColumnBehavior.isSmartConvertInToEquals()) {
                return QueryCondition.create(this, SqlOperator.EQUALS, value[0]).when(isEffective);
            }
        }
        return QueryCondition.create(this, " IN ", (Object)value).when(isEffective);
    }

    @Override
    public <T> QueryCondition in(T[] value, Predicate<T[]> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value) || value.length == 0) {
            return QueryCondition.createEmpty();
        }
        if (value.length == 1) {
            if (QueryColumnBehavior.shouldIgnoreValue(value[0])) {
                return QueryCondition.createEmpty();
            }
            if (QueryColumnBehavior.isSmartConvertInToEquals()) {
                return QueryCondition.create(this, SqlOperator.EQUALS, value[0]).when(isEffective.test(value));
            }
        }
        return QueryCondition.create(this, " IN ", value).when(isEffective.test(value));
    }

    @Override
    public QueryCondition in(Collection<?> value) {
        if (value == null || value.isEmpty()) {
            return QueryCondition.createEmpty();
        }
        return this.in(value.toArray());
    }

    @Override
    public QueryCondition in(Collection<?> value, boolean isEffective) {
        if (value == null || value.isEmpty()) {
            return QueryCondition.createEmpty();
        }
        return this.in(value.toArray()).when(isEffective);
    }

    @Override
    public QueryCondition in(Collection<?> value, BooleanSupplier isEffective) {
        if (value == null || value.isEmpty()) {
            return QueryCondition.createEmpty();
        }
        return this.in(value.toArray()).when(isEffective);
    }

    @Override
    public <T extends Collection<?>> QueryCondition in(T value, Predicate<T> isEffective) {
        if (value == null || value.isEmpty()) {
            return QueryCondition.createEmpty();
        }
        return this.in(value.toArray()).when(isEffective.test(value));
    }

    @Override
    public QueryCondition in(QueryWrapper queryWrapper) {
        if (queryWrapper == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.IN, (Object)queryWrapper);
    }

    @Override
    public QueryCondition in(QueryWrapper queryWrapper, boolean isEffective) {
        if (queryWrapper == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.IN, (Object)queryWrapper).when(isEffective);
    }

    @Override
    public QueryCondition in(QueryWrapper queryWrapper, BooleanSupplier isEffective) {
        if (queryWrapper == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.IN, (Object)queryWrapper).when(isEffective);
    }

    @Override
    public QueryCondition notIn(Object ... value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value) || value.length == 0) {
            return QueryCondition.createEmpty();
        }
        if (value.length == 1) {
            if (QueryColumnBehavior.shouldIgnoreValue(value[0])) {
                return QueryCondition.createEmpty();
            }
            if (QueryColumnBehavior.isSmartConvertInToEquals()) {
                return QueryCondition.create(this, SqlOperator.NOT_EQUALS, value[0]);
            }
        }
        return QueryCondition.create(this, " NOT IN ", (Object)value);
    }

    @Override
    public QueryCondition notIn(Object[] value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value) || value.length == 0) {
            return QueryCondition.createEmpty();
        }
        if (value.length == 1) {
            if (QueryColumnBehavior.shouldIgnoreValue(value[0])) {
                return QueryCondition.createEmpty();
            }
            if (QueryColumnBehavior.isSmartConvertInToEquals()) {
                return QueryCondition.create(this, SqlOperator.NOT_EQUALS, value[0]).when(isEffective);
            }
        }
        return QueryCondition.create(this, " NOT IN ", (Object)value).when(isEffective);
    }

    @Override
    public QueryCondition notIn(Object[] value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value) || value.length == 0) {
            return QueryCondition.createEmpty();
        }
        if (value.length == 1) {
            if (QueryColumnBehavior.shouldIgnoreValue(value[0])) {
                return QueryCondition.createEmpty();
            }
            if (QueryColumnBehavior.isSmartConvertInToEquals()) {
                return QueryCondition.create(this, SqlOperator.NOT_EQUALS, value[0]).when(isEffective);
            }
        }
        return QueryCondition.create(this, " NOT IN ", (Object)value).when(isEffective);
    }

    @Override
    public <T> QueryCondition notIn(T[] value, Predicate<T[]> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value) || value.length == 0) {
            return QueryCondition.createEmpty();
        }
        if (value.length == 1) {
            if (QueryColumnBehavior.shouldIgnoreValue(value[0])) {
                return QueryCondition.createEmpty();
            }
            if (QueryColumnBehavior.isSmartConvertInToEquals()) {
                return QueryCondition.create(this, SqlOperator.NOT_EQUALS, value[0]).when(isEffective.test(value));
            }
        }
        return QueryCondition.create(this, " NOT IN ", value).when(isEffective.test(value));
    }

    @Override
    public QueryCondition notIn(Collection<?> value) {
        if (value == null || value.isEmpty()) {
            return QueryCondition.createEmpty();
        }
        return this.notIn(value.toArray());
    }

    @Override
    public QueryCondition notIn(Collection<?> value, boolean isEffective) {
        if (value == null || value.isEmpty()) {
            return QueryCondition.createEmpty();
        }
        return this.notIn(value.toArray()).when(isEffective);
    }

    @Override
    public QueryCondition notIn(Collection<?> value, BooleanSupplier isEffective) {
        if (value == null || value.isEmpty()) {
            return QueryCondition.createEmpty();
        }
        return this.notIn(value.toArray()).when(isEffective);
    }

    @Override
    public <T extends Collection<?>> QueryCondition notIn(T value, Predicate<T> isEffective) {
        if (value == null || value.isEmpty()) {
            return QueryCondition.createEmpty();
        }
        return this.notIn(value.toArray()).when(isEffective.test(value));
    }

    @Override
    public QueryCondition notIn(QueryWrapper queryWrapper) {
        if (queryWrapper == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_IN, (Object)queryWrapper);
    }

    @Override
    public QueryCondition notIn(QueryWrapper queryWrapper, boolean isEffective) {
        if (queryWrapper == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_IN, (Object)queryWrapper).when(isEffective);
    }

    @Override
    public QueryCondition notIn(QueryWrapper queryWrapper, BooleanSupplier isEffective) {
        if (queryWrapper == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_IN, (Object)queryWrapper).when(isEffective);
    }

    @Override
    public QueryCondition between(Object start, Object end) {
        if (QueryColumnBehavior.shouldIgnoreValue(start) || QueryColumnBehavior.shouldIgnoreValue(end)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.BETWEEN, (Object)new Object[]{start, end});
    }

    @Override
    public QueryCondition between(Object start, Object end, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(start) || QueryColumnBehavior.shouldIgnoreValue(end)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.BETWEEN, (Object)new Object[]{start, end}).when(isEffective);
    }

    @Override
    public QueryCondition between(Object start, Object end, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(start) || QueryColumnBehavior.shouldIgnoreValue(end)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.BETWEEN, (Object)new Object[]{start, end}).when(isEffective);
    }

    @Override
    public <S, E> QueryCondition between(S start, E end, BiPredicate<S, E> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(start) || QueryColumnBehavior.shouldIgnoreValue(end)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.BETWEEN, (Object)new Object[]{start, end}).when(isEffective.test(start, end));
    }

    @Override
    public QueryCondition notBetween(Object start, Object end) {
        if (QueryColumnBehavior.shouldIgnoreValue(start) || QueryColumnBehavior.shouldIgnoreValue(end)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_BETWEEN, (Object)new Object[]{start, end});
    }

    @Override
    public QueryCondition notBetween(Object start, Object end, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(start) || QueryColumnBehavior.shouldIgnoreValue(end)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_BETWEEN, (Object)new Object[]{start, end}).when(isEffective);
    }

    @Override
    public QueryCondition notBetween(Object start, Object end, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(start) || QueryColumnBehavior.shouldIgnoreValue(end)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_BETWEEN, (Object)new Object[]{start, end}).when(isEffective);
    }

    @Override
    public <S, E> QueryCondition notBetween(S start, E end, BiPredicate<S, E> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(start) || QueryColumnBehavior.shouldIgnoreValue(end)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_BETWEEN, (Object)new Object[]{start, end}).when(isEffective.test(start, end));
    }

    @Override
    public QueryCondition like(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value + "%"));
    }

    @Override
    public QueryCondition like(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value + "%")).when(isEffective);
    }

    @Override
    public QueryCondition like(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value + "%")).when(isEffective);
    }

    @Override
    public <T> QueryCondition like(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value + "%")).when(isEffective.test(value));
    }

    @Override
    public QueryCondition likeLeft(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)(value + "%"));
    }

    @Override
    public QueryCondition likeLeft(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)(value + "%")).when(isEffective);
    }

    @Override
    public QueryCondition likeLeft(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)(value + "%")).when(isEffective);
    }

    @Override
    public <T> QueryCondition likeLeft(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)(value + "%")).when(isEffective.test(value));
    }

    @Override
    public QueryCondition likeRight(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value));
    }

    @Override
    public QueryCondition likeRight(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value)).when(isEffective);
    }

    @Override
    public QueryCondition likeRight(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value)).when(isEffective);
    }

    @Override
    public <T> QueryCondition likeRight(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value)).when(isEffective.test(value));
    }

    public QueryCondition likeRaw(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeRaw(value, true);
    }

    public QueryCondition likeRaw(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.LIKE, value).when(isEffective);
    }

    public QueryCondition likeRaw(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeRaw(value, isEffective.getAsBoolean());
    }

    public <T> QueryCondition likeRaw(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeRaw(value, isEffective.test(value));
    }

    @Override
    public QueryCondition notLike(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value + "%"));
    }

    @Override
    public QueryCondition notLike(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value + "%")).when(isEffective);
    }

    @Override
    public QueryCondition notLike(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value + "%")).when(isEffective);
    }

    @Override
    public <T> QueryCondition notLike(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value + "%")).when(isEffective.test(value));
    }

    @Override
    public QueryCondition notLikeLeft(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)(value + "%"));
    }

    @Override
    public QueryCondition notLikeLeft(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)(value + "%")).when(isEffective);
    }

    @Override
    public QueryCondition notLikeLeft(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)(value + "%")).when(isEffective);
    }

    @Override
    public <T> QueryCondition notLikeLeft(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)(value + "%")).when(isEffective.test(value));
    }

    @Override
    public QueryCondition notLikeRight(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value));
    }

    @Override
    public QueryCondition notLikeRight(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value)).when(isEffective);
    }

    @Override
    public QueryCondition notLikeRight(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value)).when(isEffective);
    }

    @Override
    public <T> QueryCondition notLikeRight(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value)).when(isEffective.test(value));
    }

    public QueryCondition notLikeRaw(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeRaw(value, true);
    }

    public QueryCondition notLikeRaw(Object value, boolean isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, SqlOperator.NOT_LIKE, value).when(isEffective);
    }

    public QueryCondition notLikeRaw(Object value, BooleanSupplier isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeRaw(value, isEffective.getAsBoolean());
    }

    public <T> QueryCondition notLikeRaw(T value, Predicate<T> isEffective) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeRaw(value, isEffective.test(value));
    }

    @Override
    public QueryCondition isNull(boolean isEffective) {
        return QueryCondition.create(this, SqlOperator.IS_NULL, null).when(isEffective);
    }

    @Override
    public QueryCondition isNotNull(boolean isEffective) {
        return QueryCondition.create(this, SqlOperator.IS_NOT_NULL, null).when(isEffective);
    }

    public QueryOrderBy asc() {
        return new QueryOrderBy(this, " ASC");
    }

    public QueryOrderBy desc() {
        return new QueryOrderBy(this, " DESC");
    }

    public QueryColumn add(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).add(queryColumn);
    }

    public QueryColumn add(Number number) {
        return new ArithmeticQueryColumn(this).add(number);
    }

    public QueryColumn subtract(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).subtract(queryColumn);
    }

    public QueryColumn subtract(Number number) {
        return new ArithmeticQueryColumn(this).subtract(number);
    }

    public QueryColumn multiply(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).multiply(queryColumn);
    }

    public QueryColumn multiply(Number number) {
        return new ArithmeticQueryColumn(this).multiply(number);
    }

    public QueryColumn divide(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).divide(queryColumn);
    }

    public QueryColumn divide(Number number) {
        return new ArithmeticQueryColumn(this).divide(number);
    }

    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        QueryTable selectTable = this.getSelectTable(queryTables, this.table);
        if (selectTable == null) {
            return dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.alias)) {
            return dialect.wrap(selectTable.alias) + "." + dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.getSchema()) && StringUtil.isNotBlank(selectTable.getName())) {
            String realTable = dialect.getRealTable(selectTable.getName());
            return dialect.wrap(dialect.getRealSchema(selectTable.schema, realTable)) + "." + dialect.wrap(realTable) + "." + dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.getName())) {
            return dialect.wrap(dialect.getRealTable(selectTable.getName())) + "." + dialect.wrap(this.name);
        }
        return dialect.wrap(this.name);
    }

    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        return this.toConditionSql(queryTables, dialect) + WrapperUtil.buildColumnAlias(this.alias, dialect);
    }

    QueryTable getSelectTable(List<QueryTable> queryTables, QueryTable selfTable) {
        if (queryTables == null || queryTables.isEmpty()) {
            return null;
        }
        if (selfTable != null && StringUtil.isNotBlank(selfTable.alias)) {
            return selfTable;
        }
        if (queryTables.size() == 1 && queryTables.get(0).isSameTable(selfTable)) {
            return null;
        }
        if (CollectionUtil.isEmpty(queryTables)) {
            return selfTable;
        }
        if (selfTable == null && queryTables.size() == 1) {
            return queryTables.get(0);
        }
        for (QueryTable table : queryTables) {
            if (!table.isSameTable(selfTable)) continue;
            return table;
        }
        return selfTable;
    }

    public String toString() {
        return "QueryColumn{table=" + this.table + ", name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + '}';
    }

    @Override
    public QueryColumn clone() {
        try {
            QueryColumn clone = (QueryColumn)super.clone();
            clone.table = ObjectUtil.clone(this.table);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

