/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.relation;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.relation.AbstractRelation;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.FieldWrapper;
import com.mybatisflex.core.util.MapperUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ToManyRelation<SelfEntity>
extends AbstractRelation<SelfEntity> {
    protected String mapKeyField;
    protected FieldWrapper mapKeyFieldWrapper;
    protected String orderBy;
    protected long limit = 0L;
    protected String selfValueSplitBy;

    public ToManyRelation(String selfField, String targetSchema, String targetTable, String targetField, String valueField, String joinTable, String joinSelfColumn, String joinTargetColumn, String dataSource, Class<SelfEntity> selfEntityClass, Field relationField, String extraCondition, String[] selectColumns) {
        super(selfField, targetSchema, targetTable, targetField, valueField, joinTable, joinSelfColumn, joinTargetColumn, dataSource, selfEntityClass, relationField, extraCondition, selectColumns);
    }

    @Override
    public QueryWrapper buildQueryWrapper(Set<Object> targetValues) {
        if (StringUtil.isNotBlank(this.selfValueSplitBy) && CollectionUtil.isNotEmpty(targetValues)) {
            HashSet<Object> newTargetValues = new HashSet<Object>();
            for (Object targetValue : targetValues) {
                String[] splitValues;
                if (targetValue == null) continue;
                if (!(targetValue instanceof String)) {
                    throw FlexExceptions.wrap("split field only support String type, but current type is: \"" + targetValue.getClass().getName() + "\"", new Object[0]);
                }
                for (String splitValue : splitValues = ((String)targetValue).split(this.selfValueSplitBy)) {
                    newTargetValues.add(ConvertUtil.convert(splitValue, this.targetFieldWrapper.getFieldType()));
                }
            }
            targetValues = newTargetValues;
        }
        return super.buildQueryWrapper(targetValues);
    }

    @Override
    public void customizeQueryWrapper(QueryWrapper queryWrapper) {
        if (StringUtil.isNotBlank(this.orderBy)) {
            queryWrapper.orderBy(this.orderBy);
        }
        if (this.limit > 0L) {
            queryWrapper.limit(this.limit);
        }
    }

    @Override
    public void join(List<SelfEntity> selfEntities, List<?> targetObjectList, List<Row> mappingRows) {
        selfEntities.forEach(selfEntity -> {
            Object selfValue = this.selfFieldWrapper.get(selfEntity);
            if (selfValue != null) {
                Class<Object> wrapType;
                selfValue = selfValue.toString();
                HashSet<String> targetMappingValues = new HashSet<String>();
                if (mappingRows != null) {
                    for (Row mappingRow : mappingRows) {
                        Object joinValue;
                        if (!selfValue.equals(String.valueOf(mappingRow.getIgnoreCase(this.joinSelfColumn))) || (joinValue = mappingRow.getIgnoreCase(this.joinTargetColumn)) == null) continue;
                        targetMappingValues.add(joinValue.toString());
                    }
                } else if (StringUtil.isNotBlank(this.selfValueSplitBy)) {
                    String[] splitValues = ((String)selfValue).split(this.selfValueSplitBy);
                    targetMappingValues.addAll(Arrays.asList(splitValues));
                } else {
                    targetMappingValues.add((String)selfValue);
                }
                if (targetMappingValues.isEmpty()) {
                    return;
                }
                Class<?> fieldType = this.relationFieldWrapper.getFieldType();
                if (Map.class.isAssignableFrom(fieldType)) {
                    wrapType = ToManyRelation.getMapWrapType(fieldType);
                    Map map = ClassUtil.newInstance(wrapType);
                    for (Object targetObject : targetObjectList) {
                        Object targetValue = this.targetFieldWrapper.get(targetObject);
                        if (targetValue == null || !targetMappingValues.contains(targetValue.toString())) continue;
                        Object keyValue = this.mapKeyFieldWrapper.get(targetObject);
                        Object needKeyValue = ConvertUtil.convert(keyValue, this.relationFieldWrapper.getKeyType());
                        map.put(needKeyValue, targetObject);
                    }
                    this.relationFieldWrapper.set(map, selfEntity);
                } else {
                    wrapType = MapperUtil.getCollectionWrapType(fieldType);
                    Collection collection = (Collection)((Object)ClassUtil.newInstance(wrapType));
                    for (Object targetObject : targetObjectList) {
                        Object targetValue = this.targetFieldWrapper.get(targetObject);
                        if (targetValue == null || !targetMappingValues.contains(targetValue.toString())) continue;
                        if (this.onlyQueryValueField) {
                            collection.add(FieldWrapper.of(targetObject.getClass(), this.valueField).get(targetObject));
                            continue;
                        }
                        collection.add(targetObject);
                    }
                    this.relationFieldWrapper.set(collection, selfEntity);
                }
            }
        });
    }

    public void setMapKeyField(String mapKeyField) {
        this.mapKeyField = mapKeyField;
        if (StringUtil.isNotBlank(mapKeyField)) {
            this.mapKeyFieldWrapper = FieldWrapper.of(this.targetEntityClass, mapKeyField);
        } else if (Map.class.isAssignableFrom(this.relationFieldWrapper.getFieldType())) {
            throw FlexExceptions.wrap("Please config mapKeyField for map field: " + this.relationFieldWrapper.getField(), new Object[0]);
        }
    }

    public static Class<? extends Map> getMapWrapType(Class<?> type) {
        if (ClassUtil.canInstance(type.getModifiers())) {
            return type;
        }
        return HashMap.class;
    }
}

