/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.QueryWrapperAdapter;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowKey;
import com.mybatisflex.core.table.ColumnInfo;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.update.PropertySetter;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.SqlUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DbChain
extends QueryWrapperAdapter<DbChain>
implements PropertySetter<DbChain> {
    private String schema;
    private final String tableName;
    private Row rowData;

    private DbChain(String tableName) {
        this.tableName = tableName;
    }

    private DbChain(String schema, String tableName) {
        this.schema = schema;
        this.tableName = tableName;
    }

    public static DbChain create() {
        throw new UnsupportedOperationException("Please use DbChain#table(...) to replace DbChain.create()");
    }

    public static DbChain create(Object entity) {
        throw new UnsupportedOperationException("Please use DbChain#table(...) to replace DbChain.create(entity)");
    }

    public static DbChain table(String tableName) {
        return new DbChain(tableName);
    }

    public static DbChain table(String schema, String tableName) {
        return new DbChain(schema, tableName);
    }

    public static DbChain table(Class<?> entityClass) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        return DbChain.table(tableInfo.getSchema(), tableInfo.getTableName());
    }

    public static DbChain table(TableDef tableDef) {
        return DbChain.table(tableDef.getSchema(), tableDef.getTableName());
    }

    private Row getRow() {
        if (this.rowData == null) {
            this.rowData = new Row();
        }
        return this.rowData;
    }

    public DbChain setId(RowKey rowKey) {
        this.getRow().getPrimaryKeys().add(rowKey);
        return this;
    }

    public DbChain setId(RowKey rowKey, Object value) {
        this.getRow().getPrimaryKeys().add(rowKey);
        this.getRow().put(rowKey.keyColumn, value);
        return this;
    }

    @Override
    public DbChain set(String property, Object value, boolean isEffective) {
        this.getRow().set(property, value, isEffective);
        return this;
    }

    @Override
    public DbChain set(QueryColumn property, Object value, boolean isEffective) {
        this.getRow().set(property, value, isEffective);
        return this;
    }

    @Override
    public <T> DbChain set(LambdaGetter<T> property, Object value, boolean isEffective) {
        this.getRow().set((LambdaGetter)property, value, isEffective);
        return this;
    }

    @Override
    public DbChain setRaw(String property, Object value, boolean isEffective) {
        this.getRow().setRaw(property, value, isEffective);
        return this;
    }

    @Override
    public DbChain setRaw(QueryColumn property, Object value, boolean isEffective) {
        this.getRow().setRaw(property, value, isEffective);
        return this;
    }

    @Override
    public <T> DbChain setRaw(LambdaGetter<T> property, Object value, boolean isEffective) {
        this.getRow().setRaw((LambdaGetter)property, value, isEffective);
        return this;
    }

    public boolean save(Object entity) {
        return SqlUtil.toBool(Db.insert(this.schema, this.tableName, DbChain.toRow(entity)));
    }

    public boolean save() {
        return SqlUtil.toBool(Db.insert(this.schema, this.tableName, this.getRow()));
    }

    public boolean remove() {
        return SqlUtil.toBool(Db.deleteByQuery(this.schema, this.tableName, this));
    }

    public boolean removeById() {
        return SqlUtil.toBool(Db.deleteById(this.schema, this.tableName, this.getRow()));
    }

    public boolean update() {
        return SqlUtil.toBool(Db.updateByQuery(this.schema, this.tableName, this.getRow(), this));
    }

    public boolean updateById() {
        return SqlUtil.toBool(Db.updateById(this.schema, this.tableName, this.getRow()));
    }

    private static Row toRow(Object entity) {
        Object value;
        Field declaredField;
        Class<?> entityClass = entity.getClass();
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entity.getClass());
        Row row = new Row();
        for (ColumnInfo columnInfo : tableInfo.getColumnInfoList()) {
            try {
                declaredField = entityClass.getDeclaredField(columnInfo.getProperty());
                declaredField.setAccessible(true);
                value = declaredField.get(entity);
                if (value == null) continue;
                row.put(columnInfo.getColumn(), value);
            }
            catch (Exception e) {
                throw FlexExceptions.wrap(e);
            }
        }
        for (IdInfo idInfo : tableInfo.getPrimaryKeyList()) {
            try {
                declaredField = entityClass.getDeclaredField(idInfo.getProperty());
                declaredField.setAccessible(true);
                value = declaredField.get(entity);
                if (value == null) continue;
                RowKey rowKey = RowKey.of(idInfo.getColumn(), idInfo.getKeyType(), idInfo.getValue(), idInfo.getBefore());
                row.getPrimaryKeys().add(rowKey);
                row.put(rowKey.keyColumn, value);
            }
            catch (Exception e) {
                throw FlexExceptions.wrap(e);
            }
        }
        return row;
    }

    public boolean update(Object entity) {
        return this.update(DbChain.toRow(entity));
    }

    public boolean update(Row data) {
        return SqlUtil.toBool(Db.updateByQuery(this.schema, this.tableName, data, this));
    }

    public boolean update(Map<String, Object> data) {
        Row row = new Row();
        row.putAll(data);
        return this.update(row);
    }

    public long count() {
        return Db.selectCountByQuery(this.schema, this.tableName, this);
    }

    public boolean exists() {
        return SqlUtil.toBool(this.count());
    }

    public Row one() {
        return Db.selectOneByQuery(this.schema, this.tableName, this);
    }

    public Optional<Row> oneOpt() {
        return Optional.ofNullable(this.one());
    }

    public <R> R oneAs(Class<R> asType) {
        return this.one().toEntity(asType);
    }

    public <R> Optional<R> oneAsOpt(Class<R> asType) {
        return Optional.ofNullable(this.oneAs(asType));
    }

    public Object obj() {
        return Db.selectObject(this.schema, this.tableName, this);
    }

    public Optional<Object> objOpt() {
        return Optional.ofNullable(this.obj());
    }

    public <R> R objAs() {
        return (R)this.obj();
    }

    public <R> R objAs(Class<R> asType) {
        return asType.cast(this.obj());
    }

    public <R> Optional<R> objAsOpt() {
        return Optional.ofNullable(this.objAs());
    }

    public <R> Optional<R> objAsOpt(Class<R> asType) {
        return Optional.ofNullable(this.objAs(asType));
    }

    public List<Object> objList() {
        return Db.selectObjectList(this.schema, this.tableName, this);
    }

    public <R> List<R> objListAs() {
        return this.objList().stream().map(obj -> obj).collect(Collectors.toList());
    }

    public <R> List<R> objListAs(Class<R> asType) {
        return this.objList().stream().map(asType::cast).collect(Collectors.toList());
    }

    public List<Row> list() {
        return Db.selectListByQuery(this.schema, this.tableName, this);
    }

    public <R> List<R> listAs(Class<R> asType) {
        return this.list().stream().map(row -> row.toEntity(asType)).collect(Collectors.toList());
    }

    public Page<Row> page(Page<Row> page) {
        return Db.paginate(this.schema, this.tableName, page, (QueryWrapper)this);
    }

    public <R> Page<R> pageAs(Page<R> page, Class<R> asType) {
        Page<Row> rowPage = new Page<Row>();
        rowPage.setPageNumber(page.getPageNumber());
        rowPage.setPageSize(page.getPageSize());
        rowPage.setTotalRow(page.getTotalRow());
        return this.page(rowPage).map(row -> row.toEntity(asType));
    }
}

