/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.List;

public interface LimitOffsetProcessor {
    public static final LimitOffsetProcessor MYSQL = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" LIMIT ").append(limitOffset).append(", ").append(limitRows);
        } else if (limitRows != null) {
            sql.append(" LIMIT ").append(limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor POSTGRESQL = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" LIMIT ").append(limitRows).append(" OFFSET ").append(limitOffset);
        } else if (limitRows != null) {
            sql.append(" LIMIT ").append(limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor DERBY = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" OFFSET ").append(limitOffset).append(" ROWS FETCH NEXT ").append(limitRows).append(" ROWS ONLY");
        } else if (limitRows != null) {
            sql.append(" OFFSET ").append(0).append(" ROWS FETCH NEXT ").append(limitRows).append(" ROWS ONLY");
        }
        return sql;
    };
    public static final LimitOffsetProcessor SQLSERVER = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" OFFSET ").append(limitOffset).append(" ROWS FETCH NEXT ").append(limitRows).append(" ROWS ONLY");
        } else if (limitRows != null) {
            List<QueryOrderBy> orderBys = CPI.getOrderBys(queryWrapper);
            if (CollectionUtil.isNotEmpty(orderBys)) {
                sql.append(" OFFSET ").append(0).append(" ROWS FETCH NEXT ").append(limitRows).append(" ROWS ONLY");
            } else {
                sql.insert(6, " TOP " + limitRows);
            }
        }
        return sql;
    };
    public static final LimitOffsetProcessor SQLSERVER_2005 = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null) {
            String orderByString;
            if (limitOffset == null) {
                limitOffset = 0L;
            }
            List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
            List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
            List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
            String originalSQL = sql.toString();
            List<QueryOrderBy> orderBys = CPI.getOrderBys(queryWrapper);
            if (orderBys == null || orderBys.isEmpty()) {
                orderByString = "ORDER BY CURRENT_TIMESTAMP";
            } else {
                StringBuilder orderBySql = new StringBuilder(" ORDER BY ");
                int index = 0;
                for (QueryOrderBy orderBy : orderBys) {
                    orderBySql.append(orderBy.toSql(allTables, dialect));
                    if (index != orderBys.size() - 1) {
                        orderBySql.append(", ");
                    }
                    ++index;
                }
                originalSQL = originalSQL.substring(0, sql.lastIndexOf(" ORDER BY "));
                orderByString = orderBySql.toString();
            }
            StringBuilder newSql = new StringBuilder("WITH temp_datas AS(");
            newSql.append("SELECT ROW_NUMBER() OVER (").append(orderByString).append(") as __rn,").append(originalSQL.substring(6));
            newSql.append(")");
            newSql.append(" SELECT * FROM temp_datas WHERE __rn BETWEEN ").append(limitOffset + 1L).append(" AND ").append(limitOffset + limitRows);
            newSql.append(" ORDER BY __rn");
            return newSql;
        }
        return sql;
    };
    public static final LimitOffsetProcessor INFORMIX = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.insert(6, " SKIP " + limitOffset + " FIRST " + limitRows);
        } else if (limitRows != null) {
            sql.insert(6, " FIRST " + limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor SINODB = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.insert(6, " SKIP " + limitOffset + " FIRST " + limitRows);
        } else if (limitRows != null) {
            sql.insert(6, " FIRST " + limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor FIREBIRD = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" ROWS ").append(limitOffset).append(" TO ").append(limitOffset + limitRows);
        } else if (limitRows != null) {
            sql.insert(6, " FIRST " + limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor ORACLE = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null) {
            if (limitOffset == null) {
                limitOffset = 0L;
            }
            StringBuilder newSql = new StringBuilder("SELECT * FROM (SELECT TEMP_DATAS.*, ROWNUM RN FROM (");
            newSql.append((CharSequence)sql);
            newSql.append(") TEMP_DATAS WHERE ROWNUM <= ").append(limitOffset + limitRows).append(") WHERE RN > ").append(limitOffset);
            return newSql;
        }
        return sql;
    };
    public static final LimitOffsetProcessor SYBASE = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.insert(6, " TOP " + limitRows + " START AT " + (limitOffset + 1L));
        } else if (limitRows != null) {
            sql.insert(6, " TOP " + limitRows);
        }
        return sql;
    };

    public StringBuilder process(IDialect var1, StringBuilder var2, QueryWrapper var3, Long var4, Long var5);
}

