/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.provider;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.exception.FlexAssert;
import com.mybatisflex.core.provider.ProviderUtil;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowCPI;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class RowSqlProvider {
    public static final String METHOD_RAW_SQL = "providerRawSql";

    private RowSqlProvider() {
    }

    public static String providerRawSql(Map params) {
        return ProviderUtil.getSqlString(params);
    }

    public static String insert(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        String schema = ProviderUtil.getSchemaName(params);
        Row row = ProviderUtil.getRow(params);
        String sql = DialectFactory.getDialect().forInsertRow(schema, tableName, row);
        ProviderUtil.setSqlArgs(params, RowCPI.obtainInsertValues(row));
        return sql;
    }

    public static String insertBatchWithFirstRowColumns(Map params) {
        List<Row> rows = ProviderUtil.getRows(params);
        FlexAssert.notEmpty(rows, "rows");
        String tableName = ProviderUtil.getTableName(params);
        String schema = ProviderUtil.getSchemaName(params);
        LinkedHashSet<String> modifyAttrs = new LinkedHashSet<String>(RowCPI.getModifyAttrs(rows.get(0)));
        rows.forEach(row -> row.keep(modifyAttrs));
        String sql = DialectFactory.getDialect().forInsertBatchWithFirstRowColumns(schema, tableName, rows);
        Object[] values = new Object[]{};
        for (Row row2 : rows) {
            values = ArrayUtil.concat(values, RowCPI.obtainInsertValues(row2));
        }
        ProviderUtil.setSqlArgs(params, values);
        return sql;
    }

    public static String deleteById(Map params) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        FlexAssert.notEmpty(primaryValues, "primaryValues");
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        String sql = DialectFactory.getDialect().forDeleteById(schema, tableName, primaryKeys);
        ProviderUtil.setSqlArgs(params, primaryValues);
        return sql;
    }

    public static String deleteBatchByIds(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        String sql = DialectFactory.getDialect().forDeleteBatchByIds(schema, tableName, primaryKeys, primaryValues);
        ProviderUtil.setSqlArgs(params, primaryValues);
        return sql;
    }

    public static String deleteByQuery(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, schema, tableName);
        String sql = DialectFactory.getDialect().forDeleteByQuery(queryWrapper);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, valueArray);
        return sql;
    }

    public static String updateById(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        Row row = ProviderUtil.getRow(params);
        String sql = DialectFactory.getDialect().forUpdateById(schema, tableName, row);
        ProviderUtil.setSqlArgs(params, RowCPI.obtainAllModifyValues(row));
        return sql;
    }

    public static String updateByQuery(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        Row data = ProviderUtil.getRow(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, schema, tableName);
        String sql = DialectFactory.getDialect().forUpdateByQuery(queryWrapper, data);
        Object[] modifyValues = RowCPI.obtainModifyValues(data);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(modifyValues, valueArray));
        return sql;
    }

    public static String updateBatchById(Map params) {
        List<Row> rows = ProviderUtil.getRows(params);
        FlexAssert.notEmpty(rows, "rows");
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        String sql = DialectFactory.getDialect().forUpdateBatchById(schema, tableName, rows);
        Object[] values = FlexConsts.EMPTY_ARRAY;
        for (Row row : rows) {
            values = ArrayUtil.concat(values, RowCPI.obtainAllModifyValues(row));
        }
        ProviderUtil.setSqlArgs(params, values);
        return sql;
    }

    public static String updateEntity(Map params) {
        Object entity = ProviderUtil.getEntity(params);
        FlexAssert.notNull(entity, "entity can not be null");
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(ClassUtil.getUsefulClass(entity.getClass()));
        tableInfo.invokeOnUpdateListener(entity);
        String sql = DialectFactory.getDialect().forUpdateEntity(tableInfo, entity, false);
        Object[] updateValues = tableInfo.buildUpdateSqlArgs(entity, false, false);
        Object[] primaryValues = tableInfo.buildPkSqlArgs(entity);
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        FlexAssert.assertAreNotNull(primaryValues, "The value of primary key must not be null, entity[%s]", entity);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(updateValues, primaryValues, tenantIdArgs, new Object[0][]));
        return sql;
    }

    public static String selectOneById(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        String sql = DialectFactory.getDialect().forSelectOneById(schema, tableName, primaryKeys, primaryValues);
        ProviderUtil.setSqlArgs(params, primaryValues);
        return sql;
    }

    public static String selectListByQuery(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, schema, tableName);
        String sql = DialectFactory.getDialect().forSelectByQuery(queryWrapper);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, valueArray);
        return sql;
    }
}

