/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.WithDetail;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class WithValuesDetail
implements WithDetail {
    private List<Object> values;
    private QueryWrapper queryWrapper;

    public WithValuesDetail() {
    }

    public WithValuesDetail(List<Object> values, QueryWrapper queryWrapper) {
        this.values = values;
        this.queryWrapper = queryWrapper;
    }

    public QueryWrapper getQueryWrapper() {
        return this.queryWrapper;
    }

    public void setQueryWrapper(QueryWrapper queryWrapper) {
        this.queryWrapper = queryWrapper;
    }

    @Override
    public String toSql(IDialect dialect) {
        ArrayList<String> stringValues = new ArrayList<String>(this.values.size());
        for (Object value : this.values) {
            stringValues.add(String.valueOf(value));
        }
        StringBuilder sql = new StringBuilder("VALUES (").append(StringUtil.join(", ", stringValues)).append(") ");
        return sql.append(dialect.buildNoSelectSql(this.queryWrapper)).toString();
    }

    @Override
    public Object[] getParamValues() {
        return this.queryWrapper.getAllValueArray();
    }

    @Override
    public WithValuesDetail clone() {
        try {
            WithValuesDetail clone = (WithValuesDetail)super.clone();
            clone.values = CollectionUtil.newArrayList(this.values);
            clone.queryWrapper = this.queryWrapper.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

