/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.update;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.update.ModifyAttrsRecordHandler;
import com.mybatisflex.core.update.PropertySetter;
import com.mybatisflex.core.update.RawValue;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.UpdateEntity;
import java.io.Serializable;
import java.util.Map;
import org.apache.ibatis.javassist.util.proxy.ProxyObject;

public interface UpdateWrapper<T>
extends PropertySetter<UpdateWrapper<T>>,
Serializable {
    default public Map<String, Object> getUpdates() {
        ModifyAttrsRecordHandler handler = (ModifyAttrsRecordHandler)((ProxyObject)this).getHandler();
        return handler.getUpdates();
    }

    @Override
    default public UpdateWrapper<T> set(String property, Object value, boolean isEffective) {
        if (isEffective) {
            if (value instanceof QueryWrapper || value instanceof QueryColumn || value instanceof QueryCondition) {
                this.getUpdates().put(property, new RawValue(value));
            } else {
                this.getUpdates().put(property, value);
            }
        }
        return this;
    }

    @Override
    default public UpdateWrapper<T> set(QueryColumn property, Object value, boolean isEffective) {
        if (isEffective) {
            if (value instanceof QueryWrapper || value instanceof QueryColumn || value instanceof QueryCondition) {
                this.getUpdates().put(property.getName(), new RawValue(value));
            } else {
                this.getUpdates().put(property.getName(), value);
            }
        }
        return this;
    }

    @Override
    default public <E> UpdateWrapper<T> set(LambdaGetter<E> property, Object value, boolean isEffective) {
        if (isEffective) {
            if (value instanceof QueryWrapper || value instanceof QueryColumn || value instanceof QueryCondition) {
                this.getUpdates().put(LambdaUtil.getFieldName(property), new RawValue(value));
            } else {
                this.getUpdates().put(LambdaUtil.getFieldName(property), value);
            }
        }
        return this;
    }

    @Override
    default public UpdateWrapper<T> setRaw(String property, Object value, boolean isEffective) {
        if (isEffective) {
            this.getUpdates().put(property, new RawValue(value));
        }
        return this;
    }

    @Override
    default public UpdateWrapper<T> setRaw(QueryColumn property, Object value, boolean isEffective) {
        if (isEffective) {
            this.getUpdates().put(property.getName(), new RawValue(value));
        }
        return this;
    }

    @Override
    default public <E> UpdateWrapper<T> setRaw(LambdaGetter<E> property, Object value, boolean isEffective) {
        if (isEffective) {
            this.getUpdates().put(LambdaUtil.getFieldName(property), new RawValue(value));
        }
        return this;
    }

    public static <T> UpdateWrapper<T> of(T entity) {
        if (entity instanceof UpdateWrapper) {
            return (UpdateWrapper)entity;
        }
        return (UpdateWrapper)UpdateEntity.ofNotNull(entity);
    }

    public static <T> UpdateWrapper<T> of(Class<T> tClass) {
        return (UpdateWrapper)UpdateEntity.of(tClass);
    }

    default public T toEntity() {
        return (T)this;
    }
}

