/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.annotation.EnumValue;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.util.MapUtil;

public class EnumWrapper<E extends Enum<E>> {
    private static final Map<Class, EnumWrapper> cache = new ConcurrentHashMap<Class, EnumWrapper>();
    private boolean hasEnumValueAnnotation = false;
    private Class<?> enumClass;
    private E[] enums;
    private Field property;
    private Class<?> propertyType;
    private Method getterMethod;

    public static <R extends Enum<R>> EnumWrapper<R> of(Class<?> enumClass) {
        return (EnumWrapper)MapUtil.computeIfAbsent(cache, enumClass, EnumWrapper::new);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumWrapper(Class<E> enumClass) {
        Method enumValueMethod;
        this.enumClass = enumClass;
        this.enums = (Enum[])enumClass.getEnumConstants();
        Field enumValueField = ClassUtil.getFirstField(enumClass, field -> field.getAnnotation(EnumValue.class) != null);
        if (enumValueField != null) {
            this.hasEnumValueAnnotation = true;
        }
        if (this.hasEnumValueAnnotation) {
            String getterMethodName = "get" + StringUtil.firstCharToUpperCase(enumValueField.getName());
            Method getter = ClassUtil.getFirstMethod(enumClass, method -> {
                String methodName = method.getName();
                return methodName.equals(getterMethodName) && Modifier.isPublic(method.getModifiers());
            });
            this.propertyType = ClassUtil.getWrapType(enumValueField.getType());
            if (getter == null) {
                if (!Modifier.isPublic(enumValueField.getModifiers())) throw new IllegalStateException("Can not find method \"" + getterMethodName + "()\" in enum: " + enumClass.getName());
                this.property = enumValueField;
            } else {
                this.getterMethod = getter;
            }
        }
        if (this.hasEnumValueAnnotation || (enumValueMethod = ClassUtil.getFirstMethod(enumClass, method -> method.getAnnotation(EnumValue.class) != null)) == null) return;
        String methodName = enumValueMethod.getName();
        if (!methodName.startsWith("get") || methodName.length() <= 3) {
            throw new IllegalStateException("Can not find get method \"" + methodName + "()\" in enum: " + enumClass.getName());
        }
        this.getterMethod = enumValueMethod;
    }

    public Object getEnumValue(E object) {
        try {
            return this.getterMethod != null ? this.getterMethod.invoke(object, new Object[0]) : this.property.get(object);
        }
        catch (Exception e) {
            throw FlexExceptions.wrap(e);
        }
    }

    public E getEnum(Object value) {
        if (value != null) {
            for (E e : this.enums) {
                if (!value.equals(this.getEnumValue(e))) continue;
                return e;
            }
        }
        return null;
    }

    public boolean hasEnumValueAnnotation() {
        return this.hasEnumValueAnnotation;
    }

    public Class<?> getEnumClass() {
        return this.enumClass;
    }

    public E[] getEnums() {
        return this.enums;
    }

    public Field getProperty() {
        return this.property;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Method getGetterMethod() {
        return this.getterMethod;
    }
}

