/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.mybatis.TypeHandlerObject;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.SqlUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuditMessage
implements Serializable {
    private String platform;
    private String module;
    private String url;
    private String bizId;
    private String user;
    private String userIp;
    private String hostIp;
    private String query;
    private List<Object> queryParams;
    private int queryCount;
    private long queryTime;
    private long elapsedTime;
    private String dsName;
    private Map<String, Object> metas;

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<Object> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(List<Object> queryParams) {
        this.queryParams = queryParams;
    }

    public void addParams(Statement statement, Object ... objects) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<Object>();
        }
        for (Object object : objects) {
            if (object != null && ClassUtil.isArray(object.getClass())) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    Object value = Array.get(object, i);
                    if (value instanceof Map) {
                        ((Map)value).values().forEach(e -> this.doAddParam(statement, e));
                        continue;
                    }
                    this.doAddParam(statement, value);
                }
                continue;
            }
            this.doAddParam(statement, object);
        }
    }

    private void doAddParam(Statement statement, Object object) {
        try {
            if (object instanceof TypeHandlerObject) {
                ((TypeHandlerObject)object).setParameter(this.createPreparedStatement(statement), 0);
            } else if (object instanceof java.sql.Array) {
                Object array = ((java.sql.Array)object).getArray();
                this.queryParams.add(array);
            } else {
                this.queryParams.add(object);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getFullSql() {
        List<Object> queryParams = this.getQueryParams();
        return SqlUtil.replaceSqlParams(this.getQuery(), queryParams == null ? null : queryParams.toArray());
    }

    private PreparedStatement createPreparedStatement(Statement statement) {
        return (PreparedStatement)Proxy.newProxyInstance(AuditMessage.class.getClassLoader(), new Class[]{PreparedStatement.class}, (proxy, method, args) -> {
            if (args != null && (args.length == 2 || args.length == 3)) {
                this.doAddParam(statement, args[1]);
            } else if ("getConnection".equals(method.getName())) {
                return statement.getConnection();
            }
            return null;
        });
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void setQueryCount(int queryCount) {
        this.queryCount = queryCount;
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public Map<String, Object> getMetas() {
        return this.metas;
    }

    public void setMetas(Map<String, Object> metas) {
        this.metas = metas;
    }

    public void addMeta(String key, Object value) {
        if (this.metas == null) {
            this.metas = new HashMap<String, Object>();
        }
        this.metas.put(key, value);
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public String toString() {
        return "AuditMessage{platform='" + this.platform + '\'' + ", module='" + this.module + '\'' + ", url='" + this.url + '\'' + ", bizId='" + this.bizId + '\'' + ", user='" + this.user + '\'' + ", userIp='" + this.userIp + '\'' + ", hostIp='" + this.hostIp + '\'' + ", query='" + this.query + '\'' + ", queryParams=" + this.queryParams + ", queryCount=" + this.queryCount + ", queryTime=" + this.queryTime + ", elapsedTime=" + this.elapsedTime + ", dsName=" + this.dsName + ", metas=" + this.metas + '}';
    }
}

