/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.mybatisflex.core.util.EnumWrapper;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class FlexEnumTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private EnumWrapper<E> enumWrapper;

    public FlexEnumTypeHandler(Class<E> enumClass) {
        this.enumWrapper = EnumWrapper.of(enumClass);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        Object value = this.enumWrapper.getEnumValue(parameter);
        if (jdbcType == null) {
            ps.setObject(i, value);
        } else {
            ps.setObject(i, value, jdbcType.TYPE_CODE);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object value = rs.getObject(columnName, this.enumWrapper.getPropertyType());
        if (null == value && rs.wasNull()) {
            return null;
        }
        return this.enumWrapper.getEnum(value);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object value = rs.getObject(columnIndex, this.enumWrapper.getPropertyType());
        if (null == value && rs.wasNull()) {
            return null;
        }
        return this.enumWrapper.getEnum(value);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object value = cs.getObject(columnIndex, this.enumWrapper.getPropertyType());
        if (null == value && cs.wasNull()) {
            return null;
        }
        return this.enumWrapper.getEnum(value);
    }
}

