/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.tenant;

import com.mybatisflex.core.tenant.TenantFactory;
import java.util.function.Supplier;

public class TenantManager {
    private static final ThreadLocal<Boolean> ignoreFlags = new ThreadLocal();
    private static TenantFactory tenantFactory;

    private TenantManager() {
    }

    public static TenantFactory getTenantFactory() {
        return tenantFactory;
    }

    public static void setTenantFactory(TenantFactory tenantFactory) {
        TenantManager.tenantFactory = tenantFactory;
    }

    public static <T> T withoutTenantCondition(Supplier<T> supplier) {
        try {
            TenantManager.ignoreTenantCondition();
            T t = supplier.get();
            return t;
        }
        finally {
            TenantManager.restoreTenantCondition();
        }
    }

    public static void withoutTenantCondition(Runnable runnable) {
        try {
            TenantManager.ignoreTenantCondition();
            runnable.run();
        }
        finally {
            TenantManager.restoreTenantCondition();
        }
    }

    public static void ignoreTenantCondition() {
        ignoreFlags.set(Boolean.TRUE);
    }

    public static void restoreTenantCondition() {
        ignoreFlags.remove();
    }

    @Deprecated
    public static Object[] getTenantIds() {
        return TenantManager.getTenantIds(null);
    }

    public static Object[] getTenantIds(String tableName) {
        Boolean ignoreFlag = ignoreFlags.get();
        if (ignoreFlag != null && ignoreFlag.booleanValue()) {
            return null;
        }
        return tenantFactory != null ? tenantFactory.getTenantIds(tableName) : null;
    }
}

