/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.batch;

import com.mybatisflex.core.BaseMapper;
import java.util.List;
import java.util.Objects;
import org.mybatis.logging.Logger;
import org.mybatis.logging.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.Assert;

public class MybatisFlexBatchItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisFlexBatchItemWriter.class);
    private BaseMapper<T> mapper;
    private boolean assertUpdates = true;

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setMapper(BaseMapper<T> mapper) {
        if (Objects.isNull(mapper)) {
            throw new RuntimeException("MybatisFlex Mapper can't be null!");
        }
        this.mapper = mapper;
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.mapper, (String)"A Mapper is required.");
    }

    public void write(List<? extends T> items) {
        if (!items.isEmpty()) {
            LOGGER.debug(() -> "Executing batch with " + items.size() + " items.");
            int results = this.mapper.insertBatch(items);
            if (this.assertUpdates && results != items.size()) {
                throw new EmptyResultDataAccessException("Items.size + " + items.size() + " doesn't match the number of updated rows: " + results, 1);
            }
        }
    }
}

