/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen;

import com.mysema.codegen.CodegenException;
import com.mysema.codegen.Evaluator;
import com.mysema.codegen.EvaluatorFactory;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.MethodEvaluator;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.support.ClassUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AbstractEvaluatorFactory
implements EvaluatorFactory {
    private final Map<String, Method> cache = new WeakHashMap<String, Method>();
    protected ClassLoader loader;

    protected abstract void compile(String var1, ClassType var2, String[] var3, Type[] var4, String var5, Map<String, Object> var6) throws IOException;

    protected String createSource(String source, ClassType projectionType, String[] names, Type[] types, String id, Map<String, Object> constants) throws IOException {
        int i;
        StringWriter writer = new StringWriter();
        JavaWriter javaw = new JavaWriter(writer);
        SimpleType idType = new SimpleType(id, "", id, new Type[0]);
        javaw.beginClass(idType, null, new Type[0]);
        Parameter[] params = new Parameter[names.length + constants.size()];
        for (i = 0; i < names.length; ++i) {
            params[i] = new Parameter(names[i], types[i]);
        }
        i = names.length;
        for (Map.Entry<String, Object> entry : constants.entrySet()) {
            ClassType type = new ClassType(TypeCategory.SIMPLE, ClassUtils.normalize(entry.getValue().getClass()), new Type[0]);
            params[i++] = new Parameter(entry.getKey(), type);
        }
        javaw.beginStaticMethod((Type)projectionType, "eval", params);
        javaw.append(source);
        javaw.end();
        javaw.end();
        return writer.toString();
    }

    @Override
    public <T> Evaluator<T> createEvaluator(String source, Class<? extends T> projectionType, String[] names, Class<?>[] classes, Map<String, Object> constants) {
        Type[] types = new Type[classes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = new ClassType(TypeCategory.SIMPLE, classes[i], new Type[0]);
        }
        return this.createEvaluator(source, new ClassType(TypeCategory.SIMPLE, projectionType, new Type[0]), names, types, classes, constants);
    }

    @Override
    public synchronized <T> Evaluator<T> createEvaluator(String source, ClassType projection, String[] names, Type[] types, Class<?>[] classes, Map<String, Object> constants) {
        try {
            String id = this.toId(source, projection.getJavaClass(), types, constants.values());
            Method method = this.cache.get(id);
            if (method == null) {
                Class<?> clazz;
                try {
                    clazz = this.loader.loadClass(id);
                }
                catch (ClassNotFoundException e) {
                    this.compile(source, projection, names, types, id, constants);
                    clazz = this.loader.loadClass(id);
                }
                method = this.findEvalMethod(clazz);
                this.cache.put(id, method);
            }
            return new MethodEvaluator(method, constants, projection.getJavaClass());
        }
        catch (ClassNotFoundException e) {
            throw new CodegenException(e);
        }
        catch (SecurityException e) {
            throw new CodegenException(e);
        }
        catch (IOException e) {
            throw new CodegenException(e);
        }
    }

    protected Method findEvalMethod(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!"eval".equals(method.getName())) continue;
            return method;
        }
        throw new IllegalArgumentException("Couldn't find eval method!");
    }

    protected String toId(String source, Class<?> returnType, Type[] types, Collection<Object> constants) {
        StringBuilder b = new StringBuilder(128);
        b.append("Q");
        b.append("_").append(source.hashCode());
        b.append("_").append(returnType.getName().hashCode());
        for (Type type : types) {
            b.append("_").append(type.getFullName().hashCode());
        }
        for (Object e : constants) {
            b.append("_").append(e.getClass().getName().hashCode());
        }
        return b.toString().replace('-', '0');
    }
}

