/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.function.IntFunction;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.BlockSource;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SimpleByteArray;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.net.ns.NetException;
import oracle.sql.CharacterSet;
import oracle.sql.converter.CharacterConverter1Byte;
import oracle.sql.converter.CharacterConverterJDBC;
import oracle.sql.converter.JdbcCharacterConverters;

final class DynamicByteArray
extends ByteArray {
    private static final String CLASS_NAME = DynamicByteArray.class.getName();
    static final int INITIAL_BLOCKS = 16;
    static final int GROWTH_FACTOR = 8;
    private static final int CACHED_CHAR_ARRAY_SIZE = 256;
    private static final int COMPACT_THRESHOLD = 131072;
    private static final int ORA_18738 = 18738;
    private final BlockSource source;
    private final long blockSize;
    private byte[][] blocks = new byte[16][];
    protected long length = 0L;
    private char[] charsForNewString = null;
    private int newBlockLimit = Integer.MAX_VALUE;
    private static final char[] ISO_LATIN_1_TO_JAVA;
    private static final char[] WE8DEC_TO_JAVA;
    private static final char[] WE8MSWIN1252_TO_JAVA;
    private static final char[] WE8ISO8859P15_TO_JAVA;
    private static final char[] JAVA_TO_ISO_LATIN_1_LEVEL1;
    private static final char[] JAVA_TO_ISO_LATIN_1_LEVEL2;
    private static final char[] JAVA_TO_WE8DEC_LEVEL1;
    private static final char[] JAVA_TO_WE8DEC_LEVEL2;
    private static final char[] JAVA_TO_WE8MSWIN1252_LEVEL1;
    private static final char[] JAVA_TO_WE8MSWIN1252_LEVEL2;
    private static final char[] JAVA_TO_US7ASCII_LEVEL1;
    private static final char[] JAVA_TO_US7ASCII_LEVEL2;
    private static final char[] JAVA_TO_WE8ISO8859P15_LEVEL1;
    private static final char[] JAVA_TO_WE8ISO8859P15_LEVEL2;
    private static final char INVALID_ORA_CHAR = '\uffff';
    private static final char JAVA_TO_ISO_LATIN_1_REPLACEMENT;
    private static final char JAVA_TO_WE8DEC_REPLACEMENT;
    private static final char JAVA_TO_WE8MSWIN1252_REPLACEMENT;
    private static final char JAVA_TO_US7ASCII_REPLACEMENT;
    private static final char JAVA_TO_WE8ISO8859P15_REPLACEMENT;
    private int globalBlockIndex = -1;
    private int globalByteIndex = -1;
    private int globalRemaining = -1;
    private int globalBlockSize = -1;
    private byte[] globalBytes = null;
    private static final char UTF16_REPLACEMENT_CHAR = '\ufffd';

    static DynamicByteArray createDynamicByteArray(Diagnosable diagnosable, BlockSource source) {
        return new DynamicByteArray(diagnosable, source);
    }

    private DynamicByteArray(Diagnosable diagnosable, BlockSource source) {
        super(diagnosable);
        assert (source != null) : "source is null";
        this.source = source;
        this.blockSize = source.getBlockSize();
    }

    @Override
    void startFetch(long maxBytes) {
        assert (maxBytes > 0L);
        long newLimit = (maxBytes - (this.length - this.position)) / this.blockSize + 1L;
        this.newBlockLimit = (int)Math.min(newLimit, Integer.MAX_VALUE);
    }

    @Override
    protected void endFetch() {
        this.newBlockLimit = Integer.MAX_VALUE;
    }

    @Override
    long length() {
        return this.length;
    }

    @Override
    long getCapacity() {
        long sum = 0L;
        for (byte[] b : this.blocks) {
            if (b == null) continue;
            sum += (long)b.length;
        }
        return sum;
    }

    private void grow() {
        byte[][] tmp = new byte[this.blocks.length * 8][];
        System.arraycopy(this.blocks, 0, tmp, 0, this.blocks.length);
        this.blocks = tmp;
    }

    private byte[] getNewBlock() throws SQLException {
        if (this.newBlockLimit-- == 0) {
            throw DatabaseError.createSqlException(1738, null);
        }
        return this.source.get();
    }

    private final char[] getCharsForNewString(int minLen) {
        if (this.charsForNewString == null || minLen > this.charsForNewString.length) {
            this.charsForNewString = new char[Math.max(256, minLen)];
        }
        return this.charsForNewString;
    }

    final int unmarshalCLR(T4CMAREngine mare) throws SQLException, IOException {
        int len = 0;
        int bytesRead = 0;
        len = mare.unmarshalUB1();
        if (len == 0) {
            return 0;
        }
        if (mare.escapeSequenceNull(len)) {
            return 0;
        }
        this.globalBlockIndex = (int)(this.position / this.blockSize);
        this.globalByteIndex = (int)(this.position % this.blockSize);
        if (len == 254) {
            SQLException error18738 = null;
            while (true) {
                int n = len = mare.useCLRBigChunks ? mare.unmarshalSB4() : (int)mare.unmarshalUB1();
                if (len <= 0) break;
                try {
                    this.unmarshalBuffer(mare, len);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 18738) {
                        throw e;
                    }
                    error18738 = e;
                }
                bytesRead += len;
            }
            if (error18738 != null) {
                throw error18738;
            }
        } else {
            this.unmarshalBuffer(mare, len);
            bytesRead += len;
        }
        this.position += (long)bytesRead;
        this.length = Math.max(this.length, this.position + 1L);
        return bytesRead;
    }

    final int unmarshalCLR(T4CMAREngine mare, int maxLength) throws SQLException, IOException {
        int len = 0;
        int bytesRead = 0;
        int keepThem = 0;
        len = mare.unmarshalUB1();
        if (len == 0) {
            return 0;
        }
        if (mare.escapeSequenceNull(len)) {
            return 0;
        }
        this.globalBlockIndex = (int)(this.position / this.blockSize);
        this.globalByteIndex = (int)(this.position % this.blockSize);
        if (len == 254) {
            while (true) {
                int n = len = mare.useCLRBigChunks ? mare.unmarshalSB4() : (int)mare.unmarshalUB1();
                if (len > 0) {
                    keepThem = Math.min(maxLength - bytesRead, len);
                    this.unmarshalBuffer(mare, keepThem);
                    bytesRead += keepThem;
                    int rest = len - keepThem;
                    if (rest <= 0) continue;
                    mare.unmarshalBuffer(T4CMAREngine.IGNORED, 0, rest);
                    continue;
                }
                break;
            }
        } else {
            keepThem = Math.min(maxLength - bytesRead, len);
            this.unmarshalBuffer(mare, keepThem);
            bytesRead += keepThem;
            int rest = len - keepThem;
            if (rest > 0) {
                mare.unmarshalBuffer(T4CMAREngine.IGNORED, 0, rest);
            }
        }
        this.position += (long)bytesRead;
        this.length = Math.max(this.length, this.position + 1L);
        return bytesRead;
    }

    private final void unmarshalBuffer(T4CMAREngine mare, int len) throws SQLException, IOException {
        while (len > 0) {
            while (this.globalBlockIndex >= this.blocks.length) {
                this.grow();
            }
            int l = Math.min(len, (int)this.blockSize - this.globalByteIndex);
            try {
                if (this.blocks[this.globalBlockIndex] == null) {
                    this.blocks[this.globalBlockIndex] = this.getNewBlock();
                }
                mare.unmarshalNBytes(this.blocks[this.globalBlockIndex], this.globalByteIndex, l);
                this.globalByteIndex += l;
                if (this.globalByteIndex >= (int)this.blockSize) {
                    this.globalByteIndex = 0;
                    ++this.globalBlockIndex;
                }
                len -= l;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 18738) {
                    mare.skipNBytes(l);
                    len -= l;
                }
                throw e;
            }
        }
    }

    final int unmarshalCLRforREFS(T4CMAREngine mare) throws SQLException, IOException {
        byte[] bytes = mare.unmarshalCLRforREFS();
        if (bytes == null) {
            return 0;
        }
        this.put(bytes);
        return bytes.length;
    }

    final void marshalB1Array(T4CMAREngine mare, long offset, int length) throws IOException {
        assert (offset >= 0L && offset + (long)length <= this.length) : " offset: " + offset + " this.length: " + this.length + " length: " + length;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        int blksiz = (int)this.blockSize;
        int remaining = length;
        do {
            mare.marshalB1Array(this.blocks[blockIndex], byteIndex, Math.min(blksiz - byteIndex, remaining));
            ++blockIndex;
        } while ((remaining -= blksiz - (byteIndex = 0)) > 0);
    }

    void writeZeroCopyIO(T4CMAREngine mare, long offset, int length) throws IOException, NetException {
        int lastDDSize;
        int iterations;
        assert (offset >= 0L && offset + (long)length <= this.length) : " offset: " + offset + " this.length: " + this.length + " length: " + length;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        int blkSize = (int)this.blockSize;
        boolean flushBuffer = true;
        boolean isLastDD = false;
        int maxDDSize = 1703910;
        if (length % 1703910 == 0) {
            iterations = length / 1703910;
            lastDDSize = 1703910;
        } else {
            iterations = length / 1703910 + 1;
            lastDDSize = length % 1703910;
        }
        for (int i = 0; i < iterations; ++i) {
            int remaining;
            if (i == iterations - 1) {
                remaining = lastDDSize;
                isLastDD = true;
            } else {
                remaining = 1703910;
            }
            mare.writeZeroCopyIOHeader(flushBuffer, remaining, isLastDD);
            flushBuffer = false;
            do {
                int tempLength = blkSize - byteIndex;
                int bytesToSent = Math.min(tempLength, remaining);
                mare.writeZeroCopyIOData(this.blocks[blockIndex], byteIndex, bytesToSent);
                remaining -= bytesToSent;
                if (byteIndex + bytesToSent == blkSize) {
                    ++blockIndex;
                    byteIndex = 0;
                    continue;
                }
                byteIndex += bytesToSent;
            } while (remaining > 0);
        }
    }

    @Override
    protected void copyLeft(long srcOffset, int length) {
        int len;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "copyLeft", "srcOffset={0}, length={1}, position={2}, length={3}. ", (String)null, (Throwable)null, (Object)srcOffset, (Object)length, (Object)this.position, (Object)this.length);
        assert (srcOffset >= this.position && length >= 0 && this.length >= this.position + (long)length) : "this.position: " + this.position + " this.length: " + this.length + " srcOffset: " + srcOffset + " length: " + length;
        if (srcOffset == this.position || length == 0) {
            this.position += (long)length;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "copyLeft", "position  increased by {0} to {1}. ", (String)null, (Throwable)null, (Object)length, (Object)this.position);
            return;
        }
        assert (srcOffset > this.position && length > 0);
        int destBlockIndex = (int)(this.position / this.blockSize);
        int destByteIndex = (int)(this.position % this.blockSize);
        int srcBlockIndex = (int)(srcOffset / this.blockSize);
        int srcByteIndex = (int)(srcOffset % this.blockSize);
        int blksiz = (int)this.blockSize;
        for (int remaining = length; remaining > 0; remaining -= len) {
            len = Math.min(remaining, Math.min(blksiz - srcByteIndex, blksiz - destByteIndex));
            System.arraycopy(this.blocks[srcBlockIndex], srcByteIndex, this.blocks[destBlockIndex], destByteIndex, len);
            if ((srcByteIndex += len) == blksiz) {
                ++srcBlockIndex;
                srcByteIndex = 0;
            }
            if ((destByteIndex += len) != blksiz) continue;
            ++destBlockIndex;
            destByteIndex = 0;
        }
        this.position += (long)length;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "copyLeft", "srcOffset={0}, position increased by {1} to {2}, length={3}. ", (String)null, (Throwable)null, (Object)srcOffset, (Object)length, (Object)this.position, (Object)this.length);
    }

    @Override
    void put(long index, byte value) throws SQLException {
        assert (index >= 0L) : "index: " + index;
        int blockIndex = (int)(index / this.blockSize);
        int byteIndex = (int)(index % this.blockSize);
        while (blockIndex >= this.blocks.length) {
            this.grow();
        }
        if (this.blocks[blockIndex] == null) {
            this.blocks[blockIndex] = this.getNewBlock();
        }
        this.blocks[blockIndex][byteIndex] = value;
        this.length = Math.max(this.length, index + 1L);
    }

    @Override
    byte get(long index) {
        assert (index >= 0L && index < this.length);
        int blockIndex = (int)(index / this.blockSize);
        int byteIndex = (int)(index % this.blockSize);
        assert (this.blocks.length >= blockIndex && this.blocks[blockIndex] != null) : "invalid read--blocks.length: " + this.blocks.length + " blockIndex: " + blockIndex + (String)(blockIndex < this.blocks.length ? " blocks[" + blockIndex + "]: " + this.blocks[blockIndex] : "");
        return this.blocks[blockIndex][byteIndex];
    }

    @Override
    void put(long offset, byte[] src, int srcOffset, int length) throws SQLException {
        assert (src != null) : "src is null";
        assert (offset >= 0L && srcOffset + length <= src.length) : "offset: " + offset + " src.length: " + src.length + " srcOffset: " + srcOffset + " length: " + length;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        int blksiz = (int)this.blockSize;
        int remaining = length;
        while (true) {
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            System.arraycopy(src, srcOffset + length - remaining, this.blocks[blockIndex], byteIndex, Math.min(blksiz - byteIndex, remaining));
            ++blockIndex;
            byteIndex = 0;
            if ((remaining -= blksiz - byteIndex) <= 0) break;
        }
        this.length = Math.max(this.length, offset + (long)length + 1L);
    }

    @Override
    void get(long offset, byte[] dest, int destOffset, int length) {
        assert (offset >= 0L && offset + (long)length <= this.length && destOffset >= 0 && destOffset + length <= dest.length) : " offset: " + offset + " this.length: " + this.length + " destOffset: " + destOffset + " length: " + length;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        int blksiz = (int)this.blockSize;
        int remaining = length;
        do {
            System.arraycopy(this.blocks[blockIndex], byteIndex, dest, destOffset + length - remaining, Math.min(blksiz - byteIndex, remaining));
            ++blockIndex;
        } while ((remaining -= blksiz - (byteIndex = 0)) > 0);
    }

    @Override
    void free() {
        this.free(true);
    }

    @Override
    void free(boolean returnBlockToSource) {
        for (int i = 0; i < this.blocks.length; ++i) {
            if (this.blocks[i] == null) continue;
            if (returnBlockToSource) {
                this.source.put(this.blocks[i]);
            }
            this.blocks[i] = null;
        }
        this.position = 0L;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "put", "position free set to 0. ", null, null);
        this.length = 0L;
        this.charsForNewString = null;
    }

    @Override
    long updateChecksum(long offset, int length, CRC64 crc, long checksum) {
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        int remaining = length;
        long result = checksum;
        while (remaining > 0) {
            int len = Math.min(remaining, (int)this.blockSize - byteIndex);
            result = CRC64.updateChecksum(result, this.blocks[blockIndex], byteIndex, len);
            remaining -= len;
            ++blockIndex;
            byteIndex = 0;
        }
        return result;
    }

    @Override
    void updateDigest(MessageDigest md, long valOffset, int valLen) {
        assert (valOffset >= 0L && valOffset + (long)valLen <= this.length) : " valOffset: " + valOffset + " this.length: " + this.length + " valLen: " + valLen;
        int blockIndex = (int)(valOffset / this.blockSize);
        int byteIndex = (int)(valOffset % this.blockSize);
        int remaining = valLen;
        while (remaining > 0) {
            int len = Math.min(remaining, (int)this.blockSize - byteIndex);
            md.update(this.blocks[blockIndex], byteIndex, len);
            remaining -= len;
            ++blockIndex;
            byteIndex = 0;
        }
    }

    @Override
    final char[] getChars(long offset, int lengthInBytes, CharacterSet charSet, int[] out_lengthInChars) throws SQLException {
        return this.getChars(offset, lengthInBytes, charSet, char[]::new, 0, out_lengthInChars);
    }

    @Override
    final int getChars(long offset, int lengthInBytes, CharacterSet charSet, char[] dst, int dstOffset) throws SQLException {
        int[] lengthHolder = new int[1];
        this.getChars(offset, lengthInBytes, charSet, ignored -> dst, dstOffset, lengthHolder);
        return lengthHolder[0];
    }

    private char[] getChars(long offset, int lengthInBytes, CharacterSet charSet, IntFunction<char[]> arrayFunction, int dstOffset, int[] out_lengthInChars) throws SQLException {
        char[] dst;
        switch (charSet.getOracleId()) {
            case 1: {
                dst = arrayFunction.apply(lengthInBytes);
                out_lengthInChars[0] = this.getCharsFromUS7ASCII(offset, lengthInBytes, dst, dstOffset);
                break;
            }
            case 2: {
                dst = arrayFunction.apply(lengthInBytes);
                out_lengthInChars[0] = this.getCharsFrom1Byte(offset, lengthInBytes, WE8DEC_TO_JAVA, dst, dstOffset);
                break;
            }
            case 31: {
                dst = arrayFunction.apply(lengthInBytes);
                out_lengthInChars[0] = this.getCharsFrom1Byte(offset, lengthInBytes, ISO_LATIN_1_TO_JAVA, dst, dstOffset);
                break;
            }
            case 178: {
                dst = arrayFunction.apply(lengthInBytes);
                out_lengthInChars[0] = this.getCharsFrom1Byte(offset, lengthInBytes, WE8MSWIN1252_TO_JAVA, dst, dstOffset);
                break;
            }
            case 2000: {
                dst = arrayFunction.apply(lengthInBytes / 2);
                out_lengthInChars[0] = this.getCharsFromAL16UTF16(offset, lengthInBytes, dst, dstOffset);
                break;
            }
            case 2002: {
                dst = arrayFunction.apply(lengthInBytes / 2);
                out_lengthInChars[0] = this.getCharsFromAL16UTF16LE(offset, lengthInBytes, dst, dstOffset);
                break;
            }
            case 871: {
                dst = arrayFunction.apply(lengthInBytes);
                out_lengthInChars[0] = this.getCharsFromUTF8(offset, lengthInBytes, dst, dstOffset);
                break;
            }
            case 873: {
                dst = arrayFunction.apply(lengthInBytes);
                out_lengthInChars[0] = this.getCharsFromAL32UTF8(offset, lengthInBytes, dst, dstOffset);
                break;
            }
            default: {
                String convertedString;
                int blockIndex = (int)(offset / this.blockSize);
                int byteIndex = (int)(offset % this.blockSize);
                if (lengthInBytes <= (int)this.blockSize - byteIndex) {
                    convertedString = charSet.toStringWithReplacement(this.blocks[blockIndex], byteIndex, lengthInBytes);
                } else {
                    byte[] b = this.get(offset, lengthInBytes);
                    convertedString = charSet.toStringWithReplacement(b, 0, b.length);
                }
                dst = arrayFunction.apply(convertedString.length());
                convertedString.getChars(0, convertedString.length(), dst, dstOffset);
                out_lengthInChars[0] = convertedString.length();
            }
        }
        return dst;
    }

    @Override
    final String getString(long offset, int lengthInBytes, CharacterSet charSet) throws SQLException {
        int[] lengthHolder = new int[1];
        char[] chars = this.getChars(offset, lengthInBytes, charSet, this::getCharsForNewString, 0, lengthHolder);
        return new String(chars, 0, lengthHolder[0]);
    }

    @Override
    final int putString(long offset, String val, CharacterSet charSet) throws SQLException {
        if (val == null || val.length() == 0) {
            return 0;
        }
        switch (charSet.getOracleId()) {
            case 1: {
                return this.putStringFrom1Byte(offset, val, JAVA_TO_US7ASCII_LEVEL1, JAVA_TO_US7ASCII_LEVEL2);
            }
            case 2: {
                return this.putStringFrom1Byte(offset, val, JAVA_TO_WE8DEC_LEVEL1, JAVA_TO_WE8DEC_LEVEL2);
            }
            case 31: {
                return this.putStringFrom1Byte(offset, val, JAVA_TO_ISO_LATIN_1_LEVEL1, JAVA_TO_ISO_LATIN_1_LEVEL2);
            }
            case 46: {
                return this.putStringFrom1Byte(offset, val, JAVA_TO_WE8ISO8859P15_LEVEL1, JAVA_TO_WE8ISO8859P15_LEVEL2);
            }
            case 178: {
                return this.putStringFrom1Byte(offset, val, JAVA_TO_WE8MSWIN1252_LEVEL1, JAVA_TO_WE8MSWIN1252_LEVEL2);
            }
            case 2000: {
                return this.putStringFromAL16UTF16(offset, val);
            }
            case 2002: {
                return this.putStringFromAL16UTF16LE(offset, val);
            }
            case 871: {
                return this.putStringFromUTF8(offset, val);
            }
            case 873: {
                return this.putStringFromAL32UTF8(offset, val);
            }
        }
        return this.putStringFromCharset(offset, val, charSet);
    }

    @Override
    final int putStringWithReplacement(long offset, String val, CharacterSet charSet) throws SQLException {
        if (val == null || val.length() == 0) {
            return 0;
        }
        switch (charSet.getOracleId()) {
            case 871: 
            case 873: 
            case 2000: 
            case 2002: {
                return this.putString(offset, val, charSet);
            }
            case 31: {
                return this.putStringFromISOLatin1WithReplacement(offset, val);
            }
            case 46: {
                return this.putStringFrom1ByteWithReplacement(offset, val, JAVA_TO_WE8ISO8859P15_LEVEL1, JAVA_TO_WE8ISO8859P15_LEVEL2, JAVA_TO_WE8ISO8859P15_REPLACEMENT);
            }
            case 1: {
                return this.putStringFrom1ByteWithReplacement(offset, val, JAVA_TO_US7ASCII_LEVEL1, JAVA_TO_US7ASCII_LEVEL2, JAVA_TO_US7ASCII_REPLACEMENT);
            }
            case 2: {
                return this.putStringFrom1ByteWithReplacement(offset, val, JAVA_TO_WE8DEC_LEVEL1, JAVA_TO_WE8DEC_LEVEL2, JAVA_TO_WE8DEC_REPLACEMENT);
            }
            case 178: {
                return this.putStringFrom1ByteWithReplacement(offset, val, JAVA_TO_WE8MSWIN1252_LEVEL1, JAVA_TO_WE8MSWIN1252_LEVEL2, JAVA_TO_WE8MSWIN1252_REPLACEMENT);
            }
        }
        return this.putStringFromCharsetWithReplacement(offset, val, charSet);
    }

    private final int getCharsFromUS7ASCII(long offset, int lengthInBytes, char[] dst, int dstOffset) throws SQLException {
        assert (offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes) : "this.length: " + this.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        int bytesRemaining = lengthInBytes;
        int charIndex = dstOffset;
        while (bytesRemaining > 0) {
            bytes = this.blocks[blockIndex++];
            int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
            bytesRemaining = bytesRemaining - lastByte + byteIndex;
            while (byteIndex < lastByte) {
                dst[charIndex++] = (char)bytes[byteIndex++];
            }
            byteIndex = 0;
        }
        assert (charIndex - dstOffset == lengthInBytes) : "charIndex: " + charIndex + "\tlengthInBytes: " + lengthInBytes;
        return charIndex - dstOffset;
    }

    @Override
    final int putAsciiString(long offset, String val) throws SQLException {
        assert (offset >= 0L && val != null && val.length() >= 0) : "this.length: " + this.length + " offset: " + offset + " val.length(): " + val.length();
        int strLen = val.length();
        int charIndex = 0;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        while (true) {
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            bytes = this.blocks[blockIndex++];
            int lastByte = Math.min(byteIndex + (strLen - charIndex), bytes.length);
            while (byteIndex < lastByte) {
                bytes[byteIndex++] = (byte)val.charAt(charIndex++);
            }
            byteIndex = 0;
            if (charIndex >= strLen) break;
        }
        this.length = Math.max(this.length, offset + (long)strLen + 1L);
        assert (charIndex == strLen) : "charIndex: " + charIndex + "\tstrLen: " + strLen;
        return strLen;
    }

    private static final char[] intToChar(int[] ints) {
        char[] chars = new char[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            chars[i] = (char)ints[i];
        }
        return chars;
    }

    private final int getCharsFrom1Byte(long offset, int lengthInBytes, char[] byteToChar, char[] dst, int dstOffset) throws SQLException {
        assert (offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes) : "this.length: " + this.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        int bytesRemaining = lengthInBytes;
        int charIndex = dstOffset;
        while (bytesRemaining > 0) {
            bytes = this.blocks[blockIndex++];
            int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
            bytesRemaining = bytesRemaining - lastByte + byteIndex;
            while (byteIndex < lastByte) {
                dst[charIndex++] = byteToChar[bytes[byteIndex++] & 0xFF];
            }
            byteIndex = 0;
        }
        assert (charIndex - dstOffset == lengthInBytes) : "charIndex: " + charIndex + "\tlengthInBytes: " + lengthInBytes;
        return charIndex - dstOffset;
    }

    private final int putStringFrom1Byte(long offset, String val, char[] charToByteLevel1, char[] charToByteLevel2) throws SQLException {
        assert (offset >= 0L && val != null && val.length() >= 0) : "this.length: " + this.length + " offset: " + offset + " val.length(): " + val.length();
        int strLen = val.length();
        int charIndex = 0;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        while (true) {
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            bytes = this.blocks[blockIndex++];
            int lastByte = Math.min(byteIndex + (strLen - charIndex), bytes.length);
            while (byteIndex < lastByte) {
                int l4Key;
                char srcChar;
                int l3Key;
                char retChar;
                if ((retChar = charToByteLevel2[charToByteLevel1[l3Key = (srcChar = val.charAt(charIndex++)) >>> 8] + (l4Key = srcChar & 0xFF)]) != '\uffff') {
                    bytes[byteIndex++] = (byte)retChar;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(155).fillInStackTrace();
            }
            byteIndex = 0;
            if (charIndex >= strLen) break;
        }
        this.length = Math.max(this.length, offset + (long)strLen + 1L);
        assert (charIndex == strLen) : "charIndex: " + charIndex + "\tstrLen: " + strLen;
        return strLen;
    }

    private int putStringFrom1ByteWithReplacement(long offset, String val, char[] charToByteLevel1, char[] charToByteLevel2, char replacementChar) throws SQLException {
        assert (offset >= 0L && val != null && val.length() >= 0) : "this.length: " + this.length + " offset: " + offset + " val.length(): " + val.length();
        int strLen = val.length();
        int charIndex = 0;
        int bytesStored = 0;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        while (true) {
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            bytes = this.blocks[blockIndex++];
            while (byteIndex < bytes.length && charIndex < strLen) {
                byte nextByte;
                char srcChar;
                if ((srcChar = val.charAt(charIndex++)) < '\u0080') {
                    nextByte = (byte)srcChar;
                } else if (Character.isHighSurrogate(srcChar)) {
                    nextByte = (byte)replacementChar;
                    if (charIndex < strLen && Character.isLowSurrogate(val.charAt(charIndex))) {
                        ++charIndex;
                    }
                } else {
                    int l3Key = srcChar >>> 8;
                    int l4Key = srcChar & 0xFF;
                    char retChar = charToByteLevel2[charToByteLevel1[l3Key] + l4Key];
                    nextByte = retChar == '\uffff' ? (byte)replacementChar : (byte)retChar;
                }
                bytes[byteIndex++] = nextByte;
                ++bytesStored;
            }
            byteIndex = 0;
            if (charIndex >= strLen) break;
        }
        this.length = Math.max(this.length, offset + (long)bytesStored);
        assert (charIndex == strLen) : "charIndex: " + charIndex + "\tstrLen: " + strLen;
        return bytesStored;
    }

    private int putStringFromISOLatin1WithReplacement(long offset, String val) throws SQLException {
        assert (offset >= 0L && val != null && val.length() >= 0) : "this.length: " + this.length + " offset: " + offset + " val.length(): " + val.length();
        int strLen = val.length();
        int charIndex = 0;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        while (true) {
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            bytes = this.blocks[blockIndex++];
            int lastByte = Math.min(byteIndex + (strLen - charIndex), bytes.length);
            while (byteIndex < lastByte) {
                char nextChar = val.charAt(charIndex++);
                bytes[byteIndex++] = (byte)(nextChar > '\u00ff' ? 191 : (int)nextChar);
            }
            byteIndex = 0;
            if (charIndex >= strLen) break;
        }
        this.length = Math.max(this.length, offset + (long)strLen);
        assert (charIndex == strLen) : "charIndex: " + charIndex + "\tstrLen: " + strLen;
        return strLen;
    }

    private final void setGlobals(long offset, int length) {
        this.globalBlockIndex = (int)(offset / this.blockSize);
        this.globalByteIndex = (int)(offset % this.blockSize);
        this.globalRemaining = length;
        this.globalBlockSize = (int)this.blockSize;
        this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
    }

    private final byte next() {
        assert (this.globalRemaining > 0) : "next overrun in DBA";
        byte b = this.globalBytes[this.globalByteIndex++];
        --this.globalRemaining;
        if (this.globalByteIndex >= this.globalBlockSize) {
            this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
            this.globalByteIndex = 0;
        }
        return b;
    }

    private final byte peek() {
        assert (this.globalRemaining > 0) : "peek overrun in DBA";
        return this.globalBytes[this.globalByteIndex];
    }

    private final void back() {
        if (this.globalByteIndex == 0) {
            this.globalByteIndex = this.globalBlockSize;
            --this.globalBlockIndex;
            this.globalBytes = this.blocks[this.globalBlockIndex];
        }
        --this.globalByteIndex;
        ++this.globalRemaining;
    }

    private final int getCharsFromAL16UTF16(long offset, int lengthInBytes, char[] dst, int dstOffset) throws SQLException {
        assert (offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes) : "this.length: " + this.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        assert (lengthInBytes % 2 == 0) : "lengthInBytes: " + lengthInBytes;
        this.setGlobals(offset, lengthInBytes);
        int charIndex = dstOffset;
        while (this.globalRemaining > 0) {
            int hibyte = this.next() << 8;
            dst[charIndex++] = (char)(hibyte | this.next() & 0xFF);
        }
        assert (charIndex - dstOffset == lengthInBytes / 2) : "charIndex: " + charIndex + "\tlengthInBytes/2: " + lengthInBytes / 2;
        return charIndex - dstOffset;
    }

    private final int putStringFromAL16UTF16(long offset, String val) throws SQLException {
        int totalSrcBytes;
        assert (offset >= 0L && val != null && val.length() >= 0) : "this.length: " + this.length + " offset: " + offset + " val.length(): " + val.length();
        int strLen = val.length();
        int charIndex = 0;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        int bytesRemaining = totalSrcBytes = strLen * 2;
        boolean lastCharLeftOverByte = false;
        while (true) {
            char srcChar;
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            bytes = this.blocks[blockIndex++];
            int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
            bytesRemaining = bytesRemaining - lastByte + byteIndex;
            if (lastCharLeftOverByte) {
                lastCharLeftOverByte = false;
                bytes[byteIndex++] = (byte)(val.charAt(charIndex - 1) & 0xFF);
            }
            while (byteIndex < lastByte - 1) {
                srcChar = val.charAt(charIndex++);
                bytes[byteIndex++] = (byte)(srcChar >>> 8 & 0xFF);
                bytes[byteIndex++] = (byte)(srcChar & 0xFF);
            }
            if (byteIndex < lastByte) {
                srcChar = val.charAt(charIndex++);
                bytes[byteIndex++] = (byte)(srcChar >>> 8 & 0xFF);
                lastCharLeftOverByte = true;
            }
            byteIndex = 0;
            if (bytesRemaining <= 0) break;
        }
        this.length = Math.max(this.length, offset + (long)totalSrcBytes + 1L);
        assert (charIndex == strLen) : "charIndex: " + charIndex + "\ttotalSrcBytes: " + totalSrcBytes;
        return totalSrcBytes;
    }

    private final int getCharsFromAL16UTF16LE(long offset, int lengthInBytes, char[] dst, int dstOffset) throws SQLException {
        assert (offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes) : "this.length: " + this.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        assert (lengthInBytes % 2 == 0) : "lengthInBytes: " + lengthInBytes;
        this.setGlobals(offset, lengthInBytes);
        int charIndex = dstOffset;
        while (this.globalRemaining > 0) {
            byte lobyte = this.next();
            int c = this.next() << 8 | lobyte & 0xFF;
            if (!this.isHiSurrogate((char)c)) {
                dst[charIndex++] = c;
                continue;
            }
            if (this.globalRemaining == 0) {
                dst[charIndex++] = 65533;
                break;
            }
            lobyte = this.next();
            char c2 = (char)(this.next() << 8 | lobyte & 0xFF);
            dst[charIndex++] = this.isLoSurrogate(c2) ? c : 65533;
            dst[charIndex++] = c2;
        }
        assert (charIndex - dstOffset == lengthInBytes / 2) : "charIndex: " + charIndex + "\tlengthInBytes/2: " + lengthInBytes / 2;
        return charIndex - dstOffset;
    }

    private final int putStringFromAL16UTF16LE(long offset, String val) throws SQLException {
        int totalSrcBytes;
        assert (offset >= 0L && val != null && val.length() >= 0) : "this.length: " + this.length + " offset: " + offset + " val.length(): " + val.length();
        int strLen = val.length();
        int charIndex = 0;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        int bytesRemaining = totalSrcBytes = strLen * 2;
        boolean lastCharLeftOverByte = false;
        while (true) {
            char srcChar;
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            bytes = this.blocks[blockIndex++];
            int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
            bytesRemaining = bytesRemaining - lastByte + byteIndex;
            if (lastCharLeftOverByte) {
                lastCharLeftOverByte = false;
                bytes[byteIndex++] = (byte)(val.charAt(charIndex - 1) >>> 8);
            }
            while (byteIndex < lastByte - 1) {
                srcChar = val.charAt(charIndex++);
                bytes[byteIndex++] = (byte)(srcChar & 0xFF);
                bytes[byteIndex++] = (byte)(srcChar >>> 8);
            }
            if (byteIndex < lastByte) {
                srcChar = val.charAt(charIndex++);
                bytes[byteIndex++] = (byte)(srcChar & 0xFF);
                lastCharLeftOverByte = true;
            }
            byteIndex = 0;
            if (bytesRemaining <= 0) break;
        }
        this.length = Math.max(this.length, offset + (long)totalSrcBytes + 1L);
        assert (charIndex == strLen) : "charIndex: " + charIndex + "\ttotalSrcBytes: " + totalSrcBytes;
        return totalSrcBytes;
    }

    private final int getCharsFromUTF8(long offset, int lengthInBytes, char[] dst, int dstOffset) throws SQLException {
        assert (offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes) : "this.length: " + this.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        this.setGlobals(offset, lengthInBytes);
        int lastBlock = (int)((offset + (long)lengthInBytes - 1L) / this.blockSize) + 1;
        int lastByte = (int)((offset + (long)lengthInBytes - 1L) % this.blockSize) + 1;
        int charIndex = dstOffset;
        while (this.globalRemaining > 0) {
            char c2;
            byte c = this.next();
            if (c >= 0) {
                int localByteIndex;
                dst[charIndex++] = (char)c;
                int end = this.globalBlockIndex == lastBlock ? lastByte : (this.globalBlockIndex < lastBlock ? (int)this.blockSize : 0);
                for (localByteIndex = this.globalByteIndex; localByteIndex < end && this.globalBytes != null && (c = this.globalBytes[localByteIndex]) >= 0; ++localByteIndex) {
                    dst[charIndex++] = (char)c;
                }
                this.globalRemaining -= localByteIndex - this.globalByteIndex;
                this.globalByteIndex = localByteIndex;
                if (this.globalByteIndex < this.globalBlockSize) continue;
                this.globalByteIndex = 0;
                this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
                continue;
            }
            int b = c & 0xF0;
            byte bb = c;
            if ((bb = (byte)(bb << 2)) >= 0) {
                if (this.globalRemaining < 1) {
                    dst[charIndex++] = 65533;
                    continue;
                }
                c2 = this.conv2ByteUTFtoUTF16(c, this.next());
                dst[charIndex++] = c2;
                continue;
            }
            if ((bb = (byte)(bb << 1)) >= 0) {
                byte b1;
                if (this.globalRemaining < 2) {
                    dst[charIndex++] = 65533;
                    continue;
                }
                byte b0 = this.next();
                int c1 = this.conv3ByteUTFtoUTF16(c, b0, b1 = this.next());
                if (this.isHiSurrogate((char)c1) && this.globalRemaining > 0) {
                    c = this.peek();
                    if ((byte)(c & 0xF0) != -32) {
                        dst[charIndex++] = 65533;
                        continue;
                    }
                    this.next();
                    if (this.globalRemaining < 2) {
                        dst[charIndex++] = 65533;
                        continue;
                    }
                    b0 = this.next();
                    c2 = this.conv3ByteUTFtoUTF16(c, b0, b1 = this.next());
                    dst[charIndex++] = this.isLoSurrogate(c2) ? c1 : 65533;
                    dst[charIndex++] = c2;
                    continue;
                }
                dst[charIndex++] = c1;
                continue;
            }
            dst[charIndex++] = 65533;
        }
        return charIndex - dstOffset;
    }

    private final int putStringFromUTF8(long offset, String val) throws SQLException {
        assert (offset >= 0L && val != null && val.length() >= 0) : "this.length: " + this.length + " offset: " + offset + " val.length(): " + val.length();
        int strLen = val.length();
        int charIndex = 0;
        int MAX_BYTES_IN_CHAR = 3;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        int totalBytesWritten = 0;
        int lastCharLeftOverByteCount = 0;
        while (true) {
            char c;
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            bytes = this.blocks[blockIndex++];
            int lastByte = bytes.length;
            int startIndex = byteIndex;
            if (lastCharLeftOverByteCount > 0) {
                c = val.charAt(charIndex++);
                if (lastCharLeftOverByteCount == 2) {
                    bytes[byteIndex++] = (byte)(0x80 | c >>> 6 & 0x3F);
                }
                bytes[byteIndex++] = (byte)(0x80 | c >>> 0 & 0x3F);
                lastCharLeftOverByteCount = 0;
            }
            while (byteIndex < lastByte - 3 && charIndex < strLen) {
                if ((c = val.charAt(charIndex++)) >= '\u0000' && c <= '\u007f') {
                    bytes[byteIndex++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    bytes[byteIndex++] = (byte)(0xE0 | c >>> 12 & 0xF);
                    bytes[byteIndex++] = (byte)(0x80 | c >>> 6 & 0x3F);
                    bytes[byteIndex++] = (byte)(0x80 | c >>> 0 & 0x3F);
                    continue;
                }
                bytes[byteIndex++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c >>> 0 & 0x3F);
            }
            while (byteIndex < lastByte && charIndex < strLen) {
                c = val.charAt(charIndex);
                if (c >= '\u0000' && c <= '\u007f') {
                    bytes[byteIndex++] = (byte)c;
                } else if (c > '\u07ff') {
                    bytes[byteIndex++] = (byte)(0xE0 | c >>> 12 & 0xF);
                    if (byteIndex < lastByte) {
                        bytes[byteIndex++] = (byte)(0x80 | c >>> 6 & 0x3F);
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = (byte)(0x80 | c >>> 0 & 0x3F);
                        } else {
                            lastCharLeftOverByteCount = 1;
                        }
                    } else {
                        lastCharLeftOverByteCount = 2;
                    }
                } else {
                    bytes[byteIndex++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                    if (byteIndex < lastByte) {
                        bytes[byteIndex++] = (byte)(0x80 | c >>> 0 & 0x3F);
                    } else {
                        lastCharLeftOverByteCount = 1;
                    }
                }
                if (lastCharLeftOverByteCount != 0) continue;
                ++charIndex;
            }
            totalBytesWritten += byteIndex - startIndex;
            byteIndex = 0;
            if (charIndex >= strLen) break;
        }
        this.length = Math.max(this.length, offset + (long)totalBytesWritten + 1L);
        assert (charIndex == strLen) : "charIndex: " + charIndex + "\ttotalBytesWritten: " + totalBytesWritten;
        return totalBytesWritten;
    }

    private final int getCharsFromAL32UTF8(long offset, int lengthInBytes, char[] dst, int dstOffset) throws SQLException {
        assert (offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes) : "this.length: " + this.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        this.setGlobals(offset, lengthInBytes);
        int lastBlock = (int)((offset + (long)lengthInBytes - 1L) / this.blockSize) + 1;
        int lastByte = (int)((offset + (long)lengthInBytes - 1L) % this.blockSize) + 1;
        int charIndex = dstOffset;
        while (this.globalRemaining > 0) {
            byte c = this.next();
            if (c >= 0) {
                int localByteIndex;
                dst[charIndex++] = (char)c;
                int end = this.globalBlockIndex == lastBlock ? lastByte : (this.globalBlockIndex < lastBlock ? (int)this.blockSize : 0);
                for (localByteIndex = this.globalByteIndex; localByteIndex < end && this.globalBytes != null && (c = this.globalBytes[localByteIndex]) >= 0; ++localByteIndex) {
                    dst[charIndex++] = (char)c;
                }
                this.globalRemaining -= localByteIndex - this.globalByteIndex;
                this.globalByteIndex = localByteIndex;
                if (this.globalByteIndex < this.globalBlockSize) continue;
                this.globalByteIndex = 0;
                this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
                continue;
            }
            byte bb = c;
            if ((bb = (byte)(bb << 2)) >= 0) {
                if (this.globalRemaining < 1) {
                    dst[charIndex++] = 65533;
                    continue;
                }
                dst[charIndex++] = this.conv2ByteUTFtoUTF16(c, this.next());
                continue;
            }
            if ((bb = (byte)(bb << 1)) >= 0) {
                if (this.globalRemaining < 2) {
                    dst[charIndex++] = 65533;
                    continue;
                }
                dst[charIndex++] = this.conv3ByteAL32UTF8toUTF16(c, this.next(), this.next());
                continue;
            }
            if ((bb = (byte)(bb << 1)) >= 0) {
                if (this.globalRemaining < 3) {
                    dst[charIndex++] = 65533;
                    continue;
                }
                charIndex = this.conv4ByteAL32UTF8toUTF16(c, this.next(), this.next(), this.next(), dst, charIndex);
                continue;
            }
            dst[charIndex++] = 65533;
        }
        return charIndex - dstOffset;
    }

    private final int putStringFromAL32UTF8(long offset, String val) throws SQLException {
        assert (offset >= 0L && val != null && val.length() >= 0) : "this.length: " + this.length + " offset: " + offset + " val.length(): " + val.length();
        int strLen = val.length();
        int charIndex = 0;
        int MAX_BYTES_IN_CHAR = 4;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        int totalBytesWritten = 0;
        int lastCharLeftOverByteCount = 0;
        byte[] lastCharLeftOverBytes = new byte[3];
        while (true) {
            int uuuuu;
            char c2;
            char c;
            if (blockIndex >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.getNewBlock();
            }
            bytes = this.blocks[blockIndex++];
            int lastByte = bytes.length;
            int startIndex = byteIndex;
            if (lastCharLeftOverByteCount > 0) {
                for (int i = 0; i < lastCharLeftOverByteCount; ++i) {
                    bytes[byteIndex++] = lastCharLeftOverBytes[i];
                }
                lastCharLeftOverByteCount = 0;
            }
            while (byteIndex < lastByte - 4 && charIndex < strLen) {
                c = val.charAt(charIndex++);
                c2 = '\u0000';
                if (c >= '\u0000' && c <= '\u007f') {
                    bytes[byteIndex++] = (byte)c;
                    continue;
                }
                if (this.isHiSurrogate(c)) {
                    if (charIndex < strLen && this.isLoSurrogate(c2 = val.charAt(charIndex))) {
                        uuuuu = (c >>> 6 & 0xF) + 1;
                        bytes[byteIndex++] = (byte)(uuuuu >>> 2 | 0xF0);
                        bytes[byteIndex++] = (byte)((uuuuu & 3) << 4 | c >>> 2 & 0xF | 0x80);
                        bytes[byteIndex++] = (byte)((c & 3) << 4 | c2 >>> 6 & 0xF | 0x80);
                        bytes[byteIndex++] = (byte)(c2 & 0x3F | 0x80);
                        ++charIndex;
                        continue;
                    }
                    bytes[byteIndex++] = -17;
                    bytes[byteIndex++] = -65;
                    bytes[byteIndex++] = -67;
                    continue;
                }
                if (c > '\u07ff') {
                    bytes[byteIndex++] = (byte)(0xE0 | c >>> 12 & 0xF);
                    bytes[byteIndex++] = (byte)(0x80 | c >>> 6 & 0x3F);
                    bytes[byteIndex++] = (byte)(0x80 | c >>> 0 & 0x3F);
                    continue;
                }
                bytes[byteIndex++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c >>> 0 & 0x3F);
            }
            while (byteIndex < lastByte && charIndex < strLen) {
                byte b3;
                byte b2;
                c = val.charAt(charIndex++);
                c2 = '\u0000';
                if (c >= '\u0000' && c <= '\u007f') {
                    bytes[byteIndex++] = (byte)c;
                    continue;
                }
                if (this.isHiSurrogate(c)) {
                    if (charIndex < strLen && this.isLoSurrogate(c2 = val.charAt(charIndex))) {
                        uuuuu = (c >>> 6 & 0xF) + 1;
                        bytes[byteIndex++] = (byte)(uuuuu >>> 2 | 0xF0);
                        b2 = (byte)((uuuuu & 3) << 4 | c >>> 2 & 0xF | 0x80);
                        b3 = (byte)((c & 3) << 4 | c2 >>> 6 & 0xF | 0x80);
                        byte b4 = (byte)(c2 & 0x3F | 0x80);
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = b2;
                        } else {
                            lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b2;
                        }
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = b3;
                        } else {
                            lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b3;
                        }
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = b4;
                        } else {
                            lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b4;
                        }
                        ++charIndex;
                        continue;
                    }
                    bytes[byteIndex++] = -17;
                    if (byteIndex < lastByte) {
                        bytes[byteIndex++] = -65;
                    } else {
                        lastCharLeftOverBytes[lastCharLeftOverByteCount++] = -65;
                    }
                    if (byteIndex < lastByte) {
                        bytes[byteIndex++] = -67;
                        continue;
                    }
                    lastCharLeftOverBytes[lastCharLeftOverByteCount++] = -67;
                    continue;
                }
                if (c > '\u07ff') {
                    bytes[byteIndex++] = (byte)(0xE0 | c >>> 12 & 0xF);
                    b2 = (byte)(0x80 | c >>> 6 & 0x3F);
                    b3 = (byte)(0x80 | c >>> 0 & 0x3F);
                    if (byteIndex < lastByte) {
                        bytes[byteIndex++] = b2;
                    } else {
                        lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b2;
                    }
                    if (byteIndex < lastByte) {
                        bytes[byteIndex++] = b3;
                        continue;
                    }
                    lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b3;
                    continue;
                }
                bytes[byteIndex++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                if (byteIndex < lastByte) {
                    bytes[byteIndex++] = (byte)(0x80 | c >>> 0 & 0x3F);
                    continue;
                }
                lastCharLeftOverBytes[lastCharLeftOverByteCount++] = (byte)(0x80 | c >>> 0 & 0x3F);
            }
            totalBytesWritten += byteIndex - startIndex;
            byteIndex = 0;
            if (charIndex >= strLen && lastCharLeftOverByteCount <= 0) break;
        }
        this.length = Math.max(this.length, offset + (long)totalBytesWritten + 1L);
        assert (charIndex == strLen) : "charIndex: " + charIndex + "\ttotalBytesWritten: " + totalBytesWritten;
        return totalBytesWritten;
    }

    private final int putStringFromCharset(long offset, String val, CharacterSet charSet) throws SQLException {
        byte[] srcBytes = charSet.convert(val);
        this.put(offset, srcBytes, 0, srcBytes.length);
        return srcBytes.length;
    }

    private final int putStringFromCharsetWithReplacement(long offset, String val, CharacterSet charSet) throws SQLException {
        byte[] srcBytes = charSet.convertWithReplacement(val);
        this.put(offset, srcBytes, 0, srcBytes.length);
        return srcBytes.length;
    }

    private final boolean isHiSurrogate(char c) {
        return (char)(c & 0xFC00) == '\ud800';
    }

    private final boolean isLoSurrogate(char c) {
        return (char)(c & 0xFC00) == '\udc00';
    }

    private final boolean check80toBF(byte b) {
        return (b & 0xFFFFFFC0) == -128;
    }

    private final boolean check80to8F(byte b) {
        return (b & 0xFFFFFFF0) == -128;
    }

    private final boolean check80to9F(byte b) {
        return (b & 0xFFFFFFE0) == -128;
    }

    private final boolean checkA0toBF(byte b) {
        return (b & 0xFFFFFFE0) == -96;
    }

    private final boolean check90toBF(byte b) {
        return (b & 0xFFFFFFC0) == -128 && (b & 0x30) != 0;
    }

    private final char conv2ByteUTFtoUTF16(byte c, byte c2) {
        if (c < -62 || c > -33 || !this.check80toBF(c2)) {
            this.back();
            return '\ufffd';
        }
        return (char)((c & 0x1F) << 6 | c2 & 0x3F);
    }

    private final char conv3ByteUTFtoUTF16(byte c, byte c2, byte c3) {
        if (!(c == -32 && this.checkA0toBF(c2) && this.check80toBF(c3) || c >= -31 && c <= -17 && this.check80toBF(c2) && this.check80toBF(c3))) {
            this.back();
            this.back();
            return '\ufffd';
        }
        return (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
    }

    private final char conv3ByteAL32UTF8toUTF16(byte c, byte c2, byte c3) {
        if (!(c == -32 && this.checkA0toBF(c2) && this.check80toBF(c3) || c >= -31 && c <= -20 && this.check80toBF(c2) && this.check80toBF(c3) || c == -19 && this.check80to9F(c2) && this.check80toBF(c3) || c >= -18 && c <= -17 && this.check80toBF(c2) && this.check80toBF(c3))) {
            this.back();
            this.back();
            return '\ufffd';
        }
        return (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
    }

    private final int conv4ByteAL32UTF8toUTF16(byte c, byte c2, byte c3, byte c4, char[] chars, int charIndex) {
        boolean chars_count = false;
        if (!(c == -16 && this.check90toBF(c2) && this.check80toBF(c3) && this.check80toBF(c4) || c >= -15 && c <= -13 && this.check80toBF(c2) && this.check80toBF(c3) && this.check80toBF(c4) || c == -12 && this.check80to8F(c2) && this.check80toBF(c3) && this.check80toBF(c4))) {
            this.back();
            this.back();
            this.back();
            chars[charIndex++] = 65533;
        } else {
            chars[charIndex++] = (char)((((c & 7) << 2 | c2 >>> 4 & 3) - 1 & 0xF) << 6 | (c2 & 0xF) << 2 | c3 >>> 4 & 3 | 0xD800);
            chars[charIndex++] = (char)((c3 & 0xF) << 6 | c4 & 0x3F | 0xDC00);
        }
        return charIndex;
    }

    @Override
    byte[] getBlockBasic(long offset, int[] initialByteIndex) {
        int blockIndex = (int)(offset / this.blockSize);
        initialByteIndex[0] = (int)(offset % this.blockSize);
        if (blockIndex >= this.blocks.length) {
            return null;
        }
        return this.blocks[blockIndex];
    }

    private static String escape(String a) {
        StringBuilder b = new StringBuilder(a.length() * 6);
        for (char c : a.toCharArray()) {
            b.append("\\u");
            byte d = (byte)(c >> 8);
            String e = "00" + Integer.toHexString(d & 0xFF);
            b.append(e, e.length() - 2, e.length());
            e = "00" + Integer.toHexString((byte)c & 0xFF);
            b.append(e, e.length() - 2, e.length());
        }
        return b.toString();
    }

    @Override
    ByteArray compact() {
        ByteArray returnValue = this;
        assert (this.length >= 0L) : "DynamicByteArray length cannot be less than 0 length = " + this.length;
        if (this.length == 0L) {
            returnValue = new SimpleByteArray(this.diagnosable, PhysicalConnection.EMPTY_BYTE_ARRAY);
        } else if (this.length < 131072L) {
            returnValue = new SimpleByteArray(this.diagnosable, this.get(0L, (int)this.length()));
        }
        return returnValue;
    }

    @Override
    int getUtf8Bytes(long offset, int lengthInBytes, byte[] buffer, int bufferOffset, CharacterSet charSet) throws SQLException {
        String s;
        int returnValue = lengthInBytes;
        switch (charSet.getOracleId()) {
            case 1: {
                return this.getBytes(offset, lengthInBytes, buffer, bufferOffset);
            }
            case 2: {
                return this.getBytesFrom1Byte(offset, lengthInBytes, WE8DEC_TO_JAVA, buffer, bufferOffset);
            }
            case 31: {
                return this.getBytesFrom1Byte(offset, lengthInBytes, ISO_LATIN_1_TO_JAVA, buffer, bufferOffset);
            }
            case 46: {
                return this.getBytesFrom1Byte(offset, lengthInBytes, WE8ISO8859P15_TO_JAVA, buffer, bufferOffset);
            }
            case 178: {
                return this.getBytesFrom1Byte(offset, lengthInBytes, WE8MSWIN1252_TO_JAVA, buffer, bufferOffset);
            }
            case 2000: {
                return this.getBytesFromAL16UTF16(offset, lengthInBytes, buffer, bufferOffset);
            }
            case 2002: {
                return this.getBytesFromAL16UTF16LE(offset, lengthInBytes, buffer, bufferOffset);
            }
            case 871: {
                return this.getBytes(offset, lengthInBytes, buffer, bufferOffset);
            }
            case 873: {
                return this.getBytes(offset, lengthInBytes, buffer, bufferOffset);
            }
        }
        assert (false) : "charSet: " + charSet.toString();
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        if (lengthInBytes <= (int)this.blockSize - byteIndex) {
            s = charSet.toString(this.blocks[blockIndex], byteIndex, lengthInBytes);
        } else {
            byte[] b = this.get(offset, lengthInBytes);
            s = charSet.toString(b, 0, b.length);
        }
        CharacterSet utf8CharSet = CharacterSet.make(871);
        byte[] s2b = utf8CharSet.convert(s);
        System.arraycopy(s2b, 0, buffer, bufferOffset, s2b.length);
        returnValue = s2b.length;
        return returnValue;
    }

    private int getBytesFrom1Byte(long offset, int lengthInBytes, char[] byteToChar, byte[] buffer, int bufferOffset) throws SQLException {
        char[] chars = this.getCharsForNewString(lengthInBytes);
        int charIndex = this.getCharsFrom1Byte(offset, lengthInBytes, byteToChar, chars, 0);
        return CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, 0, buffer, bufferOffset, charIndex);
    }

    private final int getBytesFromAL16UTF16(long offset, int lengthInBytes, byte[] buffer, int bufferOffset) throws SQLException {
        char[] chars = this.getCharsForNewString(lengthInBytes / 2);
        int charIndex = this.getCharsFromAL16UTF16(offset, lengthInBytes, chars, 0);
        return CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, 0, buffer, bufferOffset, charIndex);
    }

    private final int getBytesFromAL16UTF16LE(long offset, int lengthInBytes, byte[] buffer, int bufferOffset) throws SQLException {
        char[] chars = this.getCharsForNewString(lengthInBytes / 2);
        int charIndex = this.getCharsFromAL16UTF16LE(offset, lengthInBytes, chars, 0);
        return CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, 0, buffer, bufferOffset, charIndex);
    }

    private final int getBytes(long offset, int lengthInBytes, byte[] buffer, int bufferOffset) throws SQLException {
        assert (offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes) : "this.length: " + this.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        byte[] bytes = null;
        int bytesRemaining = lengthInBytes;
        int totalBytes = 0;
        while (bytesRemaining > 0) {
            bytes = this.blocks[blockIndex++];
            int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
            int numCopyBytes = lastByte - byteIndex;
            System.arraycopy(bytes, byteIndex, buffer, bufferOffset, numCopyBytes);
            bytesRemaining -= numCopyBytes;
            bufferOffset += numCopyBytes;
            totalBytes += numCopyBytes;
            byteIndex = 0;
        }
        return totalBytes;
    }

    @Override
    void putFloats(long offset, float[] floatArray, int arrayOffset, int length, ByteArray.NumberEncoding encoding) throws SQLException {
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        while (blockIndex >= this.blocks.length) {
            this.grow();
        }
        if (this.blocks[blockIndex] == null) {
            this.blocks[blockIndex] = this.source.get();
        }
        byte[] block = this.blocks[blockIndex];
        int arrayLimit = arrayOffset + length;
        while (arrayOffset < arrayLimit) {
            FloatBuffer floatBuffer = ByteBuffer.wrap(block, byteIndex, block.length - byteIndex).order(encoding.byteOrder()).asFloatBuffer();
            int putLength = Math.min(arrayLimit - arrayOffset, floatBuffer.remaining());
            floatBuffer.put(floatArray, arrayOffset, putLength);
            arrayOffset += putLength;
            int lastByteIndex = byteIndex + (putLength << 2);
            if (!encoding.isIeee()) {
                int msbOffset = encoding.byteOrder() == ByteOrder.LITTLE_ENDIAN ? 3 : 0;
                for (int i = byteIndex; i < lastByteIndex; i += 4) {
                    if ((block[i + msbOffset] & 0x80) == 0) {
                        int n = i + msbOffset;
                        block[n] = (byte)(block[n] | 0x80);
                        continue;
                    }
                    block[i] = ~block[i];
                    block[i + 1] = ~block[i + 1];
                    block[i + 2] = ~block[i + 2];
                    block[i + 3] = ~block[i + 3];
                }
            }
            if (arrayOffset == arrayLimit) break;
            int leftoverBytes = block.length - lastByteIndex;
            ++blockIndex;
            while (blockIndex >= this.blocks.length) {
                this.grow();
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.source.get();
            }
            block = this.blocks[blockIndex];
            byteIndex = 0;
            if (leftoverBytes == 0) continue;
            long nextFloatOffset = offset + ((long)arrayOffset << 2);
            float nextFloat = floatArray[arrayOffset++];
            this.putFloat(nextFloatOffset, nextFloat, encoding);
            byteIndex = 4 - leftoverBytes;
        }
        this.length = Math.max(this.length, offset + ((long)length << 2) + 1L);
    }

    @Override
    void putDoubles(long offset, double[] doubleArray, int arrayOffset, int length, ByteArray.NumberEncoding encoding) throws SQLException {
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        while (blockIndex >= this.blocks.length) {
            this.grow();
        }
        if (this.blocks[blockIndex] == null) {
            this.blocks[blockIndex] = this.source.get();
        }
        byte[] block = this.blocks[blockIndex];
        int arrayLimit = arrayOffset + length;
        while (arrayOffset < arrayLimit) {
            DoubleBuffer doubleBuffer = ByteBuffer.wrap(block, byteIndex, block.length - byteIndex).order(encoding.byteOrder()).asDoubleBuffer();
            int putLength = Math.min(arrayLimit - arrayOffset, doubleBuffer.remaining());
            doubleBuffer.put(doubleArray, arrayOffset, putLength);
            arrayOffset += putLength;
            int lastByteIndex = byteIndex + (putLength << 3);
            if (!encoding.isIeee()) {
                int msbOffset = encoding.byteOrder() == ByteOrder.LITTLE_ENDIAN ? 7 : 0;
                for (int i = byteIndex; i < lastByteIndex; i += 8) {
                    if ((block[i + msbOffset] & 0x80) == 0) {
                        int n = i + msbOffset;
                        block[n] = (byte)(block[n] | 0x80);
                        continue;
                    }
                    block[i] = ~block[i];
                    block[i + 1] = ~block[i + 1];
                    block[i + 2] = ~block[i + 2];
                    block[i + 3] = ~block[i + 3];
                    block[i + 4] = ~block[i + 4];
                    block[i + 5] = ~block[i + 5];
                    block[i + 6] = ~block[i + 6];
                    block[i + 7] = ~block[i + 7];
                }
            }
            if (arrayOffset == arrayLimit) break;
            int leftoverBytes = block.length - lastByteIndex;
            ++blockIndex;
            while (blockIndex >= this.blocks.length) {
                this.grow();
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.source.get();
            }
            block = this.blocks[blockIndex];
            byteIndex = 0;
            if (leftoverBytes == 0) continue;
            long nextOffset = offset + ((long)arrayOffset << 3);
            double nextDouble = doubleArray[arrayOffset++];
            this.putDouble(nextOffset, nextDouble, encoding);
            byteIndex = 8 - leftoverBytes;
        }
        this.length = Math.max(this.length, offset + ((long)length << 3) + 1L);
    }

    @Override
    void getFloats(long offset, float[] floatArray, int arrayOffset, int length, ByteArray.NumberEncoding encoding) {
        if (!encoding.isIeee()) {
            super.getFloats(offset, floatArray, arrayOffset, length, encoding);
            return;
        }
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        assert (this.blocks.length >= blockIndex && this.blocks[blockIndex] != null) : "invalid read--blocks.length: " + this.blocks.length + " blockIndex: " + blockIndex + (String)(blockIndex < this.blocks.length ? " blocks[" + blockIndex + "]: " + this.blocks[blockIndex] : "");
        byte[] block = this.blocks[blockIndex];
        int arrayLimit = arrayOffset + length;
        while (arrayOffset < arrayLimit) {
            FloatBuffer floatBuffer = ByteBuffer.wrap(block, byteIndex, block.length - byteIndex).order(encoding.byteOrder()).asFloatBuffer();
            int getLength = Math.min(arrayLimit - arrayOffset, floatBuffer.remaining());
            floatBuffer.get(floatArray, arrayOffset, getLength);
            if ((arrayOffset += getLength) == arrayLimit) {
                return;
            }
            int leftoverBytes = block.length - (byteIndex + (getLength << 2));
            block = this.blocks[++blockIndex];
            byteIndex = 0;
            if (leftoverBytes == 0) continue;
            long nextOffset = offset + ((long)arrayOffset << 2);
            float nextFloat = this.getFloat(nextOffset, encoding);
            floatArray[arrayOffset++] = nextFloat;
            byteIndex = 4 - leftoverBytes;
        }
    }

    @Override
    void getDoubles(long offset, double[] doubleArray, int arrayOffset, int length, ByteArray.NumberEncoding encoding) {
        if (!encoding.isIeee()) {
            super.getDoubles(offset, doubleArray, arrayOffset, length, encoding);
            return;
        }
        int blockIndex = (int)(offset / this.blockSize);
        int byteIndex = (int)(offset % this.blockSize);
        assert (this.blocks.length >= blockIndex && this.blocks[blockIndex] != null) : "invalid read--blocks.length: " + this.blocks.length + " blockIndex: " + blockIndex + (String)(blockIndex < this.blocks.length ? " blocks[" + blockIndex + "]: " + this.blocks[blockIndex] : "");
        byte[] block = this.blocks[blockIndex];
        int arrayLimit = arrayOffset + length;
        while (arrayOffset < arrayLimit) {
            DoubleBuffer doubleBuffer = ByteBuffer.wrap(block, byteIndex, block.length - byteIndex).order(encoding.byteOrder()).asDoubleBuffer();
            int getLength = Math.min(arrayLimit - arrayOffset, doubleBuffer.remaining());
            doubleBuffer.get(doubleArray, arrayOffset, getLength);
            if ((arrayOffset += getLength) == arrayLimit) {
                return;
            }
            int leftoverBytes = block.length - (byteIndex + (getLength << 3));
            block = this.blocks[++blockIndex];
            byteIndex = 0;
            if (leftoverBytes == 0) continue;
            long nextOffset = offset + ((long)arrayOffset << 3);
            double nextDouble = this.getDouble(nextOffset, encoding);
            doubleArray[arrayOffset++] = nextDouble;
            byteIndex = 8 - leftoverBytes;
        }
    }

    static {
        final char[][] tmp = new char[19][];
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JdbcCharacterConverters cc = CharacterConverterJDBC.getInstance(31);
                tmp[0] = DynamicByteArray.intToChar(((CharacterConverter1Byte)cc).m_ucsChar);
                tmp[1] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[2] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[3] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                cc = CharacterConverterJDBC.getInstance(2);
                tmp[4] = DynamicByteArray.intToChar(((CharacterConverter1Byte)cc).m_ucsChar);
                tmp[5] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[6] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[7] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                cc = CharacterConverterJDBC.getInstance(178);
                tmp[8] = DynamicByteArray.intToChar(((CharacterConverter1Byte)cc).m_ucsChar);
                tmp[9] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[10] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[11] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                cc = CharacterConverterJDBC.getInstance(1);
                tmp[12] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[13] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[14] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                cc = CharacterConverterJDBC.getInstance(46);
                tmp[15] = DynamicByteArray.intToChar(((CharacterConverter1Byte)cc).m_ucsChar);
                tmp[16] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[17] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[18] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                return null;
            }
        });
        ISO_LATIN_1_TO_JAVA = tmp[0];
        JAVA_TO_ISO_LATIN_1_LEVEL1 = tmp[1];
        JAVA_TO_ISO_LATIN_1_LEVEL2 = tmp[2];
        JAVA_TO_ISO_LATIN_1_REPLACEMENT = tmp[3][0];
        WE8DEC_TO_JAVA = tmp[4];
        JAVA_TO_WE8DEC_LEVEL1 = tmp[5];
        JAVA_TO_WE8DEC_LEVEL2 = tmp[6];
        JAVA_TO_WE8DEC_REPLACEMENT = tmp[7][0];
        WE8MSWIN1252_TO_JAVA = tmp[8];
        JAVA_TO_WE8MSWIN1252_LEVEL1 = tmp[9];
        JAVA_TO_WE8MSWIN1252_LEVEL2 = tmp[10];
        JAVA_TO_WE8MSWIN1252_REPLACEMENT = tmp[11][0];
        JAVA_TO_US7ASCII_LEVEL1 = tmp[12];
        JAVA_TO_US7ASCII_LEVEL2 = tmp[13];
        JAVA_TO_US7ASCII_REPLACEMENT = tmp[14][0];
        WE8ISO8859P15_TO_JAVA = tmp[15];
        JAVA_TO_WE8ISO8859P15_LEVEL1 = tmp[16];
        JAVA_TO_WE8ISO8859P15_LEVEL2 = tmp[17];
        JAVA_TO_WE8ISO8859P15_REPLACEMENT = tmp[18][0];
    }
}

