/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.driver.T4CCallableStatement;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

final class OracleExecutingStatement
implements OracleCallableStatement {
    private final OracleStatement statement;
    private final CountDownLatch latch;

    OracleExecutingStatement(OracleStatement statement) {
        this.statement = statement;
        this.latch = new CountDownLatch(1);
    }

    void endExecution() {
        this.latch.countDown();
    }

    void awaitExecution() {
        try {
            Pipeline pipeline;
            Pipeline pipeline2 = this.statement instanceof T4CStatement ? ((T4CStatement)this.statement).t4Connection.pipeline() : (this.statement instanceof T4CPreparedStatement ? ((T4CPreparedStatement)this.statement).t4Connection.pipeline() : (pipeline = this.statement instanceof T4CCallableStatement ? ((T4CCallableStatement)this.statement).t4Connection.pipeline() : null));
            if (pipeline != null) {
                while (this.latch.getCount() != 0L) {
                    pipeline.await(100L, TimeUnit.MILLISECONDS);
                }
            }
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private OraclePreparedStatement unwrapPreparedStatement() {
        try {
            return this.statement.unwrap(OraclePreparedStatement.class);
        }
        catch (SQLException sqlException) {
            throw new RuntimeException(sqlException);
        }
    }

    private OracleCallableStatement unwrapCallableStatement() {
        try {
            return this.statement.unwrap(OracleCallableStatement.class);
        }
        catch (SQLException sqlException) {
            throw new RuntimeException(sqlException);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public void setFixedString(boolean fixedString) {
        this.awaitExecution();
        this.statement.setFixedString(fixedString);
    }

    @Override
    public boolean getFixedString() {
        this.awaitExecution();
        return this.statement.getFixedString();
    }

    @Override
    public int sendBatch() throws SQLException {
        this.awaitExecution();
        return this.statement.sendBatch();
    }

    @Override
    public boolean getserverCursor() {
        this.awaitExecution();
        return this.statement.getserverCursor();
    }

    @Override
    public int getcacheState() {
        this.awaitExecution();
        return this.statement.getcacheState();
    }

    @Override
    public int getstatementType() {
        this.awaitExecution();
        return this.statement.getstatementType();
    }

    @Override
    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        this.awaitExecution();
        return this.statement.getSqlKind();
    }

    @Override
    public long getChecksum() throws SQLException {
        this.awaitExecution();
        return this.statement.getChecksum();
    }

    @Override
    public void registerBindChecksumListener(OracleStatement.BindChecksumListener listener) throws SQLException {
        this.awaitExecution();
        this.statement.registerBindChecksumListener(listener);
    }

    @Override
    public void setSnapshotSCN(long scn) throws SQLException {
        this.awaitExecution();
        this.statement.setSnapshotSCN(scn);
    }

    @Override
    public long getQueryId() throws SQLException {
        this.awaitExecution();
        return this.statement.getQueryId();
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        this.awaitExecution();
        return this.statement.getCompileKey();
    }

    @Override
    public void setShardingKeyRpnTokens(byte[] shardingKeyRpnTokens) throws SQLException {
        this.awaitExecution();
        this.statement.setShardingKeyRpnTokens(shardingKeyRpnTokens);
    }

    @Override
    public byte[] getShardingKeyRpnTokens() throws SQLException {
        this.awaitExecution();
        return this.statement.getShardingKeyRpnTokens();
    }

    @Override
    public void clearDefines() throws SQLException {
        this.awaitExecution();
        this.statement.clearDefines();
    }

    @Override
    public void defineColumnType(int columnIndex, int type) throws SQLException {
        this.awaitExecution();
        this.statement.defineColumnType(columnIndex, type);
    }

    @Override
    public void defineColumnType(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.awaitExecution();
        this.statement.defineColumnType(columnIndex, type, lobPrefetchSize);
    }

    @Override
    public void defineColumnType(int columnIndex, int type, int lobPrefetchSize, short formOfUse) throws SQLException {
        this.awaitExecution();
        this.statement.defineColumnType(columnIndex, type, lobPrefetchSize, formOfUse);
    }

    @Override
    public void defineColumnTypeBytes(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.awaitExecution();
        this.statement.defineColumnTypeBytes(columnIndex, type, lobPrefetchSize);
    }

    @Override
    public void defineColumnTypeChars(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.awaitExecution();
        this.statement.defineColumnTypeChars(columnIndex, type, lobPrefetchSize);
    }

    @Override
    public void defineColumnType(int columnIndex, int typeCode, String typeName) throws SQLException {
        this.awaitExecution();
        this.statement.defineColumnType(columnIndex, typeCode, typeName);
    }

    @Override
    public int getRowPrefetch() {
        this.awaitExecution();
        return this.statement.getRowPrefetch();
    }

    @Override
    public void setRowPrefetch(int value) throws SQLException {
        this.awaitExecution();
        this.statement.setRowPrefetch(value);
    }

    @Override
    public int getLobPrefetchSize() throws SQLException {
        this.awaitExecution();
        return this.statement.getLobPrefetchSize();
    }

    @Override
    public void setLobPrefetchSize(int value) throws SQLException {
        this.awaitExecution();
        this.statement.setLobPrefetchSize(value);
    }

    @Override
    public void closeWithKey(String key) throws SQLException {
        this.awaitExecution();
        this.statement.closeWithKey(key);
    }

    @Override
    public int creationState() {
        this.awaitExecution();
        return this.statement.creationState();
    }

    @Override
    public boolean isNCHAR(int index) throws SQLException {
        this.awaitExecution();
        return this.statement.isNCHAR(index);
    }

    @Override
    public void setDatabaseChangeRegistration(DatabaseChangeRegistration registration) throws SQLException {
        this.awaitExecution();
        this.statement.setDatabaseChangeRegistration(registration);
    }

    @Override
    public String[] getRegisteredTableNames() throws SQLException {
        this.awaitExecution();
        return this.statement.getRegisteredTableNames();
    }

    @Override
    public long getRegisteredQueryId() throws SQLException {
        this.awaitExecution();
        return this.statement.getRegisteredQueryId();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.awaitExecution();
        this.statement.closeOnCompletion();
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        this.awaitExecution();
        return this.statement.enquoteLiteral(val);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        this.awaitExecution();
        return this.statement.enquoteNCharLiteral(val);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        this.awaitExecution();
        return this.statement.isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        this.awaitExecution();
        return this.statement.enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.awaitExecution();
        return this.statement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.awaitExecution();
        return this.statement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.awaitExecution();
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.awaitExecution();
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.awaitExecution();
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.awaitExecution();
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.awaitExecution();
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.awaitExecution();
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.awaitExecution();
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.awaitExecution();
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.awaitExecution();
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.awaitExecution();
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.awaitExecution();
        this.statement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.awaitExecution();
        return this.statement.execute(sql);
    }

    @Override
    public String getSqlId() throws SQLException {
        this.awaitExecution();
        return this.statement.getSqlId();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.awaitExecution();
        return this.statement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.awaitExecution();
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.awaitExecution();
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.awaitExecution();
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.awaitExecution();
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.awaitExecution();
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.awaitExecution();
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.awaitExecution();
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.awaitExecution();
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.awaitExecution();
        this.statement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.awaitExecution();
        this.statement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.awaitExecution();
        return this.statement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.awaitExecution();
        return this.statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.awaitExecution();
        return this.statement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.awaitExecution();
        return this.statement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.awaitExecution();
        return this.statement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.awaitExecution();
        return this.statement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.awaitExecution();
        return this.statement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.awaitExecution();
        return this.statement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.awaitExecution();
        return this.statement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.awaitExecution();
        return this.statement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.awaitExecution();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.awaitExecution();
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.awaitExecution();
        return this.statement.isPoolable();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.awaitExecution();
        return this.statement.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.awaitExecution();
        return this.statement.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.awaitExecution();
        this.statement.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.awaitExecution();
        return this.statement.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.awaitExecution();
        return this.statement.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.awaitExecution();
        return this.statement.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.awaitExecution();
        return this.statement.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.awaitExecution();
        return this.statement.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.awaitExecution();
        return this.statement.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.awaitExecution();
        return this.statement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.awaitExecution();
        return this.statement.isWrapperFor(iface);
    }

    @Override
    public void setACProxy(Object w) {
        this.awaitExecution();
        this.statement.setACProxy(w);
    }

    @Override
    public Object getACProxy() {
        this.awaitExecution();
        return this.statement.getACProxy();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNClob(parameterIndex, reader);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().executeLargeUpdate();
    }

    @Override
    public void defineParameterTypeBytes(int param_index, int type, int max_size) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().defineParameterTypeBytes(param_index, type, max_size);
    }

    @Override
    public void defineParameterTypeChars(int param_index, int type, int max_size) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().defineParameterTypeChars(param_index, type, max_size);
    }

    @Override
    public void defineParameterType(int param_index, int type, int max_size) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().defineParameterType(param_index, type, max_size);
    }

    @Override
    public int getExecuteBatch() {
        this.awaitExecution();
        return this.unwrapPreparedStatement().getExecuteBatch();
    }

    @Override
    public void setARRAY(int parameterIndex, ARRAY arr) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setARRAY(parameterIndex, arr);
    }

    @Override
    public void setBfile(int parameterIndex, BFILE file) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBfile(parameterIndex, file);
    }

    @Override
    public void setBFILE(int parameterIndex, BFILE file) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBFILE(parameterIndex, file);
    }

    @Override
    public void setBLOB(int parameterIndex, BLOB lob) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBLOB(parameterIndex, lob);
    }

    @Override
    public void setCHAR(int parameterIndex, CHAR ch) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCHAR(parameterIndex, ch);
    }

    @Override
    public void setCLOB(int parameterIndex, CLOB lob) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCLOB(parameterIndex, lob);
    }

    @Override
    public void setCursor(int parameterIndex, ResultSet rs) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCursor(parameterIndex, rs);
    }

    @Override
    public void setCustomDatum(int parameterIndex, CustomDatum x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCustomDatum(parameterIndex, x);
    }

    @Override
    public void setORAData(int parameterIndex, ORAData x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setORAData(parameterIndex, x);
    }

    @Override
    public void setDATE(int parameterIndex, DATE date) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDATE(parameterIndex, date);
    }

    @Override
    public void setExecuteBatch(int batchValue) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setExecuteBatch(batchValue);
    }

    @Override
    public void setFixedCHAR(int parameterIndex, String x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setFixedCHAR(parameterIndex, x);
    }

    @Override
    public void setNUMBER(int parameterIndex, NUMBER num) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNUMBER(parameterIndex, num);
    }

    @Override
    public void setBinaryFloat(int parameterIndex, float value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryFloat(parameterIndex, value);
    }

    @Override
    public void setBinaryFloat(int parameterIndex, BINARY_FLOAT value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryFloat(parameterIndex, value);
    }

    @Override
    public void setBinaryDouble(int parameterIndex, double value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryDouble(parameterIndex, value);
    }

    @Override
    public void setBinaryDouble(int parameterIndex, BINARY_DOUBLE value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryDouble(parameterIndex, value);
    }

    @Override
    public void setOPAQUE(int parameterIndex, OPAQUE val) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setOPAQUE(parameterIndex, val);
    }

    @Override
    public void setOracleObject(int parameterIndex, Datum x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setOracleObject(parameterIndex, x);
    }

    @Override
    public void setStructDescriptor(int parameterIndex, StructDescriptor desc) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setStructDescriptor(parameterIndex, desc);
    }

    @Override
    public void setRAW(int parameterIndex, RAW raw) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setRAW(parameterIndex, raw);
    }

    @Override
    public void setREF(int parameterIndex, REF ref) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setREF(parameterIndex, ref);
    }

    @Override
    public void setRefType(int parameterIndex, REF ref) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setRefType(parameterIndex, ref);
    }

    @Override
    public void setROWID(int parameterIndex, ROWID rowid) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setROWID(parameterIndex, rowid);
    }

    @Override
    public void setSTRUCT(int parameterIndex, STRUCT struct) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setSTRUCT(parameterIndex, struct);
    }

    @Override
    public void setTIMESTAMP(int parameterIndex, TIMESTAMP x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTIMESTAMP(parameterIndex, x);
    }

    @Override
    public void setTIMESTAMPTZ(int parameterIndex, TIMESTAMPTZ x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTIMESTAMPTZ(parameterIndex, x);
    }

    @Override
    public void setTIMESTAMPLTZ(int parameterIndex, TIMESTAMPLTZ x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTIMESTAMPLTZ(parameterIndex, x);
    }

    @Override
    public void setINTERVALYM(int parameterIndex, INTERVALYM x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setINTERVALYM(parameterIndex, x);
    }

    @Override
    public void setINTERVALDS(int parameterIndex, INTERVALDS x) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setINTERVALDS(parameterIndex, x);
    }

    @Override
    public void setNullAtName(String parameterName, int sqlType, String sqlName) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNullAtName(parameterName, sqlType, sqlName);
    }

    @Override
    public void setNullAtName(String parameterName, int sqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNullAtName(parameterName, sqlType);
    }

    @Override
    public void setBooleanAtName(String parameterName, boolean value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBooleanAtName(parameterName, value);
    }

    @Override
    public void setByteAtName(String parameterName, byte value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setByteAtName(parameterName, value);
    }

    @Override
    public void setShortAtName(String parameterName, short value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setShortAtName(parameterName, value);
    }

    @Override
    public void setIntAtName(String parameterName, int value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setIntAtName(parameterName, value);
    }

    @Override
    public void setLongAtName(String parameterName, long value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setLongAtName(parameterName, value);
    }

    @Override
    public void setFloatAtName(String parameterName, float value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setFloatAtName(parameterName, value);
    }

    @Override
    public void setDoubleAtName(String parameterName, double value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDoubleAtName(parameterName, value);
    }

    @Override
    public void setBinaryFloatAtName(String parameterName, float value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryFloatAtName(parameterName, value);
    }

    @Override
    public void setBinaryFloatAtName(String parameterName, BINARY_FLOAT value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryFloatAtName(parameterName, value);
    }

    @Override
    public void setBinaryDoubleAtName(String parameterName, double value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryDoubleAtName(parameterName, value);
    }

    @Override
    public void setBinaryDoubleAtName(String parameterName, BINARY_DOUBLE value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryDoubleAtName(parameterName, value);
    }

    @Override
    public void setBigDecimalAtName(String parameterName, BigDecimal value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBigDecimalAtName(parameterName, value);
    }

    @Override
    public void setStringAtName(String parameterName, String value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setStringAtName(parameterName, value);
    }

    @Override
    public void setStringForClob(int parameterIndex, String value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setStringForClob(parameterIndex, value);
    }

    @Override
    public void setStringForClobAtName(String parameterName, String value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setStringForClobAtName(parameterName, value);
    }

    @Override
    public void setFixedCHARAtName(String parameterName, String value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setFixedCHARAtName(parameterName, value);
    }

    @Override
    public void setCursorAtName(String parameterName, ResultSet value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCursorAtName(parameterName, value);
    }

    @Override
    public void setROWIDAtName(String parameterName, ROWID value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setROWIDAtName(parameterName, value);
    }

    @Override
    public void setArrayAtName(String parameterName, Array value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setArrayAtName(parameterName, value);
    }

    @Override
    public void setARRAYAtName(String parameterName, ARRAY value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setARRAYAtName(parameterName, value);
    }

    @Override
    public void setOPAQUEAtName(String parameterName, OPAQUE value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setOPAQUEAtName(parameterName, value);
    }

    @Override
    public void setStructDescriptorAtName(String parameterName, StructDescriptor desc) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setStructDescriptorAtName(parameterName, desc);
    }

    @Override
    public void setSTRUCTAtName(String parameterName, STRUCT value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setSTRUCTAtName(parameterName, value);
    }

    @Override
    public void setRAWAtName(String parameterName, RAW value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setRAWAtName(parameterName, value);
    }

    @Override
    public void setCHARAtName(String parameterName, CHAR value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCHARAtName(parameterName, value);
    }

    @Override
    public void setDATEAtName(String parameterName, DATE value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDATEAtName(parameterName, value);
    }

    @Override
    public void setNUMBERAtName(String parameterName, NUMBER value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNUMBERAtName(parameterName, value);
    }

    @Override
    public void setBLOBAtName(String parameterName, BLOB value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBLOBAtName(parameterName, value);
    }

    @Override
    public void setBlobAtName(String parameterName, Blob value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBlobAtName(parameterName, value);
    }

    @Override
    public void setBlobAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBlobAtName(parameterName, stream, length);
    }

    @Override
    public void setBlobAtName(String parameterName, InputStream stream) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBlobAtName(parameterName, stream);
    }

    @Override
    public void setCLOBAtName(String parameterName, CLOB value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCLOBAtName(parameterName, value);
    }

    @Override
    public void setClobAtName(String parameterName, Clob value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setClobAtName(parameterName, value);
    }

    @Override
    public void setClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setClobAtName(parameterName, reader, length);
    }

    @Override
    public void setClobAtName(String parameterName, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setClobAtName(parameterName, reader);
    }

    @Override
    public void setBFILEAtName(String parameterName, BFILE value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBFILEAtName(parameterName, value);
    }

    @Override
    public void setBfileAtName(String parameterName, BFILE value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBfileAtName(parameterName, value);
    }

    @Override
    public void setBytesAtName(String parameterName, byte[] value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBytesAtName(parameterName, value);
    }

    @Override
    public void setBytesForBlob(int parameterIndex, byte[] value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBytesForBlob(parameterIndex, value);
    }

    @Override
    public void setBytesForBlobAtName(String parameterName, byte[] value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBytesForBlobAtName(parameterName, value);
    }

    @Override
    public void setDateAtName(String parameterName, Date value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDateAtName(parameterName, value);
    }

    @Override
    public void setDateAtName(String parameterName, Date value, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDateAtName(parameterName, value, cal);
    }

    @Override
    public void setTimeAtName(String parameterName, Time value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTimeAtName(parameterName, value);
    }

    @Override
    public void setTimeAtName(String parameterName, Time value, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTimeAtName(parameterName, value, cal);
    }

    @Override
    public void setTimestampAtName(String parameterName, Timestamp value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTimestampAtName(parameterName, value);
    }

    @Override
    public void setTimestampAtName(String parameterName, Timestamp value, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTimestampAtName(parameterName, value, cal);
    }

    @Override
    public void setINTERVALYMAtName(String parameterName, INTERVALYM value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setINTERVALYMAtName(parameterName, value);
    }

    @Override
    public void setINTERVALDSAtName(String parameterName, INTERVALDS value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setINTERVALDSAtName(parameterName, value);
    }

    @Override
    public void setTIMESTAMPAtName(String parameterName, TIMESTAMP value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTIMESTAMPAtName(parameterName, value);
    }

    @Override
    public void setTIMESTAMPTZAtName(String parameterName, TIMESTAMPTZ value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTIMESTAMPTZAtName(parameterName, value);
    }

    @Override
    public void setTIMESTAMPLTZAtName(String parameterName, TIMESTAMPLTZ value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setTIMESTAMPLTZAtName(parameterName, value);
    }

    @Override
    public void setAsciiStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setAsciiStreamAtName(parameterName, stream, length);
    }

    @Override
    public void setAsciiStreamAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setAsciiStreamAtName(parameterName, stream, length);
    }

    @Override
    public void setAsciiStreamAtName(String parameterName, InputStream stream) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setAsciiStreamAtName(parameterName, stream);
    }

    @Override
    public void setBinaryStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryStreamAtName(parameterName, stream, length);
    }

    @Override
    public void setBinaryStreamAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryStreamAtName(parameterName, stream, length);
    }

    @Override
    public void setBinaryStreamAtName(String parameterName, InputStream stream) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setBinaryStreamAtName(parameterName, stream);
    }

    @Override
    public void setCharacterStreamAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCharacterStreamAtName(parameterName, reader, length);
    }

    @Override
    public void setCharacterStreamAtName(String parameterName, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCharacterStreamAtName(parameterName, reader);
    }

    @Override
    public void setUnicodeStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setUnicodeStreamAtName(parameterName, stream, length);
    }

    @Override
    public void setCustomDatumAtName(String parameterName, CustomDatum value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCustomDatumAtName(parameterName, value);
    }

    @Override
    public void setORADataAtName(String parameterName, ORAData value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setORADataAtName(parameterName, value);
    }

    @Override
    public void setObjectAtName(String parameterName, Object value, int targetSqlType, int scale) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setObjectAtName(parameterName, value, targetSqlType, scale);
    }

    @Override
    public void setObjectAtName(String parameterName, Object value, int targetSqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setObjectAtName(parameterName, value, targetSqlType);
    }

    @Override
    public void setRefTypeAtName(String parameterName, REF value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setRefTypeAtName(parameterName, value);
    }

    @Override
    public void setRefAtName(String parameterName, Ref value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setRefAtName(parameterName, value);
    }

    @Override
    public void setREFAtName(String parameterName, REF value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setREFAtName(parameterName, value);
    }

    @Override
    public void setObjectAtName(String parameterName, Object value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setObjectAtName(parameterName, value);
    }

    @Override
    public void setOracleObjectAtName(String parameterName, Datum value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setOracleObjectAtName(parameterName, value);
    }

    @Override
    public void setURLAtName(String parameterName, URL value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setURLAtName(parameterName, value);
    }

    @Override
    public void setCheckBindTypes(boolean flag) {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCheckBindTypes(flag);
    }

    @Override
    @Deprecated
    public void setPlsqlIndexTable(int parameterIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setPlsqlIndexTable(parameterIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
    }

    @Override
    public void setFormOfUse(int parameterIndex, short formOfUse) {
        this.awaitExecution();
        this.unwrapPreparedStatement().setFormOfUse(parameterIndex, formOfUse);
    }

    @Override
    public void setDisableStmtCaching(boolean cache) {
        this.awaitExecution();
        this.unwrapPreparedStatement().setDisableStmtCaching(cache);
    }

    @Override
    public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().OracleGetParameterMetaData();
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().registerReturnParameter(paramIndex, externalType);
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType, int maxSize) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().registerReturnParameter(paramIndex, externalType, maxSize);
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType, String typeName) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().registerReturnParameter(paramIndex, externalType, typeName);
    }

    @Override
    public ResultSet getReturnResultSet() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().getReturnResultSet();
    }

    @Override
    public void setNCharacterStreamAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNCharacterStreamAtName(parameterName, reader, length);
    }

    @Override
    public void setNCharacterStreamAtName(String parameterName, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNCharacterStreamAtName(parameterName, reader);
    }

    @Override
    public void setNClobAtName(String parameterName, NClob value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNClobAtName(parameterName, value);
    }

    @Override
    public void setNClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNClobAtName(parameterName, reader, length);
    }

    @Override
    public void setNClobAtName(String parameterName, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNClobAtName(parameterName, reader);
    }

    @Override
    public void setNStringAtName(String parameterName, String value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setNStringAtName(parameterName, value);
    }

    @Override
    public void setRowIdAtName(String parameterName, RowId value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setRowIdAtName(parameterName, value);
    }

    @Override
    public void setSQLXMLAtName(String parameterName, SQLXML value) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setSQLXMLAtName(parameterName, value);
    }

    @Override
    public Flow.Publisher<OracleResultSet> executeQueryAsyncOracle() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().executeQueryAsyncOracle();
    }

    @Override
    public Flow.Publisher<Boolean> executeAsyncOracle() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().executeAsyncOracle();
    }

    @Override
    public Flow.Publisher<Long> executeUpdateAsyncOracle() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().executeUpdateAsyncOracle();
    }

    @Override
    public Flow.Publisher<Long> executeBatchAsyncOracle() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().executeBatchAsyncOracle();
    }

    @Override
    public void setInternalBytes(int paramIndex, byte[] x, int dbtype) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setInternalBytes(paramIndex, x, dbtype);
    }

    @Override
    public void enterImplicitCache() throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().enterImplicitCache();
    }

    @Override
    public void enterExplicitCache() throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().enterExplicitCache();
    }

    @Override
    public void exitImplicitCacheToActive() throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().exitImplicitCacheToActive();
    }

    @Override
    public void exitExplicitCacheToActive() throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().exitExplicitCacheToActive();
    }

    @Override
    public void exitImplicitCacheToClose() throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().exitImplicitCacheToClose();
    }

    @Override
    public void exitExplicitCacheToClose() throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().exitExplicitCacheToClose();
    }

    @Override
    public void setCharacterStreamAtName(String name, Reader stream, int length) throws SQLException {
        this.awaitExecution();
        this.unwrapPreparedStatement().setCharacterStreamAtName(name, stream, length);
    }

    @Override
    public String getOriginalSql() throws SQLException {
        this.awaitExecution();
        return this.unwrapPreparedStatement().getOriginalSql();
    }

    @Override
    public byte[] privateGetBytes(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().privateGetBytes(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName, int scale) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBigDecimal(parameterName, scale);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getAsciiStream(columnName);
    }

    @Override
    public Reader getCharacterStream(String name) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getCharacterStream(name);
    }

    @Override
    public ARRAY getARRAY(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getARRAY(parameterIndex);
    }

    @Override
    public InputStream getAsciiStream(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getAsciiStream(parameterIndex);
    }

    @Override
    public BFILE getBFILE(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBFILE(parameterIndex);
    }

    @Override
    public BFILE getBfile(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBfile(parameterIndex);
    }

    @Override
    public InputStream getBinaryStream(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBinaryStream(parameterIndex);
    }

    @Override
    public InputStream getBinaryStream(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBinaryStream(parameterName);
    }

    @Override
    public BLOB getBLOB(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBLOB(parameterIndex);
    }

    @Override
    public CHAR getCHAR(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getCHAR(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getCharacterStream(parameterIndex);
    }

    @Override
    public CLOB getCLOB(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getCLOB(parameterIndex);
    }

    @Override
    public ResultSet getCursor(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getCursor(parameterIndex);
    }

    @Override
    public Object getCustomDatum(int parameterIndex, CustomDatumFactory factory) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getCustomDatum(parameterIndex, factory);
    }

    @Override
    public Object getORAData(int parameterIndex, ORADataFactory factory) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getORAData(parameterIndex, factory);
    }

    @Override
    public Object getObject(int parameterIndex, OracleDataFactory factory) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getObject(parameterIndex, factory);
    }

    @Override
    public Object getAnyDataEmbeddedObject(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getAnyDataEmbeddedObject(parameterIndex);
    }

    @Override
    public DATE getDATE(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getDATE(parameterIndex);
    }

    @Override
    public NUMBER getNUMBER(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getNUMBER(parameterIndex);
    }

    @Override
    public OPAQUE getOPAQUE(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getOPAQUE(parameterIndex);
    }

    @Override
    public Datum getOracleObject(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getOracleObject(parameterIndex);
    }

    @Override
    public RAW getRAW(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getRAW(parameterIndex);
    }

    @Override
    public REF getREF(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getREF(parameterIndex);
    }

    @Override
    public ROWID getROWID(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getROWID(parameterIndex);
    }

    @Override
    public STRUCT getSTRUCT(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getSTRUCT(parameterIndex);
    }

    @Override
    public INTERVALYM getINTERVALYM(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getINTERVALYM(parameterIndex);
    }

    @Override
    public INTERVALDS getINTERVALDS(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getINTERVALDS(parameterIndex);
    }

    @Override
    public TIMESTAMP getTIMESTAMP(int paramIdx) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTIMESTAMP(paramIdx);
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int paramIdx) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTIMESTAMPTZ(paramIdx);
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int paramIdx) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTIMESTAMPLTZ(paramIdx);
    }

    @Override
    public InputStream getUnicodeStream(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getUnicodeStream(parameterIndex);
    }

    @Override
    public InputStream getUnicodeStream(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getUnicodeStream(parameterName);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(paramIndex, sqlType, scale, maxLength);
    }

    @Override
    public void registerOutParameterBytes(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameterBytes(paramIndex, sqlType, scale, maxLength);
    }

    @Override
    public void registerOutParameterChars(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameterChars(paramIndex, sqlType, scale, maxLength);
    }

    @Override
    @Deprecated
    public Object getPlsqlIndexTable(int paramIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getPlsqlIndexTable(paramIndex);
    }

    @Override
    @Deprecated
    public Object getPlsqlIndexTable(int paramIndex, Class<?> primitiveType) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getPlsqlIndexTable(paramIndex, primitiveType);
    }

    @Override
    @Deprecated
    public Datum[] getOraclePlsqlIndexTable(int paramIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getOraclePlsqlIndexTable(paramIndex);
    }

    @Override
    @Deprecated
    public void registerIndexTableOutParameter(int paramIndex, int maxLen, int elemSqlType, int elemMaxLen) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerIndexTableOutParameter(paramIndex, maxLen, elemSqlType, elemMaxLen);
    }

    @Override
    public void setBinaryFloat(String parameterName, BINARY_FLOAT x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBinaryFloat(parameterName, x);
    }

    @Override
    public void setBinaryDouble(String parameterName, BINARY_DOUBLE x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBinaryDouble(parameterName, x);
    }

    @Override
    public void setStringForClob(String parameterName, String x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setStringForClob(parameterName, x);
    }

    @Override
    public void setBytesForBlob(String parameterName, byte[] x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBytesForBlob(parameterName, x);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale, int maxLength) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterName, sqlType, scale, maxLength);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNull(parameterName, sqlType, typeName);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNull(parameterName, sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBoolean(parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setByte(parameterName, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setShort(parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setInt(parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setLong(parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setFloat(parameterName, x);
    }

    @Override
    public void setBinaryFloat(String parameterName, float x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBinaryFloat(parameterName, x);
    }

    @Override
    public void setBinaryDouble(String parameterName, double x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBinaryDouble(parameterName, x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setDouble(parameterName, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBigDecimal(parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setString(parameterName, x);
    }

    @Override
    public void setFixedCHAR(String parameterName, String x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setFixedCHAR(parameterName, x);
    }

    @Override
    public void setCursor(String parameterName, ResultSet x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setCursor(parameterName, x);
    }

    @Override
    public void setROWID(String parameterName, ROWID x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setROWID(parameterName, x);
    }

    @Override
    public void setRAW(String parameterName, RAW x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setRAW(parameterName, x);
    }

    @Override
    public void setCHAR(String parameterName, CHAR x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setCHAR(parameterName, x);
    }

    @Override
    public void setDATE(String parameterName, DATE x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setDATE(parameterName, x);
    }

    @Override
    public void setNUMBER(String parameterName, NUMBER x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNUMBER(parameterName, x);
    }

    @Override
    public void setBLOB(String parameterName, BLOB x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBLOB(parameterName, x);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBlob(parameterName, x);
    }

    @Override
    public void setCLOB(String parameterName, CLOB x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setCLOB(parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setClob(parameterName, x);
    }

    @Override
    public void setBFILE(String parameterName, BFILE x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBFILE(parameterName, x);
    }

    @Override
    public void setBfile(String parameterName, BFILE x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBfile(parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBytes(parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setDate(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setTime(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setTimestamp(parameterName, x);
    }

    @Override
    public void setINTERVALYM(String parameterName, INTERVALYM x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setINTERVALYM(parameterName, x);
    }

    @Override
    public void setINTERVALDS(String parameterName, INTERVALDS x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setINTERVALDS(parameterName, x);
    }

    @Override
    public void setTIMESTAMP(String parameterName, TIMESTAMP x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setTIMESTAMP(parameterName, x);
    }

    @Override
    public void setTIMESTAMPTZ(String parameterName, TIMESTAMPTZ x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setTIMESTAMPTZ(parameterName, x);
    }

    @Override
    public void setTIMESTAMPLTZ(String parameterName, TIMESTAMPLTZ x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setTIMESTAMPLTZ(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int y) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setAsciiStream(parameterName, x, y);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int y) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBinaryStream(parameterName, x, y);
    }

    @Override
    public void setUnicodeStream(String parameterName, InputStream x, int y) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setUnicodeStream(parameterName, x, y);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, int y) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setCharacterStream(parameterName, x, y);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setDate(parameterName, x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setTime(parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setTimestamp(parameterName, x, cal);
    }

    @Override
    public void setURL(String parameterName, URL x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setURL(parameterName, x);
    }

    @Override
    public void setArray(String parameterName, Array x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setArray(parameterName, x);
    }

    @Override
    public void setARRAY(String parameterName, ARRAY x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setARRAY(parameterName, x);
    }

    @Override
    public void setOPAQUE(String parameterName, OPAQUE x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setOPAQUE(parameterName, x);
    }

    @Override
    public void setStructDescriptor(String parameterName, StructDescriptor x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setStructDescriptor(parameterName, x);
    }

    @Override
    public void setSTRUCT(String parameterName, STRUCT x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setSTRUCT(parameterName, x);
    }

    @Override
    public void setCustomDatum(String parameterName, CustomDatum x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setCustomDatum(parameterName, x);
    }

    @Override
    public void setORAData(String parameterName, ORAData x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setORAData(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setObject(parameterName, x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int y) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setObject(parameterName, x, y);
    }

    @Override
    public void setRefType(String parameterName, REF x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setRefType(parameterName, x);
    }

    @Override
    public void setRef(String parameterName, Ref x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setRef(parameterName, x);
    }

    @Override
    public void setREF(String parameterName, REF x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setREF(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setObject(parameterName, x);
    }

    @Override
    public void setOracleObject(String parameterName, Datum x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setOracleObject(parameterName, x);
    }

    @Override
    public void registerOutParameterAtName(String parameterMarkerName, int sqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameterAtName(parameterMarkerName, sqlType);
    }

    @Override
    public void registerOutParameterAtName(String parameterMarkerName, int sqlType, int scale) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameterAtName(parameterMarkerName, sqlType, scale);
    }

    @Override
    public void registerOutParameterAtName(String parameterMarkerName, int sqlType, String typeName) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameterAtName(parameterMarkerName, sqlType, typeName);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getDouble(parameterIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBigDecimal(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getObject(parameterIndex, map);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTimestamp(parameterIndex, cal);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getURL(parameterIndex);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getString(parameterName);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBoolean(parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getByte(parameterName);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getShort(parameterName);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getInt(parameterName);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getLong(parameterName);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getFloat(parameterName);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getDouble(parameterName);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBytes(parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getDate(parameterName);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTime(parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTimestamp(parameterName);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getObject(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBigDecimal(parameterName);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getObject(parameterName, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getRef(parameterName);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getBlob(parameterName);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getClob(parameterName);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getArray(parameterName);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getDate(parameterName, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTime(parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getTimestamp(parameterName, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getURL(parameterName);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getRowId(parameterName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setRowId(parameterName, x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNString(parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNClob(parameterName, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setClob(parameterName, reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBlob(parameterName, inputStream, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNClob(parameterName, reader, length);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getNClob(parameterName);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setSQLXML(parameterName, xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getSQLXML(parameterName);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getNString(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getNCharacterStream(parameterName);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setAsciiStream(parameterName, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBinaryStream(parameterName, x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setAsciiStream(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBinaryStream(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setCharacterStream(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNCharacterStream(parameterName, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setClob(parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setBlob(parameterName, inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setNClob(parameterName, reader);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getObject(parameterIndex, type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        this.awaitExecution();
        return this.unwrapCallableStatement().getObject(parameterName, type);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setObject(parameterName, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().setObject(parameterName, x, targetSqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.awaitExecution();
        this.unwrapCallableStatement().registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public long getSSSCursorChecksum() throws SQLException {
        this.awaitExecution();
        return this.statement.getSSSCursorChecksum();
    }

    @Override
    public void setSSSCursorPosition(long pos) throws SQLException {
        this.awaitExecution();
        this.statement.setSSSCursorPosition(pos);
    }

    @Override
    public boolean allRowsFetched() throws SQLException {
        this.awaitExecution();
        return this.statement.allRowsFetched();
    }

    @Override
    public void markSSSCursor() throws SQLException {
        this.awaitExecution();
        this.statement.markSSSCursor();
    }

    @Override
    public void continueOnError(ErrorSet errorSet) throws SQLException {
        this.awaitExecution();
        this.statement.continueOnError(errorSet);
    }

    @Override
    public void setLongPrefetch(boolean isEnabled) {
        this.awaitExecution();
        this.statement.setLongPrefetch(isEnabled);
    }

    @Override
    public void setRowDataLimit(long numBytes) throws SQLException {
        try {
            this.awaitExecution();
        }
        finally {
            this.statement.setRowDataLimit(numBytes);
        }
    }
}

