/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.ExtractDelegatePermission;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.NullProxy;
import oracle.jdbc.proxy.WeakIdentityHashMap;
import oracle.jdbc.proxy._Proxy_;

public class ProxyFactory {
    final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
    private final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
    private final Map<Class, Class> delegateClassToProxyClass = Collections.synchronizedMap(new HashMap());
    private final Map<Object, WeakReference<Object>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
    private final Map<Class, Class> delegateToMostSuitableIface = Collections.synchronizedMap(new HashMap());
    private static final Object STALE_DELEGATE = new Object();
    private static final Class EMPTY_VALUE = EMPTY_CLASS.class;
    private ClassLoader classLoader = null;
    private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();

    private ProxyFactory() {
    }

    public static ProxyFactory createProxyFactory(Class ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(Class ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public final boolean isProxied(Class clazz) {
        return this.annotationsRegistry.containsKey(clazz);
    }

    public final <T> T proxyFor(T t2) {
        return this.proxyFor(t2, this);
    }

    public final <T> T proxyFor(T t2, Object object) {
        return this.proxyForCache(t2, object, null, null);
    }

    public final <T> T proxyForCreate(T t2, Object object, Map<Object, WeakReference<Object>> map, Method method) {
        Class clazz;
        if (null == t2) {
            return null;
        }
        if (t2 instanceof _Proxy_) {
            return t2;
        }
        Class<?> clazz2 = t2.getClass();
        Class clazz3 = this.findMostSuitableIface(clazz2);
        if (null != method && null != clazz3 && !method.getReturnType().isAssignableFrom(clazz3)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz3);
        if (null == value) {
            return t2;
        }
        if (null == map) {
            Map<Object, Object> map2 = map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null == (clazz = this.getProxyClass(clazz3, clazz2))) {
            return this.createProxy(clazz3, t2, object, map);
        }
        try {
            return clazz.getConstructor(clazz3, Object.class, ProxyFactory.class, Map.class).newInstance(t2, object, this, map);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public final <T> T proxyForCache(T t2, Object object, Map<Object, WeakReference<Object>> map, Method method) {
        if (null == t2) {
            return null;
        }
        if (t2 instanceof _Proxy_) {
            return t2;
        }
        Class<?> clazz = t2.getClass();
        Class clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t2;
        }
        Method method2 = value.getProxyAccessGetter();
        Method method3 = value.getProxyAccessSetter();
        if (null == map) {
            map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        try {
            Object t3;
            WeakReference<Object> weakReference;
            if (null != method2) {
                weakReference = method2.invoke(t2, new Object[0]);
                if (null != weakReference) {
                    return (T)weakReference;
                }
            } else {
                weakReference = map.get(t2);
                if (null != weakReference && null != (t3 = weakReference.get())) {
                    if (STALE_DELEGATE == t3) {
                        throw new RuntimeException("stale delegate");
                    }
                    return t3;
                }
            }
            if (null == (weakReference = this.getProxyClass(clazz2, clazz))) {
                t3 = this.createProxy(clazz2, t2, object, map);
                if (null != method3) {
                    method3.invoke(t2, t3);
                } else {
                    map.put(t2, new WeakReference(t3));
                }
                return t3;
            }
            t3 = ((Class)((Object)weakReference)).getConstructor(clazz2, Object.class, ProxyFactory.class, Map.class).newInstance(t2, object, this, map);
            if (null != method3) {
                method3.invoke(t2, t3);
            } else {
                map.put(t2, new WeakReference(t3));
            }
            return t3;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public final <T> T proxyForCreateCache(T t2, Object object, Map<Object, WeakReference<Object>> map, Method method) {
        if (null == t2) {
            return null;
        }
        if (t2 instanceof _Proxy_) {
            return t2;
        }
        Class<?> clazz = t2.getClass();
        Class clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t2;
        }
        if (null == map) {
            map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        Method method2 = value.getProxyAccessSetter();
        Class clazz3 = this.getProxyClass(clazz2, clazz);
        try {
            if (null == clazz3) {
                T t3 = this.createProxy(clazz2, t2, object, map);
                if (null != method2) {
                    method2.invoke(t2, t3);
                } else {
                    map.put(t2, new WeakReference<T>(t3));
                }
                return t3;
            }
            Object t4 = clazz3.getConstructor(clazz2, Object.class, ProxyFactory.class, Map.class).newInstance(t2, object, this, map);
            if (null != method2) {
                method2.invoke(t2, t4);
            } else {
                map.put(t2, new WeakReference(t4));
            }
            return t4;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public <T> void updateDelegate(Object object, T t2, T t3) {
        this.delegateToProxy.put(t2, new WeakReference<Object>(STALE_DELEGATE));
        this.delegateToProxy.put(t3, new WeakReference<Object>(object));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static final Object extractDelegate(_Proxy_ _Proxy_2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(EXTRACT_DELEGATE_PERMISSION);
        }
        return _Proxy_2._getDelegate_();
    }

    private <T> T createProxy(Class clazz, T t2, Object object, Map<Object, WeakReference<Object>> map) {
        if (null == clazz) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz);
        Class clazz2 = value.getSuperclass();
        GeneratedProxiesRegistry.Value value2 = this.generatedRegistry.get(clazz, clazz2);
        Constructor constructor = null == value2 ? this.prepareProxy(clazz, clazz2) : value2.getConstructor();
        try {
            return constructor.newInstance(t2, object, this, map);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    private Constructor prepareProxy(Class clazz, Class clazz2) {
        Constructor<?> constructor;
        Class<?> clazz3 = null;
        try {
            clazz3 = Class.forName(new GeneratedProxiesRegistry.Key(clazz, clazz2).toString(), true, null == this.classLoader ? clazz2.getClassLoader() : this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz3 = ClassGenerator.generate(clazz, clazz2, this.annotationsRegistry, this.classLoader);
        }
        try {
            constructor = clazz3.getConstructor(clazz, Object.class, ProxyFactory.class, Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        this.generatedRegistry.put(clazz, clazz2, new GeneratedProxiesRegistry.Value(null, null, clazz3, constructor));
        return constructor;
    }

    private Class getProxyClass(Class clazz, Class clazz2) {
        if (null == clazz2) {
            return null;
        }
        Object object = this.delegateClassToProxyClass.get(clazz2);
        if (null != object) {
            return EMPTY_VALUE != object ? object : null;
        }
        if (null == clazz) {
            return null;
        }
        object = this.generatedRegistry.get(clazz, this.annotationsRegistry.get(clazz).getSuperclass());
        if (null == object) {
            return null;
        }
        Class clazz3 = ((GeneratedProxiesRegistry.Value)object).getClazz();
        this.delegateClassToProxyClass.put(clazz2, null != clazz3 ? clazz3 : EMPTY_VALUE);
        return clazz3;
    }

    private Class findMostSuitableIface(Class clazz) {
        if (null == clazz) {
            return null;
        }
        Class clazz2 = this.delegateToMostSuitableIface.get(clazz);
        if (null != clazz2) {
            return EMPTY_VALUE != clazz2 ? clazz2 : null;
        }
        int n2 = -1;
        Class clazz3 = null;
        for (Class clazz4 : this.annotationsRegistry.keySet()) {
            int n3 = this.intersectionCardinality(clazz, clazz4);
            if (n3 < 1 || n3 <= n2) continue;
            n2 = n3;
            clazz3 = clazz4;
        }
        this.delegateToMostSuitableIface.put(clazz, null != clazz3 ? clazz3 : EMPTY_VALUE);
        return clazz3;
    }

    private int intersectionCardinality(Class clazz, Class clazz2) {
        HashSet<Class> hashSet = new HashSet<Class>();
        this.collectIfaces(clazz2, hashSet);
        HashSet<Class> hashSet2 = new HashSet<Class>();
        this.collectIfaces(clazz, hashSet2);
        int n2 = hashSet.size();
        hashSet.removeAll(hashSet2);
        if (hashSet.size() > 0) {
            return -1;
        }
        return n2;
    }

    private void collectIfaces(Class clazz, Set<Class> set) {
        if (clazz.isInterface()) {
            set.add(clazz);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.collectIfaces(clazz2, set);
        }
        Class clazz3 = clazz.getSuperclass();
        if (null != clazz3) {
            this.collectIfaces(clazz3, set);
        }
    }

    private static final class EMPTY_CLASS {
        private EMPTY_CLASS() {
        }
    }
}

