/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class BINARY_FLOAT
extends Datum {
    static final long serialVersionUID = -4231112037190700631L;

    public BINARY_FLOAT() {
    }

    public BINARY_FLOAT(byte[] byArray) {
        super(byArray);
    }

    public BINARY_FLOAT(float f2) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f2));
    }

    public BINARY_FLOAT(Float f2) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f2.floatValue()));
    }

    public BINARY_FLOAT(String string) throws SQLException {
        this(BINARY_FLOAT.stringToFloat(string));
    }

    public BINARY_FLOAT(Boolean bl) {
        this(bl != false ? 1 : 0);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return new Float(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Float") == 0;
    }

    @Override
    public String stringValue() {
        String string = Float.toString(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
        return string;
    }

    @Override
    public float floatValue() throws SQLException {
        return BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes());
    }

    @Override
    public double doubleValue() throws SQLException {
        return this.floatValue();
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return new BigDecimal(this.floatValue());
    }

    private static float stringToFloat(String string) throws SQLException {
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new Float[n2];
    }

    static byte[] floatToCanonicalFormatBytes(float f2) {
        float f3 = f2;
        if (f3 == 0.0f) {
            f3 = 0.0f;
        } else if (f3 != f3) {
            f3 = Float.NaN;
        }
        int n2 = Float.floatToIntBits(f3);
        byte[] byArray = new byte[4];
        int n3 = n2;
        int n4 = n2 >>= 8;
        int n5 = n2 >>= 8;
        int n6 = n2 >>= 8;
        if ((n6 & 0x80) == 0) {
            n6 |= 0x80;
        } else {
            n6 ^= 0xFFFFFFFF;
            n5 ^= 0xFFFFFFFF;
            n4 ^= 0xFFFFFFFF;
            n3 ^= 0xFFFFFFFF;
        }
        byArray[3] = (byte)n3;
        byArray[2] = (byte)n4;
        byArray[1] = (byte)n5;
        byArray[0] = (byte)n6;
        return byArray;
    }

    static float canonicalFormatBytesToFloat(byte[] byArray) {
        int n2 = byArray[0];
        int n3 = byArray[1];
        int n4 = byArray[2];
        int n5 = byArray[3];
        if ((n2 & 0x80) != 0) {
            n2 &= 0x7F;
            n3 &= 0xFF;
            n4 &= 0xFF;
            n5 &= 0xFF;
        } else {
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
        }
        int n6 = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        return Float.intBitsToFloat(n6);
    }
}

