/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.rowset.OracleCachedRowSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleCachedRowSetReader
implements RowSetReader,
Serializable {
    static final long serialVersionUID = -3565405169674271176L;
    static final transient int SETUNICODESTREAM_INTLENGTH = 1;
    static final transient int SETBINARYSTREAM_INTLENGTH = 2;
    static final transient int SETASCIISTREAM_INTLENGTH = 3;
    static final transient int SETCHARACTERSTREAM_INTLENGTH = 4;
    static final transient int SETBINARYSTREAM = 5;
    static final transient int SETBINARYSTREAM_LONGLENGTH = 6;
    static final transient int SETASCIISTREAM = 7;
    static final transient int SETASCIISTREAM_LONGLENGTH = 8;
    static final transient int SETCHARACTERSTREAM = 9;
    static final transient int SETCHARACTERSTREAM_LONGLENGTH = 10;
    static final transient int SETNCHARACTERSTREAM = 11;
    static final transient int SETNCHARACTERSTREAM_LONGLENGTH = 12;
    static final transient int SETBLOB_STREAM = 13;
    static final transient int SETBLOB_STREAM_LONG = 14;
    static final transient int SETCLOB_READER = 15;
    static final transient int SETCLOB_READER_LONG = 16;
    static final transient int SETNCLOB_READER = 17;
    static final transient int SETNCLOB_READER_LONG = 18;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    Connection getConnection(RowSetInternal rowSetInternal) throws SQLException {
        Connection connection = null;
        Connection connection2 = rowSetInternal.getConnection();
        if (connection2 != null && !connection2.isClosed()) {
            connection = connection2;
        } else if (((RowSet)((Object)rowSetInternal)).getDataSourceName() != null) {
            try {
                Object object;
                InitialContext initialContext = null;
                try {
                    object = System.getProperties();
                    initialContext = new InitialContext((Hashtable<?, ?>)object);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (initialContext == null) {
                    initialContext = new InitialContext();
                }
                object = (DataSource)initialContext.lookup(((RowSet)((Object)rowSetInternal)).getDataSourceName());
                String string = ((RowSet)((Object)rowSetInternal)).getUsername();
                String string2 = ((RowSet)((Object)rowSetInternal)).getPassword();
                if (string == null && string2 == null) {
                    connection = object.getConnection();
                }
                connection = object.getConnection(string, string2);
            }
            catch (NamingException namingException) {
                throw (SQLException)DatabaseError.createSqlException(null, 300, namingException.getMessage()).fillInStackTrace();
            }
        } else if (((RowSet)((Object)rowSetInternal)).getUrl() != null) {
            if (!driverManagerInitialized) {
                DriverManager.registerDriver(new OracleDriver());
                driverManagerInitialized = true;
            }
            String string = ((RowSet)((Object)rowSetInternal)).getUrl();
            String string3 = ((RowSet)((Object)rowSetInternal)).getUsername();
            String string4 = ((RowSet)((Object)rowSetInternal)).getPassword();
            if (string.equals("") || string3.equals("") || string4.equals("")) {
                throw (SQLException)DatabaseError.createSqlException(301).fillInStackTrace();
            }
            connection = DriverManager.getConnection(string, string3, string4);
        }
        return connection;
    }

    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        block28: for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n2 = 0;
            if (objectArray[i2] instanceof byte[]) {
                preparedStatement.setObject(i2 + 1, objectArray[i2]);
                continue;
            }
            try {
                n2 = Array.getLength(objectArray[i2]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                preparedStatement.setObject(i2 + 1, objectArray[i2]);
                continue;
            }
            Object[] objectArray2 = (Object[])objectArray[i2];
            if (n2 == 2) {
                if (objectArray2[0] == null) {
                    preparedStatement.setNull(i2 + 1, (Integer)objectArray2[1]);
                    continue;
                }
                if (objectArray2[0] instanceof Date) {
                    if (objectArray2[1] instanceof Calendar) {
                        preparedStatement.setDate(i2 + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                        continue;
                    }
                    throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                }
                if (objectArray2[0] instanceof Time) {
                    if (objectArray2[1] instanceof Calendar) {
                        preparedStatement.setTime(i2 + 1, (Time)objectArray2[0], (Calendar)objectArray2[1]);
                        continue;
                    }
                    throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                }
                if (objectArray2[0] instanceof Timestamp) {
                    if (objectArray2[1] instanceof Calendar) {
                        preparedStatement.setTimestamp(i2 + 1, (Timestamp)objectArray2[0], (Calendar)objectArray2[1]);
                        continue;
                    }
                    throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                }
                if (objectArray2[0] instanceof Reader) {
                    switch ((Integer)objectArray2[1]) {
                        case 9: {
                            preparedStatement.setCharacterStream(i2 + 1, (Reader)objectArray2[0]);
                            continue block28;
                        }
                        case 11: {
                            preparedStatement.setNCharacterStream(i2 + 1, (Reader)objectArray2[0]);
                            continue block28;
                        }
                        case 15: {
                            preparedStatement.setClob(i2 + 1, (Reader)objectArray2[0]);
                            continue block28;
                        }
                        case 17: {
                            preparedStatement.setNClob(i2 + 1, (Reader)objectArray2[0]);
                            continue block28;
                        }
                        default: {
                            throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                        }
                    }
                }
                if (objectArray2[0] instanceof InputStream) {
                    switch ((Integer)objectArray2[1]) {
                        case 7: {
                            preparedStatement.setAsciiStream(i2 + 1, (InputStream)objectArray2[0]);
                            continue block28;
                        }
                        case 5: {
                            preparedStatement.setBinaryStream(i2 + 1, (InputStream)objectArray2[0]);
                            continue block28;
                        }
                        case 13: {
                            preparedStatement.setBlob(i2 + 1, (InputStream)objectArray2[0]);
                            continue block28;
                        }
                        default: {
                            throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                        }
                    }
                }
                if (!(objectArray2[1] instanceof Integer)) continue;
                preparedStatement.setObject(i2 + 1, objectArray2[0], (Integer)objectArray2[1]);
                continue;
            }
            if (n2 != 3) continue;
            if (objectArray2[0] == null) {
                preparedStatement.setNull(i2 + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                continue;
            }
            if (objectArray2[0] instanceof Reader) {
                switch ((Integer)objectArray2[2]) {
                    case 4: {
                        preparedStatement.setCharacterStream(i2 + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                        continue block28;
                    }
                    case 10: {
                        preparedStatement.setCharacterStream(i2 + 1, (Reader)objectArray2[0], (Long)objectArray2[1]);
                        continue block28;
                    }
                    case 12: {
                        preparedStatement.setNCharacterStream(i2 + 1, (Reader)objectArray2[0], (Long)objectArray2[1]);
                        continue block28;
                    }
                    case 16: {
                        preparedStatement.setClob(i2 + 1, (Reader)objectArray2[0], (Long)objectArray2[1]);
                        continue block28;
                    }
                    case 18: {
                        preparedStatement.setNClob(i2 + 1, (Reader)objectArray2[0], (Long)objectArray2[1]);
                        continue block28;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                    }
                }
            }
            if (objectArray2[0] instanceof InputStream) {
                switch ((Integer)objectArray2[2]) {
                    case 1: {
                        preparedStatement.setUnicodeStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        continue block28;
                    }
                    case 2: {
                        preparedStatement.setBinaryStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        continue block28;
                    }
                    case 3: {
                        preparedStatement.setAsciiStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        continue block28;
                    }
                    case 6: {
                        preparedStatement.setBinaryStream(i2 + 1, (InputStream)objectArray2[0], (Long)objectArray2[1]);
                        continue block28;
                    }
                    case 8: {
                        preparedStatement.setAsciiStream(i2 + 1, (InputStream)objectArray2[0], (Long)objectArray2[1]);
                        continue block28;
                    }
                    case 14: {
                        preparedStatement.setBlob(i2 + 1, (InputStream)objectArray2[0], (Long)objectArray2[1]);
                        continue block28;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                    }
                }
            }
            if (objectArray2[1] instanceof Integer && objectArray2[2] instanceof Integer) {
                preparedStatement.setObject(i2 + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                continue;
            }
            throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
        }
    }

    @Override
    public synchronized void readData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        Connection connection = this.getConnection(rowSetInternal);
        if (connection == null || oracleCachedRowSet.getCommand() == null) {
            throw (SQLException)DatabaseError.createSqlException(342).fillInStackTrace();
        }
        try {
            connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        }
        catch (Exception exception) {
        }
        PreparedStatement preparedStatement = connection.prepareStatement(oracleCachedRowSet.getCommand(), oracleCachedRowSet.getType(), oracleCachedRowSet.getConcurrency());
        this.setParams(rowSetInternal.getParams(), preparedStatement);
        try {
            preparedStatement.setMaxRows(oracleCachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(oracleCachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(oracleCachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(oracleCachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        oracleCachedRowSet.populate(resultSet, oracleCachedRowSet.getCurrentPage() * oracleCachedRowSet.getPageSize());
        resultSet.close();
        preparedStatement.close();
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!oracleCachedRowSet.isConnectionStayingOpen()) {
            connection.close();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$4 = OracleCachedRowSetReader.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleCachedRowSetReader.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleCachedRowSetReader.class.getDeclaredMethod("readData", RowSetInternal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleCachedRowSetReader.class.getDeclaredMethod("setParams", Object[].class, PreparedStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleCachedRowSetReader.class.getDeclaredMethod("getConnection", RowSetInternal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        driverManagerInitialized = false;
    }
}

