/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAException
extends XAException {
    static final long serialVersionUID = -1286190807520675784L;
    private int xaError = 0;
    private int primary = 0;
    private int secondary = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    public OracleXAException() {
    }

    public OracleXAException(int n2) {
        super(OracleXAException.errorConvert(n2));
        this.xaError = OracleXAException.errorConvert(n2);
        this.primary = n2 & 0xFFFF;
        this.secondary = n2 >> 16;
    }

    public OracleXAException(int n2, int n3) {
        super(OracleXAException.errorConvert(n2, n3));
        this.xaError = OracleXAException.errorConvert(n2, n3);
        this.primary = n2 & 0xFFFF;
        this.secondary = n2 >> 16;
    }

    public OracleXAException(SQLException sQLException, int n2) {
        this(sQLException.getErrorCode(), n2);
        this.initCause(sQLException);
    }

    public static XAException newXAException(OracleConnection oracleConnection, int n2) {
        OracleXAException oracleXAException = new OracleXAException(n2);
        int n3 = oracleXAException.getXAError();
        if (n3 == -7 && oracleConnection != null) {
            oracleConnection.setUsable(false);
        }
        return oracleXAException;
    }

    public static XAException newXAException(OracleConnection oracleConnection, int n2, SQLException sQLException) {
        OracleXAException oracleXAException = (OracleXAException)OracleXAException.newXAException(oracleConnection, n2);
        oracleXAException.initCause(sQLException);
        return oracleXAException;
    }

    public static XAException newXAException(OracleConnection oracleConnection, int n2, int n3) {
        OracleXAException oracleXAException = new OracleXAException(n2, n3);
        int n4 = oracleXAException.getXAError();
        if (n4 == -7 && oracleConnection != null) {
            oracleConnection.setUsable(false);
        }
        return oracleXAException;
    }

    public static XAException newXAException(OracleConnection oracleConnection, SQLException sQLException, int n2) {
        OracleXAException oracleXAException = new OracleXAException(sQLException, n2);
        int n3 = oracleXAException.getXAError();
        if (n3 == -7 && oracleConnection != null) {
            oracleConnection.setUsable(false);
        }
        return oracleXAException;
    }

    public static int errorConvert(int n2) {
        return OracleXAException.errorConvert(n2, -3);
    }

    public static int errorConvert(int n2, int n3) {
        switch (n2 & 0xFFFF) {
            case 24756: {
                return -4;
            }
            case 25351: 
            case 30006: {
                return 4;
            }
            case 24764: {
                return 7;
            }
            case 24765: {
                return 6;
            }
            case 24766: {
                return 5;
            }
            case 24767: {
                return 3;
            }
            case 28: 
            case 1031: 
            case 1033: 
            case 1034: 
            case 1041: 
            case 1089: 
            case 1090: 
            case 1092: 
            case 3113: 
            case 3114: 
            case 12571: 
            case 17002: 
            case 17008: 
            case 17410: 
            case 24796: 
            case 25400: 
            case 25401: 
            case 25402: 
            case 25403: 
            case 25404: 
            case 25405: 
            case 25406: 
            case 25407: 
            case 25408: 
            case 25409: {
                return -7;
            }
            case 2056: 
            case 17448: 
            case 24763: 
            case 24768: 
            case 24769: 
            case 24770: 
            case 24775: 
            case 24776: {
                return -6;
            }
            case 2091: 
            case 2092: 
            case 24761: {
                return 100;
            }
            case 24780: {
                return -3;
            }
        }
        return n3;
    }

    public int getXAError() {
        return this.xaError;
    }

    public int getOracleError() {
        return this.primary;
    }

    public int getOracleSQLError() {
        return this.secondary;
    }

    @Override
    public String getMessage() {
        return String.format("XAErr (%d): %s ORA-%d SQLErr (%d)", this.xaError, OracleXAException.getXAErrorMessage(this.xaError), this.primary, this.secondary);
    }

    public static String getXAErrorMessage(int n2) {
        switch (n2) {
            case 7: {
                return "The transaction branch has been heuristically committed.";
            }
            case 8: {
                return "The transaction branch may have been heuristically completed.";
            }
            case 5: {
                return "The transaction branch has been heuristically committed and rolled back.";
            }
            case 6: {
                return "The transaction branch has been heuristically rolled back.";
            }
            case 9: {
                return "Resumption must occur where suspension occured.";
            }
            case 100: {
                return "The inclusive lower bound oof the rollback codes.";
            }
            case 101: {
                return "Rollback was caused by communication failure.";
            }
            case 102: {
                return "A deadlock was detected.";
            }
            case 107: {
                return "The inclusive upper bound of the rollback error code.";
            }
            case 103: {
                return "A condition that violates the integrity of the resource was detected.";
            }
            case 104: {
                return "The resource manager rolled back the transaction branch for a reason not on this list.";
            }
            case 105: {
                return "A protocol error occured in the resource manager.";
            }
            case 106: {
                return "A transaction branch took too long.";
            }
            case 3: {
                return "The transaction branch has been read-only and has been committed.";
            }
            case 4: {
                return "Routine returned with no effect and may be reissued.";
            }
            case -2: {
                return "Asynchronous operation already outstanding.";
            }
            case -8: {
                return "The XID already exists.";
            }
            case -5: {
                return "Invalid arguments were given.";
            }
            case -4: {
                return "The XID is not valid.";
            }
            case -9: {
                return "The resource manager is doing work outside global transaction.";
            }
            case -6: {
                return "Routine was invoked in an inproper context.";
            }
            case -3: {
                return "A resource manager error has occured in the transaction branch.";
            }
            case -7: {
                return "Resource manager is unavailable.";
            }
        }
        return "Internal XA Error";
    }

    static {
        try {
            $$$methodRef$$$14 = OracleXAException.class.getDeclaredConstructor(SQLException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleXAException.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleXAException.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXAException.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXAException.class.getDeclaredMethod("getXAErrorMessage", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXAException.class.getDeclaredMethod("getMessage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXAException.class.getDeclaredMethod("getOracleSQLError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXAException.class.getDeclaredMethod("getOracleError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXAException.class.getDeclaredMethod("getXAError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXAException.class.getDeclaredMethod("errorConvert", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXAException.class.getDeclaredMethod("errorConvert", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXAException.class.getDeclaredMethod("newXAException", OracleConnection.class, SQLException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXAException.class.getDeclaredMethod("newXAException", OracleConnection.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAException.class.getDeclaredMethod("newXAException", OracleConnection.class, Integer.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAException.class.getDeclaredMethod("newXAException", OracleConnection.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

