/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit = false;
    protected boolean savedXAConnectionAutoCommit = false;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMPROMOTE = 8;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection = null;
    protected OracleXAConnection xaconnection = null;
    protected int timeout = 60;
    protected String dblink = null;
    private Connection logicalConnection = null;
    private String synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
    private String synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
    private String recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected boolean canBeMigratablySuspended = false;
    private boolean isTMRScanStarted = false;
    private static final Xid[] NO_XID;
    Xid lastActiveXid = null;
    protected Xid activeXid = null;
    protected Hashtable<Xid, XidListEntry> xidHash = new Hashtable(50);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.connection = connection;
        this.xaconnection = oracleXAConnection;
        if (this.connection == null) {
            throw (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
        }
    }

    public synchronized void setConnection(Connection connection) throws XAException {
        this.connection = connection;
        if (this.connection == null) {
            throw (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
        }
    }

    final synchronized XidListEntry getMatchingXidListEntry(Xid xid) {
        XidListEntry xidListEntry = this.xidHash.get(xid);
        return xidListEntry;
    }

    @DefaultLevel(value=Logging.FINEST)
    protected final synchronized boolean removeXidFromList(Xid xid) {
        if (this.isSameXid(this.activeXid, xid)) {
            this.activeXid = null;
        }
        return this.xidHash.remove(xid) != null;
    }

    final boolean isSameXid(Xid xid, Xid xid2) {
        if (xid == null) {
            return xid == xid2;
        }
        return xid.equals(xid2);
    }

    @DefaultLevel(value=Logging.FINEST)
    protected final boolean isOnStack(Xid xid) throws XAException {
        return this.xidHash.containsKey(xid);
    }

    @DefaultLevel(value=Logging.FINEST)
    protected final synchronized boolean isXidListEmpty() {
        return this.xidHash.isEmpty();
    }

    protected synchronized void createOrUpdateXid(Xid xid, boolean bl, boolean[] blArray) {
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            blArray[0] = true;
            xidListEntry.isSuspended = bl;
        } else {
            xidListEntry = new XidListEntry(xid, bl);
            this.xidHash.put(xid, xidListEntry);
        }
        if (bl) {
            this.lastActiveXid = this.activeXid;
            this.activeXid = null;
        } else {
            this.enterGlobalTxnMode();
            if (this.lastActiveXid != null && this.isSameXid(xid, this.lastActiveXid)) {
                this.lastActiveXid = null;
            }
            this.activeXid = xidListEntry.xid;
        }
    }

    protected synchronized boolean updateXidList(Xid xid, boolean[] blArray) {
        boolean bl = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl = true;
            blArray[0] = true;
            blArray[1] = xidListEntry.isSuspended;
            if (xidListEntry.isSuspended) {
                this.enterGlobalTxnMode();
            } else {
                this.exitGlobalTxnMode();
            }
        }
        return bl;
    }

    protected boolean isXidSuspended(Xid xid) throws XAException {
        boolean bl = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl = xidListEntry.isSuspended;
        }
        return bl;
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid xid2 = null;
        if (this.activeXid != null && !this.isSameXid(this.activeXid, xid)) {
            xid2 = this.activeXid;
            if (!this.isXidSuspended(this.activeXid)) {
                this.end(this.activeXid, 0x2000000);
                this.lastActiveXid = this.activeXid;
                this.activeXid = null;
            }
        }
        return xid2;
    }

    protected void resumeStacked(Xid xid) throws XAException {
        if (xid != null) {
            this.start(xid, 0x8000000);
            this.activeXid = xid;
        }
    }

    @Override
    public abstract void start(Xid var1, int var2) throws XAException;

    @Override
    public abstract void end(Xid var1, int var2) throws XAException;

    @Override
    public abstract void commit(Xid var1, boolean var2) throws XAException;

    @Override
    public abstract int prepare(Xid var1) throws XAException;

    @Override
    public abstract void forget(Xid var1) throws XAException;

    @Override
    public abstract void rollback(Xid var1) throws XAException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int n2) throws XAException {
        Connection connection;
        try {
            if (this.connection instanceof ReplayableConnection) {
                ((ReplayableConnection)((Object)this.connection)).disableReplay();
                connection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
            } else {
                connection = this.connection;
            }
        }
        catch (SQLException sQLException) {
            connection = this.connection;
            this.checkError(sQLException, -3);
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            if ((n2 & 0x1800000) != n2) {
                throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            }
            if (n2 == 0x1000000) {
                this.isTMRScanStarted = true;
            } else {
                if (this.isTMRScanStarted && n2 == 0x800000) {
                    this.isTMRScanStarted = false;
                    return NO_XID;
                }
                if (this.isTMRScanStarted && n2 == 0) {
                    return NO_XID;
                }
            }
            Statement statement = null;
            ResultSet resultSet = null;
            ArrayList<OracleXid> arrayList = new ArrayList<OracleXid>(50);
            try {
                statement = connection.createStatement();
                try {
                    statement.execute(this.synchronizeBeforeRecoverNewCall);
                }
                catch (Exception exception) {
                    statement.execute(this.synchronizeBeforeRecoverOldCall);
                }
                resultSet = statement.executeQuery(this.recoverySqlRows);
                while (resultSet.next()) {
                    arrayList.add(new OracleXid(resultSet.getInt(1), resultSet.getBytes(2), resultSet.getBytes(3)));
                }
            }
            catch (SQLException sQLException) {
                throw (XAException)DatabaseError.createXAException(-3).fillInStackTrace();
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
            }
            int n3 = arrayList.size();
            Xid[] xidArray = new Xid[n3];
            System.arraycopy(arrayList.toArray(), 0, xidArray, 0, n3);
            return xidArray;
        }
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
            }
            catch (SQLException sQLException) {
            }
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.savedConnectionAutoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
                this.xaconnection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
            }
        }
    }

    public void resume(Xid xid) throws XAException {
        this.start(xid, 0x8000000);
    }

    public void join(Xid xid) throws XAException {
        this.start(xid, 0x200000);
    }

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000000);
    }

    public void join(Xid xid, int n2) throws XAException {
        this.timeout = n2;
        this.start(xid, 0x200000);
    }

    public void resume(Xid xid, int n2) throws XAException {
        this.timeout = n2;
        this.start(xid, 0x8000000);
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        Connection connection = null;
        if (!(xAResource instanceof OracleXAResource)) {
            return false;
        }
        connection = ((OracleXAResource)xAResource).getConnection();
        try {
            if (this.connection == null || ((OracleConnection)this.connection).isClosed()) {
                return false;
            }
            String string = ((OracleConnection)this.connection).getURL();
            String string2 = ((OracleConnection)this.connection).getProtocolType();
            if (connection != null) {
                boolean bl = connection.equals(this.connection) || ((OracleConnection)connection).getURL().equals(string) || ((OracleConnection)connection).getProtocolType().equals(string2) && string2.equals("kprb");
                return bl;
            }
        }
        catch (SQLException sQLException) {
            throw (XAException)DatabaseError.createXAException(-3).fillInStackTrace();
        }
        return false;
    }

    @Override
    public boolean setTransactionTimeout(int n2) throws XAException {
        if (n2 < 0) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        this.timeout = n2;
        return true;
    }

    public String getDBLink() {
        return this.dblink;
    }

    public void setDBLink(String string) {
        this.dblink = string;
    }

    public void setLogicalConnection(Connection connection) {
        this.logicalConnection = connection;
    }

    protected void allowGlobalTxnModeOnly(int n2) throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            throw (XAException)DatabaseError.createXAException(n2).fillInStackTrace();
        }
    }

    protected void exitGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(0);
    }

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(1);
    }

    protected void checkError(int n2) throws XAException {
        if ((n2 & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2).fillInStackTrace();
        }
    }

    protected void checkError(int n2, SQLException sQLException) throws XAException {
        if ((n2 & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2, sQLException).fillInStackTrace();
        }
    }

    protected void checkError(int n2, int n3) throws XAException {
        if ((n2 & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2, n3).fillInStackTrace();
        }
    }

    protected void checkError(SQLException sQLException, int n2) throws XAException {
        throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), sQLException, n2).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.connection;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$35 = OracleXAResource.class.getDeclaredConstructor(Connection.class, OracleXAConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleXAResource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleXAResource.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleXAResource.class.getDeclaredMethod("checkError", SQLException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleXAResource.class.getDeclaredMethod("checkError", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleXAResource.class.getDeclaredMethod("checkError", Integer.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleXAResource.class.getDeclaredMethod("checkError", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleXAResource.class.getDeclaredMethod("enterGlobalTxnMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleXAResource.class.getDeclaredMethod("exitGlobalTxnMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleXAResource.class.getDeclaredMethod("allowGlobalTxnModeOnly", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleXAResource.class.getDeclaredMethod("setLogicalConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleXAResource.class.getDeclaredMethod("setDBLink", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleXAResource.class.getDeclaredMethod("getDBLink", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleXAResource.class.getDeclaredMethod("setTransactionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleXAResource.class.getDeclaredMethod("isSameRM", XAResource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleXAResource.class.getDeclaredMethod("getTransactionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleXAResource.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleXAResource.class.getDeclaredMethod("resume", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleXAResource.class.getDeclaredMethod("join", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleXAResource.class.getDeclaredMethod("suspend", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleXAResource.class.getDeclaredMethod("join", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleXAResource.class.getDeclaredMethod("resume", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleXAResource.class.getDeclaredMethod("saveAndAlterAutoCommitModeForGlobalTransaction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleXAResource.class.getDeclaredMethod("restoreAutoCommitModeForGlobalTransaction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXAResource.class.getDeclaredMethod("recover", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXAResource.class.getDeclaredMethod("resumeStacked", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXAResource.class.getDeclaredMethod("suspendStacked", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXAResource.class.getDeclaredMethod("isXidSuspended", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXAResource.class.getDeclaredMethod("updateXidList", Xid.class, boolean[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXAResource.class.getDeclaredMethod("createOrUpdateXid", Xid.class, Boolean.TYPE, boolean[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXAResource.class.getDeclaredMethod("isXidListEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXAResource.class.getDeclaredMethod("isOnStack", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXAResource.class.getDeclaredMethod("isSameXid", Xid.class, Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXAResource.class.getDeclaredMethod("removeXidFromList", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAResource.class.getDeclaredMethod("getMatchingXidListEntry", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAResource.class.getDeclaredMethod("setConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_XID = new Xid[0];
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        XidListEntry(Xid xid, boolean bl) {
            this.xid = xid;
            this.isSuspended = bl;
        }

        static {
            try {
                $$$methodRef$$$0 = XidListEntry.class.getDeclaredConstructor(OracleXAResource.class, Xid.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

