/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NIOResendPacket;
import oracle.net.ns.NSProtocolNIO;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
abstract class NIOPacket {
    final NIOHeader header;
    public SessionAtts session;
    static final String[] toHex;
    static final char[] toChar;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    NIOPacket(SessionAtts sessionAtts) {
        this.session = sessionAtts;
        this.header = new NIOHeader(sessionAtts);
    }

    NIOPacket(NIOHeader nIOHeader, SessionAtts sessionAtts) throws IOException {
        this.header = nIOHeader;
        this.session = sessionAtts;
    }

    abstract void readPayloadBuffer() throws IOException;

    final void readFromSocketChannel(boolean bl) throws IOException {
        this.readFromSocketChannel(bl, true);
    }

    final void readFromSocketChannel(boolean bl, boolean bl2) throws IOException {
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            this.readPacketFromMSGQ();
        } else {
            this.readPacketFromSocketChannel(bl);
        }
        if (this.header.type == 14) {
            this.session.controlPacket.readPayloadBuffer();
            this.readFromSocketChannel(bl, bl2);
        }
        if (bl2 && this.header.type == 12) {
            this.session.markerPacket.readPayloadBuffer();
            this.processMarker();
            this.session.onBreakReset = this.session.markerPacket.isBreakPkt();
            throw new BreakNetException(500);
        }
    }

    private void readPacketFromMSGQ() throws IOException {
        ByteOrder byteOrder = this.session.readBuffer.order();
        ByteBuffer byteBuffer = ((MQLNTAdapter)this.session.nt).readFromLocalQueue();
        int n2 = byteBuffer.limit();
        byteBuffer.order(byteOrder);
        this.session.setReadBuffer(byteBuffer);
        this.session.payloadDataBufferForRead.position(this.session.payloadDataBufferForRead.limit());
        if (n2 >= 8) {
            this.session.headerBufferForRead.position(0);
            this.session.headerBufferForRead.limit(8);
            this.header.readNSHeader();
        }
        this.session.payloadBufferForRead.clear();
        this.session.payloadBufferForRead.limit(this.header.length - 8);
    }

    private void readPacketFromSocketChannel(boolean bl) throws IOException {
        int n2 = bl ? this.readHeader() : this.session.readBuffer.position() - 8;
        int n3 = this.header.length - 8;
        if (n3 <= 0) {
            return;
        }
        if (this.session.readBuffer.remaining() < n3) {
            n2 = this.readPayload(n2, n3);
        }
        this.session.readBuffer.position(n2 + 8);
        this.session.payloadBufferForRead = this.session.readBuffer.slice();
        this.session.payloadBufferForRead.limit(this.header.length - 8);
        this.session.readBuffer.position(n2 + this.header.length);
    }

    private int readHeader() throws IOException {
        int n2;
        if (this.session.readBuffer.hasRemaining() && this.session.readBuffer.position() > 0) {
            if (this.session.readBuffer.remaining() < 8) {
                this.session.readBuffer.compact();
                n2 = 0;
                ((NSProtocolNIO)this.session.ns).doSocketRead(8);
            } else {
                n2 = this.session.readBuffer.position();
            }
        } else {
            this.session.readBuffer.clear();
            n2 = 0;
            ((NSProtocolNIO)this.session.ns).doSocketRead(8);
        }
        this.session.readBuffer.position(n2);
        this.header.readHeaderBuffer();
        this.session.readBuffer.position(n2 + 8);
        return n2;
    }

    private int readPayload(int n2, int n3) throws IOException {
        int n4 = Math.max(n3 - this.session.readBuffer.remaining(), 0);
        int n5 = this.session.readBuffer.capacity() - this.session.readBuffer.limit();
        if (n5 < n4) {
            this.session.readBuffer.position(n2);
            this.session.readBuffer.compact();
            n2 = 0;
        } else {
            this.session.readBuffer.position(this.session.readBuffer.limit());
            this.session.readBuffer.limit(this.session.readBuffer.capacity());
        }
        ((NSProtocolNIO)this.session.ns).doSocketRead(n2 + this.header.length);
        return n2;
    }

    protected void processMarker() throws IOException, NetException, BreakNetException {
    }

    final void writeToSocketChannel() throws IOException {
        this.header.length = this.session.payloadBufferForWrite.position() + 8;
        this.header.fillHeaderBuffer();
        this.session.writeBuffer.clear();
        this.session.writeBuffer.limit(this.session.payloadBufferForWrite.position() + 8);
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ((MQLNTAdapter)this.session.nt).writeToRemoteQueue(this.session.writeBuffer, true);
            this.session.writeBuffer = null;
        } else {
            while (this.session.writeBuffer.hasRemaining()) {
                this.session.socketChannel.write(this.session.writeBuffer);
            }
        }
        this.session.payloadBufferForWrite.position(this.session.payloadBufferForWrite.limit());
        this.session.payloadDataBufferForWrite.position(this.session.payloadDataBufferForWrite.limit());
    }

    static NIOPacket readNIOPacket(SessionAtts sessionAtts) throws IOException {
        NIOPacket nIOPacket = null;
        NIOHeader nIOHeader = new NIOHeader(sessionAtts);
        if (sessionAtts.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ByteBuffer byteBuffer = ((MQLNTAdapter)sessionAtts.nt).readFromLocalQueue();
            int n2 = byteBuffer.limit();
            sessionAtts.setReadBuffer(byteBuffer);
            if (n2 >= 8) {
                sessionAtts.headerBufferForRead.position(0);
                sessionAtts.headerBufferForRead.limit(8);
                nIOHeader.readNSHeader();
            }
            sessionAtts.payloadBufferForRead.clear();
            sessionAtts.payloadBufferForRead.limit(nIOHeader.length - 8);
            sessionAtts.readBuffer.position(nIOHeader.length);
        } else {
            if (sessionAtts.readBuffer.hasRemaining() && sessionAtts.readBuffer.position() != 0) {
                sessionAtts.readBuffer.compact();
            } else {
                sessionAtts.readBuffer.clear();
            }
            ((NSProtocolNIO)sessionAtts.ns).doSocketRead(8);
            sessionAtts.readBuffer.rewind();
            nIOHeader.readHeaderBuffer();
            sessionAtts.readBuffer.position(8);
        }
        switch (nIOHeader.type) {
            case 2: {
                nIOPacket = new NIOAcceptPacket(nIOHeader, sessionAtts);
                break;
            }
            case 5: {
                nIOPacket = new NIORedirectPacket(nIOHeader, sessionAtts);
                break;
            }
            case 4: {
                nIOPacket = new NIORefusePacket(nIOHeader, sessionAtts);
                break;
            }
            case 11: {
                nIOPacket = new NIOResendPacket(nIOHeader, sessionAtts);
                break;
            }
            case 12: {
                nIOPacket = new NIOMarkerPacket(nIOHeader, sessionAtts);
                break;
            }
            default: {
                throw new NetException(204);
            }
        }
        if (sessionAtts.networkType != NTAdapter.NetworkAdapterType.MSGQ) {
            nIOPacket.readFromSocketChannel(false);
        }
        nIOPacket.readPayloadBuffer();
        return nIOPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readInbandNotificationCtlPacket() throws IOException {
        block13: {
            int n2;
            block14: {
                block12: {
                    if (this.session.networkType != NTAdapter.NetworkAdapterType.MSGQ) break block12;
                    ByteBuffer byteBuffer = ((MQLNTAdapter)this.session.nt).readFromLocalQueue(false);
                    if (byteBuffer == null) {
                        return;
                    }
                    int n3 = byteBuffer.limit();
                    this.session.setReadBuffer(byteBuffer);
                    if (n3 >= 8) {
                        this.session.headerBufferForRead.position(0);
                        this.session.headerBufferForRead.limit(8);
                        this.header.readNSHeader();
                    }
                    this.session.payloadBufferForRead.clear();
                    this.session.payloadBufferForRead.limit(this.header.length - 8);
                    this.session.readBuffer.position(this.header.length);
                    break block13;
                }
                try {
                    this.session.readBuffer.clear();
                    this.session.readBuffer.limit(8);
                    n2 = 0;
                    int n4 = 0;
                    this.session.socketChannel.configureBlocking(false);
                    int n5 = this.session.socketChannel.read(this.session.readBuffer);
                    this.session.socketChannel.configureBlocking(true);
                    if (n5 == 0) {
                        return;
                    }
                    if (n5 == -1) {
                        return;
                    }
                    while (this.session.readBuffer.hasRemaining()) {
                        this.session.socketChannel.read(this.session.readBuffer);
                        n2 = n4 == this.session.readBuffer.position() ? ++n2 : 0;
                        n4 = this.session.readBuffer.position();
                        if (n2 < 10) continue;
                        throw new NetException(0);
                    }
                    this.session.readBuffer.rewind();
                    this.session.headerBufferForRead = this.session.readBuffer.slice();
                    this.header.readNSHeader();
                    this.session.readBuffer.limit(this.header.length);
                    this.session.readBuffer.position(8);
                    while (this.session.readBuffer.hasRemaining()) {
                        this.session.socketChannel.read(this.session.readBuffer);
                    }
                    this.session.readBuffer.position(8);
                    this.session.payloadBufferForRead = this.session.readBuffer.slice();
                }
                finally {
                    this.session.readBuffer.position(this.session.readBuffer.limit());
                    this.session.socketChannel.configureBlocking(true);
                }
                if (this.header.type != 14) break block14;
                this.session.controlPacket.readPayloadBuffer();
                break block13;
            }
            if (this.header.type != 6 || ((n2 = (int)this.session.payloadBufferForRead.getShort()) & 0x8000) != 32768) break block13;
            this.session.renegotiateSSLSession();
        }
    }

    void reinitialize(SessionAtts sessionAtts) throws NetException {
        this.session = sessionAtts;
    }

    void addFlags(int n2) throws NetException {
        this.header.flags |= n2;
    }

    void setPoolEnabled(boolean bl) throws IOException, NetException, BreakNetException {
        if (bl) {
            this.addFlags(1);
        }
    }

    void setLargeSDU(boolean bl) throws IOException, NetException, BreakNetException {
        if (bl) {
            this.addFlags(32);
        }
    }

    String dumpBytes(ByteBuffer byteBuffer, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(16384);
        StringBuilder stringBuilder2 = new StringBuilder(80);
        if (byteBuffer == null) {
            return "NULL";
        }
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        byteBuffer.position(n2);
        byteBuffer.limit(n3);
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder2.delete(0, stringBuilder2.length());
        int n6 = 0;
        while (byteBuffer.hasRemaining()) {
            int n7 = byteBuffer.get() & 0xFF;
            stringBuilder.append(toHex[n7]);
            stringBuilder2.append(toChar[n7]);
            if (++n6 != 8) continue;
            stringBuilder.append("     |");
            stringBuilder.append(stringBuilder2.substring(0, stringBuilder2.length()));
            stringBuilder.append("|\n");
            stringBuilder2.delete(0, stringBuilder2.length());
            n6 = 0;
        }
        if (n6 > 0) {
            int n8;
            int n9 = 8 - n6 - 1;
            for (n8 = 0; n8 <= n9; ++n8) {
                stringBuilder.append("   ");
            }
            stringBuilder.append("     |");
            stringBuilder.append(stringBuilder2.substring(0, stringBuilder2.length()));
            for (n8 = 0; n8 <= n9; ++n8) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("|\n");
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        byteBuffer.rewind();
        if (n5 >= 0) {
            byteBuffer.limit(n5);
        }
        if (n4 >= 0 && n4 <= n5) {
            byteBuffer.position(n4);
        }
        return stringBuilder.substring(0, stringBuilder.length());
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$16 = NIOPacket.class.getDeclaredConstructor(NIOHeader.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = NIOPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = NIOPacket.class.getDeclaredMethod("dumpBytes", ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = NIOPacket.class.getDeclaredMethod("setLargeSDU", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = NIOPacket.class.getDeclaredMethod("setPoolEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = NIOPacket.class.getDeclaredMethod("addFlags", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = NIOPacket.class.getDeclaredMethod("reinitialize", SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = NIOPacket.class.getDeclaredMethod("readInbandNotificationCtlPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = NIOPacket.class.getDeclaredMethod("readNIOPacket", SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = NIOPacket.class.getDeclaredMethod("writeToSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = NIOPacket.class.getDeclaredMethod("processMarker", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = NIOPacket.class.getDeclaredMethod("readPayload", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = NIOPacket.class.getDeclaredMethod("readHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = NIOPacket.class.getDeclaredMethod("readPacketFromSocketChannel", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NIOPacket.class.getDeclaredMethod("readPacketFromMSGQ", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NIOPacket.class.getDeclaredMethod("readFromSocketChannel", Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NIOPacket.class.getDeclaredMethod("readFromSocketChannel", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        toHex = new String[]{" 00", " 01", " 02", " 03", " 04", " 05", " 06", " 07", " 08", " 09", " 0A", " 0B", " 0C", " 0D", " 0E", " 0F", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 1A", " 1B", " 1C", " 1D", " 1E", " 1F", " 20", " 21", " 22", " 23", " 24", " 25", " 26", " 27", " 28", " 29", " 2A", " 2B", " 2C", " 2D", " 2E", " 2F", " 30", " 31", " 32", " 33", " 34", " 35", " 36", " 37", " 38", " 39", " 3A", " 3B", " 3C", " 3D", " 3E", " 3F", " 40", " 41", " 42", " 43", " 44", " 45", " 46", " 47", " 48", " 49", " 4A", " 4B", " 4C", " 4D", " 4E", " 4F", " 50", " 51", " 52", " 53", " 54", " 55", " 56", " 57", " 58", " 59", " 5A", " 5B", " 5C", " 5D", " 5E", " 5F", " 60", " 61", " 62", " 63", " 64", " 65", " 66", " 67", " 68", " 69", " 6A", " 6B", " 6C", " 6D", " 6E", " 6F", " 70", " 71", " 72", " 73", " 74", " 75", " 76", " 77", " 78", " 79", " 7A", " 7B", " 7C", " 7D", " 7E", " 7F", " 80", " 81", " 82", " 83", " 84", " 85", " 86", " 87", " 88", " 89", " 8A", " 8B", " 8C", " 8D", " 8E", " 8F", " 90", " 91", " 92", " 93", " 94", " 95", " 96", " 97", " 98", " 99", " 9A", " 9B", " 9C", " 9D", " 9E", " 9F", " A0", " A1", " A2", " A3", " A4", " A5", " A6", " A7", " A8", " A9", " AA", " AB", " AC", " AD", " AE", " AF", " B0", " B1", " B2", " B3", " B4", " B5", " B6", " B7", " B8", " B9", " BA", " BB", " BC", " BD", " BE", " BF", " C0", " C1", " C2", " C3", " C4", " C5", " C6", " C7", " C8", " C9", " CA", " CB", " CC", " CD", " CE", " CF", " D0", " D1", " D2", " D3", " D4", " D5", " D6", " D7", " D8", " D9", " DA", " DB", " DC", " DD", " DE", " DF", " E0", " E1", " E2", " E3", " E4", " E5", " E6", " E7", " E8", " E9", " EA", " EB", " EC", " ED", " EE", " EF", " F0", " F1", " F2", " F3", " F4", " F5", " F6", " F7", " F8", " F9", " FA", " FB", " FC", " FD", " FE", " FF"};
        toChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    }
}

