/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ano.Ano;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.AddrResolution;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public abstract class NSProtocol
implements Communication,
SQLnetDef {
    protected AddrResolution addrRes;
    protected SessionAtts sAtts;
    private static final boolean ACTIVATE_ANO = true;
    boolean ACTIVATE_ANO_NIO = true;
    NounIntf dmsParent = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;

    @Override
    public SessionAtts getSessionAttributes() {
        return this.sAtts;
    }

    @Override
    public void connect(String string, Properties properties, NounIntf nounIntf) throws IOException, NetException {
        this.connect(string, properties, null, nounIntf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String string, Properties properties, GSSCredential gSSCredential, NounIntf nounIntf) throws IOException, NetException {
        block20: {
            Object object;
            if (this.sAtts.connected) {
                throw new NetException(201);
            }
            if (string == null) {
                throw new NetException(208);
            }
            this.dmsParent = nounIntf;
            NVFactory nVFactory = new NVFactory();
            NVNavigator nVNavigator = new NVNavigator();
            Object var7_7 = null;
            Object var8_8 = null;
            this.addrRes = new AddrResolution(string, properties);
            String string2 = (String)properties.get("DISABLE_OOB");
            boolean bl = string2 != null && "true".equals(string2);
            String string3 = (String)properties.get("USE_ZERO_COPY_IO");
            boolean bl2 = true;
            if (string3 != null && "false".equals(string3)) {
                bl2 = false;
            }
            if (this.sAtts.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                bl2 = false;
            }
            this.sAtts.traceId = (String)properties.get("T4CConnection.hashCode");
            if (this.addrRes.connection_revised) {
                string = this.addrRes.getTNSAddress();
                properties = this.addrRes.getUp();
            }
            this.sAtts.profile = new ClientProfile(properties);
            this.sAtts.networkCompression = properties.getProperty("oracle.net.networkCompression").toLowerCase();
            this.sAtts.networkCompressionThreshold = Integer.parseInt(properties.getProperty("oracle.net.networkCompressionThreshold"));
            String string4 = properties.getProperty("oracle.net.networkCompressionLevels");
            this.sAtts.networkCompressionLevelsArray = new ArrayList();
            if (string4.equals("(high)")) {
                this.sAtts.networkCompressionLevelsArray.add("high");
            } else {
                string4 = string4.trim();
                string4 = string4.substring(1, string4.length() - 1);
                object = string4.split("\\s+|,");
                for (String string5 : object) {
                    if (string5.equals("")) continue;
                    this.sAtts.networkCompressionLevelsArray.add(string5.toLowerCase());
                }
            }
            try {
                this.establishConnection(string, true, this.dmsParent);
                object = null;
                if (this.ACTIVATE_ANO_NIO) {
                    try {
                        object = Class.forName("oracle.net.ano.Ano").newInstance();
                        this.sAtts.anoEnabled = true;
                    }
                    catch (Exception exception) {
                        this.sAtts.anoEnabled = false;
                    }
                    if (object != null) {
                        boolean bl3 = Boolean.valueOf(properties.getProperty("oracle.net.useJCEAPI", "false"));
                        ((Ano)object).init(this.sAtts, this.sAtts.isJavaNetNIO, bl3);
                        this.sAtts.ano = (Ano)object;
                        this.sAtts.anoEnabled = true;
                    }
                }
                this.negotiateConnection(nVFactory, nVNavigator, bl, bl2, this.dmsParent);
                this.sAtts.connected = true;
                this.sAtts.nt.setReadTimeoutIfRequired(properties);
                String string6 = (String)this.sAtts.nt.getOption(106);
                if (string6 != null && string6.equalsIgnoreCase("false")) {
                    throw new NetException(405);
                }
                if (!this.ACTIVATE_ANO_NIO || this.sAtts.noAnoServices || this.sAtts.ano == null) break block20;
                this.sAtts.ano.negotiation(this.addrRes.connection_redirected, this.sAtts.isJavaNetNIO, gSSCredential);
                String string7 = (String)this.sAtts.nt.getOption(102);
                if (string7 == null || !string7.equals("TRUE")) break block20;
                try {
                    Method method = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", null);
                    if (method.invoke((Object)this.sAtts.ano, (Object[])null) != null) {
                        throw new NetException(406);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                object = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
                if (object != null && ((TimeoutInterruptHandler.InterruptTask)object).isInterrupted()) {
                    Thread.interrupted();
                    throw new NetException(503);
                }
            }
        }
        this.addrRes.connection_redirected = false;
    }

    abstract void negotiateConnection(NVFactory var1, NVNavigator var2, boolean var3, boolean var4, NounIntf var5) throws IOException, NetException;

    @Override
    public void sendBreak() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(2, (byte)1);
            }
        } else {
            this.sendMarker(1, (byte)1);
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(2, (byte)3);
            }
        } else {
            this.sendMarker(1, (byte)3);
        }
    }

    protected abstract void sendMarker(int var1, byte var2) throws IOException, NetException;

    @Override
    public void setOption(int n2, Object object) throws NetException, IOException {
        if (n2 > 100 && n2 < 110) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            nTAdapter.setOption(n2, object);
        }
    }

    @Override
    public Object getOption(int n2) throws NetException, IOException {
        if (n2 > 100 && n2 < 110) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            return nTAdapter.getOption(n2);
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        if (nTAdapter != null) {
            nTAdapter.abort();
        }
    }

    @Override
    public String getEncryptionName() {
        String string = null;
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        try {
            string = (String)nTAdapter.getOption(105);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null && this.sAtts.ano != null) {
            string = this.sAtts.ano.getEncryptionName();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getAccessBanner() {
        return this.sAtts.getConnectData();
    }

    @Override
    public String getDataIntegrityName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getDataIntegrityName();
        }
        return string;
    }

    @Override
    public String getAuthenticationAdaptorName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getAuthenticationAdaptorName();
        }
        return string;
    }

    public void reconnectIfRequired(boolean bl) throws IOException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.sAtts.timestampLastIO;
        if (l3 > (long)this.sAtts.timeout) {
            this.reconnect(bl);
        }
    }

    @Override
    public void setO3logSessionKey(byte[] byArray) throws NetException {
        if (byArray != null) {
            this.sAtts.ano.setO3logSessionKey(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean bl) throws IOException {
        try {
            String string = new String(this.sAtts.reconnectAddress);
            this.sAtts.attemptingReconnect = true;
            ConnOption connOption = this.sAtts.cOption;
            this.addrRes.connection_redirected = true;
            this.sAtts.cOption.nt.disconnect();
            this.establishConnection(string, false, this.dmsParent);
            this.sAtts.cOption.restoreFromOrigCoption(connOption);
            if (bl) {
                this.sendProbePacket();
            }
        }
        finally {
            this.sAtts.attemptingReconnect = false;
        }
    }

    SessionAtts establishConnection(String string, NounIntf nounIntf) throws NetException, IOException {
        return this.establishConnection(string, false, nounIntf);
    }

    SessionAtts establishConnection(String string, boolean bl, NounIntf nounIntf) throws NetException, IOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(string, bl, nounIntf);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.networkType = this.sAtts.nt.getNetworkAdapterType();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.initializeSessionAttributes();
        return this.sAtts;
    }

    abstract void initializeSessionAttributes() throws NetException, IOException;

    abstract void sendProbePacket() throws IOException;

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.addrRes.isConnectionSocketKeepAlive();
    }

    @Override
    public int getSocketReadTimeout() throws NetException, IOException {
        String string = (String)this.getOption(101);
        int n2 = string == null || "".equals(string) ? 0 : Integer.parseInt(string);
        return n2;
    }

    @Override
    public void setSocketReadTimeout(int n2) throws NetException, IOException {
        String string = Integer.toString(n2);
        this.setOption(101, string);
    }

    @Override
    public String getConnectionString() {
        return this.addrRes.getTNSAddress();
    }

    public Properties getSocketOptions() {
        return this.addrRes.getSocketOptions();
    }

    @Override
    public int getNegotiatedSDU() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.negotiatedSDU;
    }

    @Override
    public NetStat getNetworkStat() {
        return this.sAtts.nt.getNetStat();
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this.sAtts.networkCompressionEnabled;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$25 = NSProtocol.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$24 = NSProtocol.class.getDeclaredMethod("isNetworkCompressionEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$23 = NSProtocol.class.getDeclaredMethod("getNetworkStat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$22 = NSProtocol.class.getDeclaredMethod("getNegotiatedSDU", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$21 = NSProtocol.class.getDeclaredMethod("getSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$20 = NSProtocol.class.getDeclaredMethod("getConnectionString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$19 = NSProtocol.class.getDeclaredMethod("setSocketReadTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$18 = NSProtocol.class.getDeclaredMethod("getSocketReadTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$17 = NSProtocol.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$16 = NSProtocol.class.getDeclaredMethod("establishConnection", String.class, Boolean.TYPE, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = NSProtocol.class.getDeclaredMethod("establishConnection", String.class, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = NSProtocol.class.getDeclaredMethod("reconnect", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = NSProtocol.class.getDeclaredMethod("setO3logSessionKey", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = NSProtocol.class.getDeclaredMethod("reconnectIfRequired", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = NSProtocol.class.getDeclaredMethod("getAuthenticationAdaptorName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = NSProtocol.class.getDeclaredMethod("getDataIntegrityName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = NSProtocol.class.getDeclaredMethod("getAccessBanner", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = NSProtocol.class.getDeclaredMethod("getEncryptionName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = NSProtocol.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = NSProtocol.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = NSProtocol.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = NSProtocol.class.getDeclaredMethod("sendInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = NSProtocol.class.getDeclaredMethod("sendBreak", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NSProtocol.class.getDeclaredMethod("connect", String.class, Properties.class, GSSCredential.class, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NSProtocol.class.getDeclaredMethod("connect", String.class, Properties.class, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NSProtocol.class.getDeclaredMethod("getSessionAttributes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

