/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.AttributeDescriptor;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_METADATA})
class Kotad {
    static final int KOTADSIG = -1365573631;
    static final int KOTPDSIG = -1365442559;
    static final int KOTRDSIG = -1365377023;
    static final int KOTCDSIG = -1365311487;
    static final int KOTODSIG = -1365307391;
    static final int KOTADXSIG = -1365303295;
    static final int KOTADPRV = 1;
    static final int KOTADPUB = 2;
    static final int KOTADCNT = 4;
    static final int KOTADCFM = 248;
    static final int KOTADSUB = 256;
    static final int KOTADPTR = 16384;
    static final int KOTADREF = 32768;
    static final int KOTADCNN = 65536;
    static final int KOTADCFN = 131072;
    static final int KOTADCVN = 262144;
    static final int KOTADTRN = 512;
    static final int KOTADCPT = 4096;
    static final int KOTADIN = 256;
    static final int KOTADOUT = 512;
    static final int KOTADCBR = 1024;
    static final int KOTADREQ = 2048;
    static final int KOTADNCP = 0x100000;
    private int kotadkvn;
    private byte[] kotadnam;
    private byte[] kotadtrf;
    private short kotadtvn;
    private short kotadid;
    private byte[] kotadprf;
    private short kotadpvn;
    private int kotadflg;
    private long kotadpre;
    private int kotadcid;
    private byte kotadscl;
    private int kotadcne;
    private byte[] kotaddft;
    private long kotadtyp;
    private byte[] kotadadd;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    private Kotad() throws SQLException {
    }

    private static Kotad unpickleKotad(PickleContext pickleContext) throws SQLException {
        Kotad kotad = new Kotad();
        pickleContext.skipBytes(2);
        long l2 = pickleContext.readLength(true) - 2;
        pickleContext.skipBytes(1);
        kotad.kotadkvn = (int)pickleContext.readUB4();
        kotad.kotadnam = pickleContext.readDataValue();
        kotad.kotadtrf = pickleContext.readDataValue();
        pickleContext.skipBytes(1);
        kotad.kotadtvn = (short)pickleContext.readUB2();
        pickleContext.skipBytes(1);
        kotad.kotadid = (short)pickleContext.readUB2();
        kotad.kotadprf = pickleContext.readDataValue();
        pickleContext.skipBytes(1);
        kotad.kotadpvn = (short)pickleContext.readUB2();
        pickleContext.skipBytes(1);
        kotad.kotadflg = (int)pickleContext.readUB4();
        pickleContext.skipBytes(1);
        kotad.kotadpre = pickleContext.readUB4();
        pickleContext.skipBytes(1);
        kotad.kotadcid = pickleContext.readUB2();
        pickleContext.skipBytes(1);
        kotad.kotadscl = pickleContext.readByte();
        pickleContext.skipBytes(1);
        kotad.kotadcne = (int)pickleContext.readUB4();
        kotad.kotaddft = pickleContext.readDataValue();
        pickleContext.skipBytes(1);
        kotad.kotadtyp = pickleContext.readUB4();
        kotad.kotadadd = pickleContext.readDataValue();
        return kotad;
    }

    static final TypeDescriptor unpickleTypeDescriptorImage(PickleContext pickleContext) throws SQLException {
        Kotad kotad = Kotad.unpickleKotad(pickleContext);
        if (kotad.kotadkvn != -1365311487) {
            throw (SQLException)DatabaseError.createSqlException(179).fillInStackTrace();
        }
        TypeDescriptor typeDescriptor = Kotad.constructPredefinedTypeDescriptor(kotad);
        return typeDescriptor;
    }

    static final AttributeDescriptor unpickleAttributeImage(boolean bl, PickleContext pickleContext) throws SQLException {
        Kotad kotad = Kotad.unpickleKotad(pickleContext);
        if (kotad.kotadkvn != -1365573631) {
            throw (SQLException)DatabaseError.createSqlException(179).fillInStackTrace();
        }
        TypeDescriptor typeDescriptor = null;
        if (bl) {
            typeDescriptor = Kotad.constructPredefinedTypeDescriptor(kotad);
        }
        AttributeDescriptor attributeDescriptor = new AttributeDescriptor(new String(kotad.kotadnam), kotad.kotadid, kotad.kotadflg, typeDescriptor);
        return attributeDescriptor;
    }

    private static final TypeDescriptor constructPredefinedTypeDescriptor(Kotad kotad) throws SQLException {
        short s2;
        if (kotad.kotadtrf.length != 36) {
            throw (SQLException)DatabaseError.createSqlException(180).fillInStackTrace();
        }
        for (s2 = 4; s2 < 18; ++s2) {
            if (kotad.kotadtrf[s2] == 0) continue;
            throw (SQLException)DatabaseError.createSqlException(180).fillInStackTrace();
        }
        s2 = TypeDescriptor.OID_TO_TYPECODE[kotad.kotadtrf[19]];
        TypeDescriptor typeDescriptor = new TypeDescriptor(s2);
        typeDescriptor.setPrecision(kotad.kotadpre);
        typeDescriptor.setScale(kotad.kotadscl);
        return typeDescriptor;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$5 = Kotad.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = Kotad.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = Kotad.class.getDeclaredMethod("constructPredefinedTypeDescriptor", Kotad.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = Kotad.class.getDeclaredMethod("unpickleAttributeImage", Boolean.TYPE, PickleContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = Kotad.class.getDeclaredMethod("unpickleTypeDescriptorImage", PickleContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = Kotad.class.getDeclaredMethod("unpickleKotad", PickleContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

