/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class XADataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(XADataSourceConnectionFactoryAdapter.class.getCanonicalName());
    protected XADataSource m_xaDataSource;

    public XADataSourceConnectionFactoryAdapter(XADataSource xaDataSource) throws UniversalConnectionPoolException {
        if (null == xaDataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(260);
        }
        this.m_xaDataSource = xaDataSource;
    }

    public XADataSource getXaDataSource() {
        return this.m_xaDataSource;
    }

    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        JDBCConnectionRetrievalInfo jdbcConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
        XAConnection xaConnection = null;
        try {
            xaConnection = this.m_xaDataSource.getXAConnection(jdbcConnectionRequestInfo.getUser(), jdbcConnectionRequestInfo.getPassword());
            UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
            if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
                xaConnection.addConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
            }
        }
        catch (SQLException sqlException) {
            UCPErrorHandler.throwUniversalConnectionPoolException(261, sqlException);
        }
        logger.finest("connection created");
        return xaConnection;
    }

    public void closeConnection(Object connection) throws UniversalConnectionPoolException {
        if (!(connection instanceof XAConnection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(262);
        }
        XAConnection xaConnection = (XAConnection)connection;
        UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
        if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
            xaConnection.removeConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
        }
        try {
            xaConnection.close();
        }
        catch (SQLException sqlException) {
            UCPErrorHandler.throwUniversalConnectionPoolException(263);
        }
        logger.finest("connection closed");
    }
}

