/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.util.logging.UCPLoggerFactory;

class ONSSubscriberBase {
    private static final Logger logger = UCPLoggerFactory.createLogger(ONSSubscriberBase.class.getCanonicalName());
    static Mocker mocker = new Mocker();
    Subscriber m_subscriber = null;
    private boolean m_failed = false;

    ONSSubscriberBase(final String eventStr) {
        try {
            this.m_subscriber = mocker.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){

                @Override
                public Subscriber run() {
                    try {
                        return mocker.createSubscriber(eventStr);
                    }
                    catch (SubscriptionException se) {
                        logger.log(Level.FINEST, "instantiating subscriber", se);
                        ONSSubscriberBase.this.m_failed = true;
                        return null;
                    }
                    catch (ONSException e) {
                        logger.log(Level.FINEST, "instantiating subscriber", e);
                        ONSSubscriberBase.this.m_failed = true;
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            logger.log(Level.FINEST, "instantiating subscriber", e);
        }
    }

    ONSSubscriberBase(Subscriber subscriber) {
        this.m_subscriber = subscriber;
    }

    boolean isFailed() {
        return this.m_failed;
    }

    Notification receive(long timeout) throws UniversalConnectionPoolException {
        try {
            Notification event = this.receiveMoker(timeout);
            logger.finest("notification received");
            return event;
        }
        catch (ONSException e) {
            UniversalConnectionPoolException ucpe = new UniversalConnectionPoolException(e);
            logger.throwing(this.getClass().getName(), "receive", ucpe);
            throw ucpe;
        }
    }

    Notification receiveMoker(long timeout) {
        if (null != this.m_subscriber) {
            return 0L == timeout ? this.m_subscriber.receive(true) : this.m_subscriber.receive(timeout);
        }
        return null;
    }

    public void close() {
        this.closeMocker();
        this.m_subscriber = null;
        logger.finest("subscriber closed");
    }

    void closeMocker() {
        if (null != this.m_subscriber) {
            this.m_subscriber.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Mocker {
        Mocker() {
        }

        Subscriber createSubscriber(String eventString) {
            return new Subscriber(eventString, "", 30000L);
        }

        Subscriber doPrivileged(PrivilegedExceptionAction<Subscriber> action) throws PrivilegedActionException {
            return AccessController.doPrivileged(action);
        }
    }
}

