/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.io.InputStream;
import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.routing.DestinationMap;
import oracle.ucp.routing.ShardInfo;
import oracle.ucp.routing.ShardInfoImpl;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class Chunk {
    private final String name;
    private final AtomicInteger version = new AtomicInteger(0);
    private final AtomicInteger affinitizedInstId = new AtomicInteger(0);
    private final AtomicInteger id = new AtomicInteger(0);
    private final AtomicInteger uniqueId = new AtomicInteger(0);
    private final Set<ShardInfo> shardInfoSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final DestinationMap destinationMap = new DestinationMap();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;

    Chunk(String name) {
        this.name = name;
    }

    Chunk(String name, int version) {
        this.name = name;
        this.version.set(version);
    }

    boolean hasInstance(ServiceMember instance) {
        return this.destinationMap.contains(instance);
    }

    int instancePriority(ServiceMember instance) {
        if (instance == null) {
            return Integer.MAX_VALUE;
        }
        return this.destinationMap.getPriority(instance);
    }

    void addInstanceWithPriority(ServiceMember instance, int priority) {
        this.destinationMap.add(instance, priority);
    }

    void removeInstance(ServiceMember instance) {
        this.destinationMap.remove(instance);
    }

    Set<ServiceMember> priorityInstances() {
        return this.destinationMap.getHighestPriorityInstances().allInstances();
    }

    @DisableTrace
    public Set<ServiceMember> instances() {
        return this.destinationMap.allInstances();
    }

    @DisableTrace
    public AtomicInteger affinitizedInstId() {
        return this.affinitizedInstId;
    }

    @DisableTrace
    public void setAffinitizedInstId(int instId) {
        this.affinitizedInstId.set(instId);
    }

    @DisableTrace
    public void setId(int id) {
        this.id.set(id);
    }

    @DisableTrace
    public void setUniqueId(int uniqueId) {
        this.uniqueId.set(uniqueId);
    }

    @DisableTrace
    public int getUniqueId() {
        return this.uniqueId.get();
    }

    @DisableTrace
    public void addShardInfo(String name, int priority) {
        this.shardInfoSet.add(new ShardInfoImpl(name, priority));
    }

    @DisableTrace
    public AtomicInteger Id() {
        return this.id;
    }

    @DisableTrace
    String name() {
        return this.name + (this.version() == 0 ? "" : "-" + this.version.get());
    }

    @DisableTrace
    int version() {
        return this.version.get();
    }

    @DisableTrace
    void setVersion(int version) {
        this.version.set(version);
    }

    @DisableTrace
    String absoluteName() {
        if (!this.name.contains("-")) {
            return this.name;
        }
        return this.name.substring(0, this.name.indexOf("-"));
    }

    @DisableTrace
    public Set<ShardInfo> shardInfo() {
        return this.shardInfoSet;
    }

    @DisableTrace
    public String toString() {
        return this.name() + "\t\t " + (this.affinitizedInstId.get() != 0 ? "Affinity Instance Id: " + this.affinitizedInstId + ", INSTANCES: " : "") + "[" + this.destinationMap.getHighestPriorityInstances().allInstances().stream().filter(k -> k != null).map(sm -> sm.name()).collect(Collectors.joining(", ")) + " ]";
    }

    public boolean hasPriorityInstance(ServiceMember instance) {
        if (instance == null) {
            return false;
        }
        if (this.priorityInstances() == null) {
            return false;
        }
        return this.priorityInstances().contains(instance);
    }

    static {
        try {
            $$$methodRef$$$23 = Chunk.class.getDeclaredConstructor(String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = Chunk.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = Chunk.class.getDeclaredMethod("lambda$toString$0", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = Chunk.class.getDeclaredMethod("lambda$toString$1", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = Chunk.class.getDeclaredMethod("hasPriorityInstance", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = Chunk.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = Chunk.class.getDeclaredMethod("shardInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = Chunk.class.getDeclaredMethod("absoluteName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = Chunk.class.getDeclaredMethod("setVersion", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = Chunk.class.getDeclaredMethod("version", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = Chunk.class.getDeclaredMethod("name", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = Chunk.class.getDeclaredMethod("Id", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = Chunk.class.getDeclaredMethod("addShardInfo", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = Chunk.class.getDeclaredMethod("getUniqueId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = Chunk.class.getDeclaredMethod("setUniqueId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = Chunk.class.getDeclaredMethod("setId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = Chunk.class.getDeclaredMethod("setAffinitizedInstId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = Chunk.class.getDeclaredMethod("affinitizedInstId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = Chunk.class.getDeclaredMethod("instances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = Chunk.class.getDeclaredMethod("priorityInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Chunk.class.getDeclaredMethod("removeInstance", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Chunk.class.getDeclaredMethod("addInstanceWithPriority", ServiceMember.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Chunk.class.getDeclaredMethod("instancePriority", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Chunk.class.getDeclaredMethod("hasInstance", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    public static final class Metadata {
        String chunkName;
        InputStream shardKeyLow;
        InputStream shardKeyHigh;
        InputStream superKeyLow;
        InputStream superKeyHigh;
        int priority;
        int affinitizedInstId;
        int chunkId;
        int chunkUniqueId;
        String shardName;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        public void setChunkName(String chunkName) {
            this.chunkName = chunkName;
        }

        public void setShardKeyLow(InputStream shardKeyLow) {
            this.shardKeyLow = shardKeyLow;
        }

        public void setShardKeyHigh(InputStream shardKeyHigh) {
            this.shardKeyHigh = shardKeyHigh;
        }

        public void setSuperKeyLow(InputStream superKeyLow) {
            this.superKeyLow = superKeyLow;
        }

        public void setSuperKeyHigh(InputStream superKeyHigh) {
            this.superKeyHigh = superKeyHigh;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setAffinitizedInstId(int affinitizedInstId) {
            this.affinitizedInstId = affinitizedInstId;
        }

        public void setChunkId(int chunkId) {
            this.chunkId = chunkId;
        }

        public void setChunkUniqueId(int chunkUniqueId) {
            this.chunkUniqueId = chunkUniqueId;
        }

        @DisableTrace
        public String toString() {
            return "[chunkName=" + this.chunkName + ", shardKeyLow=" + this.shardKeyLow + ", shardKeyHigh=" + this.shardKeyHigh + ", superKeyLow=" + this.superKeyLow + ", superKeyHigh=" + this.superKeyHigh + ", priority=" + this.priority + ", affinitizedInstId=" + this.affinitizedInstId + ", chunkId=" + this.chunkId + ", shardName=" + this.shardName + ", chunkUniqueId=" + this.chunkUniqueId + "]";
        }

        static {
            try {
                $$$methodRef$$$10 = Metadata.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = Metadata.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = Metadata.class.getDeclaredMethod("setChunkUniqueId", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = Metadata.class.getDeclaredMethod("setChunkId", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = Metadata.class.getDeclaredMethod("setAffinitizedInstId", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = Metadata.class.getDeclaredMethod("setPriority", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = Metadata.class.getDeclaredMethod("setSuperKeyHigh", InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = Metadata.class.getDeclaredMethod("setSuperKeyLow", InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Metadata.class.getDeclaredMethod("setShardKeyHigh", InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Metadata.class.getDeclaredMethod("setShardKeyLow", InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Metadata.class.getDeclaredMethod("setChunkName", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

