/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.io.InputStream;
import java.lang.reflect.Executable;
import java.net.URI;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import oracle.ucp.xml.XMLConfigurationParser;

public class DatasourceConfigManager {
    private static DatasourceConfigManager configManager;
    private static Map<String, Object> parsedUcpConfigMap;
    private static Map<String, PoolDataSource> poolDataSources;
    private static Map<String, PoolXADataSource> poolXADataSources;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    private DatasourceConfigManager() {
    }

    public static synchronized void init() throws UniversalConnectionPoolException {
        if (configManager != null) {
            return;
        }
        try {
            String xmlSystemPropertyPath = Util.getXMLConfigurationFilePath();
            if (null != xmlSystemPropertyPath && !xmlSystemPropertyPath.isEmpty()) {
                URI xmlFilePathAsURI = URI.create(xmlSystemPropertyPath);
                XMLConfigurationParser parser = XMLConfigurationParser.getInstance();
                parsedUcpConfigMap = parser.parse(xmlFilePathAsURI);
                DatasourceConfigManager.loadPoolsFromConfig();
                configManager = new DatasourceConfigManager();
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(387, e);
        }
    }

    public static synchronized void init(InputStream is) throws UniversalConnectionPoolException {
        if (configManager != null) {
            return;
        }
        if (null == is) {
            DatasourceConfigManager.init();
        } else {
            try {
                XMLConfigurationParser parser = XMLConfigurationParser.getInstance();
                parsedUcpConfigMap = parser.parse(is);
                DatasourceConfigManager.loadPoolsFromConfig();
                configManager = new DatasourceConfigManager();
            }
            catch (Exception e) {
                UCPErrorHandler.throwUniversalConnectionPoolException(387, e);
            }
        }
    }

    public static DatasourceConfigManager getDatasourceConfigManager() {
        return DatasourceConfigManager.getDatasourceConfigManager(null);
    }

    public static DatasourceConfigManager getDatasourceConfigManager(InputStream is) {
        if (configManager == null) {
            try {
                DatasourceConfigManager.init(is);
            }
            catch (UniversalConnectionPoolException e) {
                throw new IllegalStateException(" Invalid UCP Config ", e);
            }
        }
        return configManager;
    }

    private static void loadPoolsFromConfig() throws Exception {
        for (Map.Entry<String, Object> e : parsedUcpConfigMap.entrySet()) {
            DatasourceConfigManager.loadPool(e.getKey(), e.getValue());
        }
    }

    private static void loadPool(String poolName, Object poolConfig) throws UniversalConnectionPoolException, Exception {
        Map poolConfigMap = (Map)poolConfig;
        boolean isXAPool = false;
        if (Boolean.parseBoolean((String)poolConfigMap.get("is-xa-pool"))) {
            isXAPool = true;
        }
        for (Map.Entry poolConfigEntry : poolConfigMap.entrySet()) {
            if (!((String)poolConfigEntry.getKey()).startsWith("data-source-")) continue;
            String dsName = ((String)poolConfigEntry.getKey()).substring("data-source-".length());
            if (isXAPool) {
                PoolXADataSourceImpl pdsXA = new PoolXADataSourceImpl(poolName, dsName, poolConfigMap);
                poolXADataSources.putIfAbsent(dsName, pdsXA);
                continue;
            }
            PoolDataSourceImpl pds = new PoolDataSourceImpl(poolName, dsName, poolConfigMap);
            poolDataSources.putIfAbsent(dsName, pds);
        }
    }

    PoolDataSource getPoolDataSource(String dataSourceName) throws SQLException {
        PoolDataSource pds = poolDataSources.get(dataSourceName);
        if (pds == null) {
            UCPErrorHandler.throwSQLException(73, null);
        }
        return pds;
    }

    PoolXADataSource getPoolXADataSource(String dataSourceName) throws SQLException {
        PoolXADataSource xaPds = poolXADataSources.get(dataSourceName);
        if (xaPds == null) {
            UCPErrorHandler.throwSQLException(73, null);
        }
        return xaPds;
    }

    public static boolean isPoolCreatedUsingXmlConfig(String poolName) {
        return parsedUcpConfigMap != null ? parsedUcpConfigMap.containsKey(poolName) : false;
    }

    static Map<String, Object> getPoolConfigFromXML(String poolName) {
        return parsedUcpConfigMap != null ? (Map)parsedUcpConfigMap.get(poolName) : null;
    }

    static Map<String, PoolDataSource> getPoolDataSources() {
        return poolDataSources;
    }

    static Map<String, PoolXADataSource> getPoolXADataSources() {
        return poolXADataSources;
    }

    static {
        try {
            $$$methodRef$$$12 = DatasourceConfigManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = DatasourceConfigManager.class.getDeclaredMethod("getPoolXADataSources", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = DatasourceConfigManager.class.getDeclaredMethod("getPoolDataSources", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = DatasourceConfigManager.class.getDeclaredMethod("getPoolConfigFromXML", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = DatasourceConfigManager.class.getDeclaredMethod("isPoolCreatedUsingXmlConfig", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = DatasourceConfigManager.class.getDeclaredMethod("getPoolXADataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = DatasourceConfigManager.class.getDeclaredMethod("getPoolDataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = DatasourceConfigManager.class.getDeclaredMethod("loadPool", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = DatasourceConfigManager.class.getDeclaredMethod("loadPoolsFromConfig", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = DatasourceConfigManager.class.getDeclaredMethod("getDatasourceConfigManager", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = DatasourceConfigManager.class.getDeclaredMethod("getDatasourceConfigManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = DatasourceConfigManager.class.getDeclaredMethod("init", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = DatasourceConfigManager.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        configManager = null;
        poolDataSources = new HashMap<String, PoolDataSource>();
        poolXADataSources = new HashMap<String, PoolXADataSource>();
    }
}

