/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;

@DefaultLogger(value="oracle.ucp.util")
public class UniqueIdentifier {
    private static final AtomicInteger idNum;
    private static final String jvmInstanceId;
    private static final String hostName;
    private final String uniqueID;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    String initHostName() {
        String hostName = null;
        try {
            hostName = this.getLocalHostName();
        }
        catch (UnknownHostException e) {
            ClioSupport.ilogWarning(null, null, null, null, "failed to get this host's name");
        }
        if ("localhost".equals(hostName)) {
            ClioSupport.ilogWarning(null, null, null, null, "'localhost' is not a unique hostname");
            hostName = null;
        }
        return hostName;
    }

    String initJvmInstanceId() {
        String jvmInstanceId = null;
        try {
            String tempUID = new UID().toString();
            if (tempUID != null && (jvmInstanceId = tempUID.split(":", 2)[0]) != null) {
                jvmInstanceId = jvmInstanceId.replace('-', 'a');
            }
        }
        catch (Exception e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        return jvmInstanceId;
    }

    public UniqueIdentifier(String prefix) {
        this.uniqueID = null != jvmInstanceId && null != hostName ? new StringBuilder(256).append(prefix).append(jvmInstanceId).append('-').append(idNum.incrementAndGet()).append('-').append(hostName).toString() : UUID.randomUUID().toString();
    }

    public boolean equals(Object uniqueID) {
        boolean ret_Value = false;
        if (uniqueID != null && uniqueID instanceof UniqueIdentifier && this == uniqueID) {
            ret_Value = true;
        }
        return ret_Value;
    }

    public int hashCode() {
        return this.uniqueID.hashCode();
    }

    @DisableTrace
    public String toString() {
        return this.uniqueID;
    }

    public static UniqueIdentifier generateUniqueID(String prefix) {
        return new UniqueIdentifier(prefix);
    }

    protected String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    static {
        try {
            $$$methodRef$$$7 = UniqueIdentifier.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = UniqueIdentifier.class.getDeclaredMethod("getLocalHostName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = UniqueIdentifier.class.getDeclaredMethod("generateUniqueID", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = UniqueIdentifier.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = UniqueIdentifier.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = UniqueIdentifier.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UniqueIdentifier.class.getDeclaredMethod("initJvmInstanceId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UniqueIdentifier.class.getDeclaredMethod("initHostName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        idNum = new AtomicInteger(0);
        jvmInstanceId = new UniqueIdentifier("").initJvmInstanceId();
        hostName = new UniqueIdentifier("").initHostName();
    }
}

