/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.io.Serializable;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.jdbc.oracle.RACAffinityContext;

public class AffinityContext
implements RACAffinityContext,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1554319099870773354L;
    private final String service;
    private final String database;
    private final String instance;
    private final RACAffinityContext.AffinityType affinityType;

    public AffinityContext(String service, String database, String instance, RACAffinityContext.AffinityType affinityType) {
        this.service = service;
        this.database = database;
        this.instance = instance;
        this.affinityType = affinityType;
    }

    public AffinityContext(String service, String database, String instance, ConnectionAffinityCallback.AffinityPolicy policy) {
        this(service, database, instance, AffinityContext.toAffinityType(policy));
    }

    private static RACAffinityContext.AffinityType toAffinityType(ConnectionAffinityCallback.AffinityPolicy policy) {
        switch (policy) {
            case WEBSESSION_BASED_AFFINITY: {
                return RACAffinityContext.AffinityType.WEBSESSION_BASED_AFFINITY;
            }
            case TRANSACTION_BASED_AFFINITY: {
                return RACAffinityContext.AffinityType.TRANSACTION_BASED_AFFINITY;
            }
        }
        throw new IllegalStateException("wrong policy");
    }

    @Override
    public String getVersionNumber() {
        return "1.0";
    }

    @Override
    public String getServiceName() {
        return this.service;
    }

    @Override
    public String getDatabaseUniqueName() {
        return this.database;
    }

    @Override
    public String getInstanceName() {
        return this.instance;
    }

    @Override
    public RACAffinityContext.AffinityType getAffinityType() {
        return this.affinityType;
    }

    public String toString() {
        return "service=" + this.service + ", db=" + this.database + ", instance=" + this.instance + ", affinityType=" + (Object)((Object)this.affinityType);
    }
}

