/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcTimeoutException;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.sql.DataSource;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleRow;
import oracle.jdbc.datasource.OracleDataSource;
import oracle.r2dbc.OracleR2dbcOptions;
import oracle.r2dbc.impl.AsyncLock;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class OracleReactiveJdbcAdapter
implements ReactiveJdbcAdapter {
    private static final Set<Option<CharSequence>> JDBC_CONNECTION_PROPERTY_OPTIONS = Set.of(OracleR2dbcOptions.TNS_ADMIN, OracleR2dbcOptions.TLS_WALLET_LOCATION, OracleR2dbcOptions.TLS_WALLET_PASSWORD, OracleR2dbcOptions.TLS_KEYSTORE, OracleR2dbcOptions.TLS_KEYSTORE_TYPE, Option.sensitiveValueOf((String)"javax.net.ssl.keyStorePassword"), OracleR2dbcOptions.TLS_TRUSTSTORE, OracleR2dbcOptions.TLS_TRUSTSTORE_TYPE, OracleR2dbcOptions.TLS_TRUSTSTORE_PASSWORD, OracleR2dbcOptions.AUTHENTICATION_SERVICES, OracleR2dbcOptions.TLS_CERTIFICATE_ALIAS, OracleR2dbcOptions.TLS_SERVER_DN_MATCH, OracleR2dbcOptions.TLS_SERVER_CERT_DN, OracleR2dbcOptions.TLS_VERSION, OracleR2dbcOptions.TLS_CIPHER_SUITES, OracleR2dbcOptions.TLS_KEYMANAGERFACTORY_ALGORITHM, OracleR2dbcOptions.TLS_TRUSTMANAGERFACTORY_ALGORITHM, OracleR2dbcOptions.SSL_CONTEXT_PROTOCOL, OracleR2dbcOptions.FAN_ENABLED, OracleR2dbcOptions.IMPLICIT_STATEMENT_CACHE_SIZE, OracleR2dbcOptions.DEFAULT_LOB_PREFETCH_SIZE, OracleR2dbcOptions.DISABLE_OUT_OF_BAND_BREAK, OracleR2dbcOptions.ENABLE_QUERY_RESULT_CACHE, OracleR2dbcOptions.VSESSION_OSUSER, OracleR2dbcOptions.VSESSION_TERMINAL, OracleR2dbcOptions.VSESSION_PROCESS, OracleR2dbcOptions.VSESSION_PROGRAM, OracleR2dbcOptions.VSESSION_MACHINE);
    private final AsyncLock asyncLock = new AsyncLock();

    private OracleReactiveJdbcAdapter() {
    }

    static OracleReactiveJdbcAdapter getInstance() {
        return new OracleReactiveJdbcAdapter();
    }

    @Override
    public AsyncLock getLock() {
        return this.asyncLock;
    }

    @Override
    public DataSource createDataSource(ConnectionFactoryOptions options) {
        OracleDataSource oracleDataSource = (OracleDataSource)OracleR2dbcExceptions.fromJdbc(oracle.jdbc.pool.OracleDataSource::new);
        OracleR2dbcExceptions.runJdbc(() -> oracleDataSource.setURL(OracleReactiveJdbcAdapter.composeJdbcUrl(options)));
        OracleReactiveJdbcAdapter.configureStandardOptions(oracleDataSource, options);
        OracleReactiveJdbcAdapter.configureExtendedOptions(oracleDataSource, options);
        OracleReactiveJdbcAdapter.configureJdbcDefaults(oracleDataSource);
        return oracleDataSource;
    }

    private static String composeJdbcUrl(ConnectionFactoryOptions options) {
        Object descriptor = options.getValue(OracleR2dbcOptions.DESCRIPTOR);
        if (descriptor != null) {
            OracleReactiveJdbcAdapter.validateDescriptorOptions(options);
            return "jdbc:oracle:thin:@" + descriptor.toString();
        }
        Object host = options.getRequiredValue(ConnectionFactoryOptions.HOST);
        Integer port = OracleReactiveJdbcAdapter.parseOptionValue(ConnectionFactoryOptions.PORT, options, Integer.class, Integer::valueOf);
        Object serviceName = options.getValue(ConnectionFactoryOptions.DATABASE);
        Boolean isTcps = OracleReactiveJdbcAdapter.parseOptionValue(ConnectionFactoryOptions.SSL, options, Boolean.class, Boolean::valueOf);
        return String.format("jdbc:oracle:thin:@%s%s%s%s", Boolean.TRUE.equals(isTcps) ? "tcps:" : "", host, port != null ? ":" + port : "", serviceName != null ? "/" + serviceName : "");
    }

    private static void validateDescriptorOptions(ConnectionFactoryOptions options) {
        Object[] conflictingOptions = (Option[])Set.of(ConnectionFactoryOptions.HOST, ConnectionFactoryOptions.PORT, ConnectionFactoryOptions.DATABASE, ConnectionFactoryOptions.SSL).stream().filter(arg_0 -> ((ConnectionFactoryOptions)options).hasOption(arg_0)).filter(option -> !options.getValue(option).toString().isEmpty()).toArray(Option[]::new);
        if (conflictingOptions.length != 0) {
            throw new IllegalArgumentException(OracleR2dbcOptions.DESCRIPTOR.name() + " Option has been specified with potentially conflicting Options: " + Arrays.toString(conflictingOptions));
        }
    }

    private static void configureStandardOptions(OracleDataSource oracleDataSource, ConnectionFactoryOptions options) {
        Duration timeout;
        Object password;
        Object user = options.getValue(ConnectionFactoryOptions.USER);
        if (user != null) {
            OracleR2dbcExceptions.runJdbc(() -> oracleDataSource.setUser(user.toString()));
        }
        if ((password = options.getValue(ConnectionFactoryOptions.PASSWORD)) != null) {
            OracleR2dbcExceptions.runJdbc(() -> oracleDataSource.setPassword(password.toString()));
        }
        if ((timeout = OracleReactiveJdbcAdapter.parseOptionValue(ConnectionFactoryOptions.CONNECT_TIMEOUT, options, Duration.class, Duration::parse)) != null) {
            OracleR2dbcExceptions.runJdbc(() -> oracleDataSource.setLoginTimeout(Math.toIntExact(timeout.getSeconds()) + (timeout.getNano() == 0 ? 0 : 1)));
        }
    }

    private static void configureExtendedOptions(OracleDataSource oracleDataSource, ConnectionFactoryOptions options) {
        Object tnsAdmin = options.getValue(Option.valueOf((String)"TNS_ADMIN"));
        if (tnsAdmin != null) {
            OracleR2dbcExceptions.runJdbc(() -> oracleDataSource.setConnectionProperty("oracle.net.tns_admin", tnsAdmin.toString()));
        }
        for (Option<CharSequence> option : JDBC_CONNECTION_PROPERTY_OPTIONS) {
            Object value = options.getValue(option);
            if (value == null) continue;
            OracleR2dbcExceptions.runJdbc(() -> oracleDataSource.setConnectionProperty(option.name(), value.toString()));
        }
    }

    private static <T> T parseOptionValue(Option<T> option, ConnectionFactoryOptions options, Class<T> type, Function<String, T> parser) {
        Object value = options.getValue(option);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        if (value instanceof String) {
            try {
                return parser.apply((String)value);
            }
            catch (Throwable parseFailure) {
                throw new IllegalArgumentException("Failed to parse the value of Option: " + option.name(), parseFailure);
            }
        }
        throw new IllegalArgumentException(String.format("Value of Option %s has an unexpected type: %s. Expected Type is: %s.", option.name(), value.getClass(), type));
    }

    private static void configureJdbcDefaults(OracleDataSource oracleDataSource) {
        String enableJdbcSpecCompliance = "oracle.jdbc.J2EE13Compliant";
        OracleR2dbcExceptions.runJdbc(() -> oracleDataSource.setConnectionProperty(enableJdbcSpecCompliance, "true"));
        OracleReactiveJdbcAdapter.setPropertyIfAbsent(oracleDataSource, "oracle.jdbc.implicitStatementCacheSize", "25");
        OracleReactiveJdbcAdapter.setPropertyIfAbsent(oracleDataSource, "oracle.jdbc.defaultLobPrefetchSize", "1048576");
    }

    private static void setPropertyIfAbsent(OracleDataSource oracleDataSource, String property, String value) {
        OracleR2dbcExceptions.runJdbc(() -> {
            String userValue = oracleDataSource.getConnectionProperty(property);
            if (userValue == null) {
                oracleDataSource.setConnectionProperty(property, value);
            }
        });
    }

    @Override
    public Publisher<? extends Connection> publishConnection(DataSource dataSource, Executor executor) {
        OracleDataSource oracleDataSource = this.unwrapOracleDataSource(dataSource);
        return Mono.from(this.adaptFlowPublisher(() -> oracleDataSource.createConnectionBuilder().executorOracle(executor).buildConnectionPublisherOracle())).onErrorMap(R2dbcException.class, error -> error.getErrorCode() == 18714 ? new R2dbcTimeoutException(error.getMessage(), error.getSqlState(), error.getErrorCode(), error.getCause()) : error);
    }

    @Override
    public Publisher<Boolean> publishSQLExecution(PreparedStatement sqlStatement) {
        OraclePreparedStatement oraclePreparedStatement = this.unwrapOraclePreparedStatement(sqlStatement);
        return this.adaptFlowPublisher(() -> ((OraclePreparedStatement)oraclePreparedStatement).executeAsyncOracle());
    }

    @Override
    public Publisher<Long> publishBatchUpdate(PreparedStatement batchUpdateStatement) {
        OraclePreparedStatement oraclePreparedStatement = this.unwrapOraclePreparedStatement(batchUpdateStatement);
        return this.adaptFlowPublisher(() -> ((OraclePreparedStatement)oraclePreparedStatement).executeBatchAsyncOracle());
    }

    @Override
    public <T> Publisher<T> publishRows(ResultSet resultSet, Function<ReactiveJdbcAdapter.JdbcReadable, T> rowMappingFunction) {
        OracleResultSet oracleResultSet = this.unwrapOracleResultSet(resultSet);
        final Connection connection = OracleR2dbcExceptions.fromJdbc(() -> oracleResultSet.getStatement().getConnection());
        Publisher publisher = this.adaptFlowPublisher(() -> oracleResultSet.publisherOracle(oracleRow -> rowMappingFunction.apply(new OracleJdbcReadable((OracleRow)oracleRow))));
        return subscriber -> publisher.subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                subscriber.onSubscribe(s);
            }

            public void onNext(T t) {
                OracleR2dbcExceptions.runJdbc(connection::isClosed);
                subscriber.onNext(t);
            }

            public void onError(Throwable t) {
                subscriber.onError(t);
            }

            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }

    @Override
    public Publisher<Void> publishCommit(Connection connection) {
        OracleConnection oracleConnection = this.unwrapOracleConnection(connection);
        return this.adaptFlowPublisher(() -> {
            if (oracleConnection.getAutoCommit()) {
                return FlowAdapters.toFlowPublisher((Publisher)Mono.empty());
            }
            return oracleConnection.commitAsyncOracle();
        });
    }

    @Override
    public Publisher<Void> publishRollback(Connection connection) {
        OracleConnection oracleConnection = this.unwrapOracleConnection(connection);
        return this.adaptFlowPublisher(() -> {
            if (oracleConnection.getAutoCommit()) {
                return FlowAdapters.toFlowPublisher((Publisher)Mono.empty());
            }
            return oracleConnection.rollbackAsyncOracle();
        });
    }

    @Override
    public Publisher<Void> publishClose(Connection connection) {
        return this.adaptFlowPublisher(() -> ((OracleConnection)this.unwrapOracleConnection(connection)).closeAsyncOracle());
    }

    @Override
    public Publisher<ByteBuffer> publishBlobRead(Blob blob) throws R2dbcException {
        OracleBlob oracleBlob = this.castAsType(blob, OracleBlob.class);
        return Flux.from(this.adaptFlowPublisher(() -> oracleBlob.publisherOracle(1L))).map(ByteBuffer::wrap);
    }

    public Publisher<String> publishClobRead(Clob clob) throws R2dbcException {
        OracleClob oracleClob = this.castAsType(clob, OracleClob.class);
        return this.adaptFlowPublisher(() -> oracleClob.publisherOracle(1L));
    }

    @Override
    public Publisher<Void> publishBlobWrite(Publisher<ByteBuffer> contentPublisher, Blob blob) {
        OracleBlob oracleBlob = this.castAsType(blob, OracleBlob.class);
        CompletionSubscriber outcomeSubscriber = new CompletionSubscriber();
        Flow.Subscriber blobSubscriber = OracleR2dbcExceptions.fromJdbc(() -> oracleBlob.subscriberOracle(1L, (Flow.Subscriber)outcomeSubscriber));
        return this.adaptFlowPublisher(() -> {
            Flux.from((Publisher)contentPublisher).map(byteBuffer -> {
                ByteBuffer slice = byteBuffer.slice();
                byte[] byteArray = new byte[slice.remaining()];
                slice.get(byteArray);
                return byteArray;
            }).subscribe(FlowAdapters.toSubscriber((Flow.Subscriber)blobSubscriber));
            return FlowAdapters.toFlowPublisher(outcomeSubscriber.publish());
        });
    }

    @Override
    public Publisher<Void> publishClobWrite(Publisher<? extends CharSequence> contentPublisher, Clob clob) {
        OracleClob oracleClob = this.castAsType(clob, OracleClob.class);
        CompletionSubscriber outcomeSubscriber = new CompletionSubscriber();
        Flow.Subscriber clobSubscriber = OracleR2dbcExceptions.fromJdbc(() -> oracleClob.subscriberOracle(1L, (Flow.Subscriber)outcomeSubscriber));
        return this.adaptFlowPublisher(() -> {
            Flux.from((Publisher)contentPublisher).map(CharSequence::toString).subscribe(FlowAdapters.toSubscriber((Flow.Subscriber)clobSubscriber));
            return FlowAdapters.toFlowPublisher(outcomeSubscriber.publish());
        });
    }

    @Override
    public Publisher<Void> publishBlobFree(Blob blob) throws R2dbcException {
        OracleBlob oracleBlob = this.castAsType(blob, OracleBlob.class);
        return this.adaptFlowPublisher(() -> ((OracleBlob)oracleBlob).freeAsyncOracle());
    }

    @Override
    public Publisher<Void> publishClobFree(Clob clob) throws R2dbcException {
        OracleClob oracleClob = this.castAsType(clob, OracleClob.class);
        return this.adaptFlowPublisher(() -> ((OracleClob)oracleClob).freeAsyncOracle());
    }

    private <T> Publisher<T> adaptFlowPublisher(OracleR2dbcExceptions.JdbcSupplier<Flow.Publisher<? extends T>> publisherSupplier) {
        return this.asyncLock.lock(Flux.from(OracleReactiveJdbcAdapter.deferOnce(publisherSupplier)).onErrorMap(SQLException.class, OracleR2dbcExceptions::toR2dbcException));
    }

    private static <T> Publisher<T> deferOnce(OracleR2dbcExceptions.JdbcSupplier<Flow.Publisher<? extends T>> publisherSupplier) {
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        CompletableFuture publisherFuture = new CompletableFuture();
        return subscriber -> {
            Objects.requireNonNull(subscriber, "Subscriber is null");
            if (isSubscribed.compareAndSet(false, true)) {
                Publisher publisher2;
                try {
                    publisher2 = FlowAdapters.toPublisher((Flow.Publisher)((Flow.Publisher)OracleR2dbcExceptions.fromJdbc(publisherSupplier)));
                }
                catch (R2dbcException r2dbcException) {
                    publisher2 = Mono.error((Throwable)r2dbcException);
                }
                publisher2.subscribe(subscriber);
                publisherFuture.complete(publisher2);
            } else {
                publisherFuture.thenAccept(publisher -> publisher.subscribe(subscriber));
            }
        };
    }

    private OracleDataSource unwrapOracleDataSource(DataSource dataSource) {
        return OracleR2dbcExceptions.fromJdbc(() -> dataSource.unwrap(OracleDataSource.class));
    }

    private OracleConnection unwrapOracleConnection(Connection connection) {
        return OracleR2dbcExceptions.fromJdbc(() -> connection.unwrap(OracleConnection.class));
    }

    private OraclePreparedStatement unwrapOraclePreparedStatement(PreparedStatement preparedStatement) {
        return OracleR2dbcExceptions.fromJdbc(() -> preparedStatement.unwrap(OraclePreparedStatement.class));
    }

    private OracleResultSet unwrapOracleResultSet(ResultSet resultSet) {
        return OracleR2dbcExceptions.fromJdbc(() -> resultSet.unwrap(OracleResultSet.class));
    }

    private <T> T castAsType(Object object, Class<T> type) {
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        throw OracleR2dbcExceptions.newNonTransientException(object.getClass() + " is not an instance of " + type, null, null);
    }

    private static boolean isTypeConversionError(int errorCode) {
        return errorCode == 17004;
    }

    private static final class CompletionSubscriber<T>
    implements Flow.Subscriber<T> {
        private final CompletableFuture<Flow.Subscription> subscriptionFuture = new CompletableFuture();
        private final CompletableFuture<Void> resultFuture = new CompletableFuture();

        private CompletionSubscriber() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscriptionFuture.complete(Objects.requireNonNull(subscription));
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
        }

        @Override
        public void onError(Throwable throwable) {
            this.resultFuture.completeExceptionally(Objects.requireNonNull(throwable));
        }

        @Override
        public void onComplete() {
            this.resultFuture.complete(null);
        }

        Publisher<Void> publish() {
            return Mono.fromCompletionStage(this.resultFuture).doOnCancel(() -> this.subscriptionFuture.thenAccept(Flow.Subscription::cancel));
        }
    }

    private static final class OracleJdbcReadable
    implements ReactiveJdbcAdapter.JdbcReadable {
        private final OracleRow oracleRow;

        private OracleJdbcReadable(OracleRow oracleRow) {
            this.oracleRow = oracleRow;
        }

        public <U> U getObject(int index, Class<U> type) {
            try {
                return (U)this.oracleRow.getObject(index + 1, type);
            }
            catch (SQLException sqlException) {
                if (sqlException.getErrorCode() == 18711) {
                    throw new IllegalStateException(sqlException);
                }
                if (OracleReactiveJdbcAdapter.isTypeConversionError(sqlException.getErrorCode())) {
                    throw new IllegalArgumentException(sqlException);
                }
                throw OracleR2dbcExceptions.toR2dbcException(sqlException);
            }
        }
    }
}

