/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.OutParametersMetadata;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Type;
import java.nio.ByteBuffer;
import java.sql.NClob;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.NoSuchElementException;
import oracle.r2dbc.OracleR2dbcTypes;
import oracle.r2dbc.impl.OracleLargeObjects;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import oracle.r2dbc.impl.ReadablesMetadata;

class OracleReadableImpl
implements Readable {
    private final ReactiveJdbcAdapter adapter;
    private final ReactiveJdbcAdapter.JdbcReadable jdbcReadable;
    private final ReadablesMetadata<?> readablesMetadata;

    private OracleReadableImpl(ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata<?> readablesMetadata, ReactiveJdbcAdapter adapter) {
        this.jdbcReadable = jdbcReadable;
        this.readablesMetadata = readablesMetadata;
        this.adapter = adapter;
    }

    static Row createRow(ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata.RowMetadataImpl metadata, ReactiveJdbcAdapter adapter) {
        return new RowImpl(jdbcReadable, metadata, adapter);
    }

    static OutParameters createOutParameters(ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata.OutParametersMetadataImpl metadata, ReactiveJdbcAdapter adapter) {
        return new OutParametersImpl(jdbcReadable, metadata, adapter);
    }

    public <T> T get(int index, Class<T> type) {
        OracleR2dbcExceptions.requireNonNull(type, "type must not be null");
        this.requireValidIndex(index);
        return this.convert(index, type);
    }

    public <T> T get(String name, Class<T> type) {
        OracleR2dbcExceptions.requireNonNull(name, "name must not be null");
        OracleR2dbcExceptions.requireNonNull(type, "type must not be null");
        return this.convert(this.indexOf(name), type);
    }

    private int indexOf(String name) {
        int columnIndex = this.readablesMetadata.getColumnIndex(name);
        if (columnIndex != -1) {
            return columnIndex;
        }
        throw new NoSuchElementException("Unrecognized name: " + name);
    }

    private <T> T convert(int index, Class<T> type) {
        Class defaultType;
        Object value = ByteBuffer.class.equals(type) ? this.getByteBuffer(index) : (Blob.class.equals(type) ? this.getBlob(index) : (Clob.class.equals(type) ? this.getClob(index) : (LocalDateTime.class.equals(type) ? this.getLocalDateTime(index) : (Object.class.equals(type) ? (Object.class.equals((Object)(defaultType = this.readablesMetadata.get(index).getJavaType())) ? this.jdbcReadable.getObject(index, Object.class) : this.convert(index, defaultType)) : this.jdbcReadable.getObject(index, type)))));
        return type.cast(value);
    }

    private ByteBuffer getByteBuffer(int index) {
        byte[] columnValue = this.jdbcReadable.getObject(index, byte[].class);
        return columnValue == null ? null : ByteBuffer.wrap(columnValue);
    }

    private Blob getBlob(int index) {
        java.sql.Blob jdbcBlob = this.jdbcReadable.getObject(index, java.sql.Blob.class);
        return jdbcBlob == null ? null : OracleLargeObjects.createBlob(this.adapter.publishBlobRead(jdbcBlob), this.adapter.publishBlobFree(jdbcBlob));
    }

    private Clob getClob(int index) {
        Type type = this.readablesMetadata.get(index).getType();
        java.sql.Clob jdbcClob = R2dbcType.NCLOB.equals((Object)type) || R2dbcType.NVARCHAR.equals((Object)type) || R2dbcType.NCHAR.equals((Object)type) ? (java.sql.Clob)this.jdbcReadable.getObject(index, NClob.class) : this.jdbcReadable.getObject(index, java.sql.Clob.class);
        return jdbcClob == null ? null : OracleLargeObjects.createClob(this.adapter.publishClobRead(jdbcClob), this.adapter.publishClobFree(jdbcClob));
    }

    private LocalDateTime getLocalDateTime(int index) {
        if (OracleR2dbcTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(this.readablesMetadata.get(index).getType())) {
            Timestamp timestamp = this.jdbcReadable.getObject(index, Timestamp.class);
            return timestamp == null ? null : timestamp.toLocalDateTime();
        }
        return this.jdbcReadable.getObject(index, LocalDateTime.class);
    }

    private void requireValidIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index is less than zero: " + index);
        }
        if (index >= this.readablesMetadata.getList().size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is greater than or equal to column count: " + this.readablesMetadata.getList().size());
        }
    }

    private static final class OutParametersImpl
    extends OracleReadableImpl
    implements OutParameters {
        private final OutParametersMetadata metadata;

        private OutParametersImpl(ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata.OutParametersMetadataImpl metadata, ReactiveJdbcAdapter adapter) {
            super(jdbcReadable, metadata, adapter);
            this.metadata = metadata;
        }

        public OutParametersMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static final class RowImpl
    extends OracleReadableImpl
    implements Row {
        private final RowMetadata metadata;

        private RowImpl(ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata.RowMetadataImpl metadata, ReactiveJdbcAdapter adapter) {
            super(jdbcReadable, metadata, adapter);
            this.metadata = metadata;
        }

        public RowMetadata getMetadata() {
            return this.metadata;
        }
    }
}

