/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Clob;
import io.r2dbc.spi.OutParameterMetadata;
import io.r2dbc.spi.Parameter;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.Type;
import java.nio.ByteBuffer;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleReadableImpl;
import oracle.r2dbc.impl.OracleReadableMetadataImpl;
import oracle.r2dbc.impl.OracleResultImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import oracle.r2dbc.impl.ReadablesMetadata;
import oracle.r2dbc.impl.SqlParameterParser;
import oracle.r2dbc.impl.SqlTypeMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class OracleStatementImpl
implements Statement {
    private static final Object NULL_BIND = new Object();
    private final Connection jdbcConnection;
    private final ReactiveJdbcAdapter adapter;
    private final String sql;
    private final int timeout;
    private final List<String> parameterNames;
    private final Object[] bindValues;
    private Queue<Object[]> batch = new LinkedList<Object[]>();
    private int fetchSize = 0;
    private String[] generatedColumns = null;

    OracleStatementImpl(String sql, Duration timeout, Connection jdbcConnection, ReactiveJdbcAdapter adapter) {
        this.sql = sql;
        this.jdbcConnection = jdbcConnection;
        this.adapter = adapter;
        this.parameterNames = SqlParameterParser.parse(sql);
        this.bindValues = new Object[this.parameterNames.size()];
        this.timeout = (int)Math.min(Integer.MAX_VALUE, timeout.toSeconds() + (long)(timeout.getNano() == 0 ? 0 : 1));
    }

    public Statement bind(int index, Object value) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(value, "value is null");
        this.requireValidIndex(index);
        this.bindObject(index, value);
        return this;
    }

    public Statement bind(String identifier, Object value) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(identifier, "identifier is null");
        OracleR2dbcExceptions.requireNonNull(value, "value is null");
        this.bindNamedParameter(identifier, value);
        return this;
    }

    public Statement bindNull(int index, Class<?> type) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(type, "type is null");
        this.requireValidIndex(index);
        this.bindObject(index, null);
        return this;
    }

    public Statement bindNull(String identifier, Class<?> type) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(identifier, "identifier is null");
        OracleR2dbcExceptions.requireNonNull(type, "type is null");
        this.bindNamedParameter(identifier, null);
        return this;
    }

    public Statement add() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        this.addBatchValues();
        return this;
    }

    public Statement returnGeneratedValues(String ... columns) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(columns, "Column names are null");
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != null) continue;
            throw new IllegalArgumentException("Null column name at index: " + i);
        }
        if (this.isOutParameterPresent()) {
            throw OracleStatementImpl.outParameterWithGeneratedValues();
        }
        if (!this.batch.isEmpty()) {
            throw OracleStatementImpl.generatedValuesWithBatch();
        }
        this.generatedColumns = (String[])columns.clone();
        return this;
    }

    public Statement fetchSize(int rows) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        if (rows < 0) {
            throw new IllegalArgumentException("Fetch size is less than zero: " + rows);
        }
        this.fetchSize = rows;
        return this;
    }

    public Publisher<OracleResultImpl> execute() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        Publisher<JdbcStatement> statementPublisher = !this.batch.isEmpty() ? this.createJdbcBatch() : (this.isOutParameterPresent() ? this.createJdbcCall() : (this.generatedColumns != null ? this.createJdbcReturningGenerated() : this.createJdbcStatement()));
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        return Flux.defer(() -> {
            if (isSubscribed.compareAndSet(false, true)) {
                return Mono.from((Publisher)statementPublisher).flatMapMany(JdbcStatement::execute);
            }
            return Mono.error((Throwable)new IllegalStateException("Multiple subscribers are not supported by the Oracle R2DBC Statement.execute() publisher"));
        });
    }

    private Publisher<JdbcStatement> createJdbcStatement() {
        int currentFetchSize = this.fetchSize;
        Object[] currentBinds = this.transferBinds();
        return this.adapter.getLock().get(() -> {
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(this.sql);
            preparedStatement.setFetchSize(currentFetchSize);
            preparedStatement.setQueryTimeout(this.timeout);
            return new JdbcStatement(preparedStatement, currentBinds);
        });
    }

    private Publisher<JdbcStatement> createJdbcBatch() {
        IllegalStateException invalidBinds;
        try {
            this.add();
            invalidBinds = null;
        }
        catch (IllegalStateException illegalStateException) {
            invalidBinds = illegalStateException;
        }
        IllegalStateException finalInvalidBinds = invalidBinds;
        int currentFetchSize = this.fetchSize;
        Queue<Object[]> currentBatch = this.batch;
        this.batch = new LinkedList<Object[]>();
        return this.adapter.getLock().get(() -> {
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(this.sql);
            preparedStatement.setFetchSize(currentFetchSize);
            preparedStatement.setQueryTimeout(this.timeout);
            return finalInvalidBinds == null ? new JdbcBatch(preparedStatement, currentBatch) : new JdbcBatchInvalidBinds(preparedStatement, currentBatch, finalInvalidBinds);
        });
    }

    private Publisher<JdbcStatement> createJdbcCall() {
        int currentFetchSize = this.fetchSize;
        Object[] currentBinds = this.transferBinds();
        return this.adapter.getLock().get(() -> {
            CallableStatement callableStatement = this.jdbcConnection.prepareCall(this.sql);
            callableStatement.setFetchSize(currentFetchSize);
            callableStatement.setQueryTimeout(this.timeout);
            return new JdbcCall(callableStatement, currentBinds, this.parameterNames);
        });
    }

    private Publisher<JdbcStatement> createJdbcReturningGenerated() {
        int currentFetchSize = this.fetchSize;
        Object[] currentBinds = this.transferBinds();
        String[] currentGeneratedColumns = (String[])this.generatedColumns.clone();
        return this.adapter.getLock().get(() -> {
            PreparedStatement preparedStatement = currentGeneratedColumns.length == 0 ? this.jdbcConnection.prepareStatement(this.sql, 1) : this.jdbcConnection.prepareStatement(this.sql, currentGeneratedColumns);
            preparedStatement.setFetchSize(currentFetchSize);
            preparedStatement.setQueryTimeout(this.timeout);
            return new JdbcReturningGenerated(preparedStatement, currentBinds);
        });
    }

    private void bindNamedParameter(String name, Object value) {
        boolean isMatched = false;
        for (int i = 0; i < this.parameterNames.size(); ++i) {
            if (!name.equals(this.parameterNames.get(i))) continue;
            isMatched = true;
            this.bindObject(i, value);
        }
        if (!isMatched) {
            throw new NoSuchElementException("Unrecognized parameter identifier: " + name);
        }
    }

    private void bindObject(int index, Object object) {
        if (object == null) {
            this.bindValues[index] = NULL_BIND;
        } else if (object instanceof Parameter) {
            this.bindParameter(index, (Parameter)object);
        } else {
            if (object instanceof Parameter.In || object instanceof Parameter.Out) {
                throw new IllegalArgumentException("Parameter.In and Parameter.Out bind values must implement Parameter");
            }
            OracleStatementImpl.requireSupportedJavaType(object);
            this.bindValues[index] = object;
        }
    }

    private void bindParameter(int index, Parameter parameter) {
        Type r2dbcType;
        SQLType jdbcType;
        if (parameter instanceof Parameter.Out) {
            if (!this.batch.isEmpty()) {
                throw OracleStatementImpl.outParameterWithBatch();
            }
            if (this.generatedColumns != null) {
                throw OracleStatementImpl.outParameterWithGeneratedValues();
            }
        }
        if ((jdbcType = SqlTypeMap.toJdbcType(r2dbcType = OracleR2dbcExceptions.requireNonNull(parameter.getType(), "Parameter type is null"))) == null) {
            throw new IllegalArgumentException("Unsupported SQL type: " + r2dbcType);
        }
        OracleStatementImpl.requireSupportedJavaType(parameter.getValue());
        this.bindValues[index] = parameter;
    }

    private void requireValidIndex(int index) {
        if (this.parameterNames.isEmpty()) {
            throw new IndexOutOfBoundsException("Statement has no parameter markers");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Parameter index is non-positive: " + index);
        }
        if (index >= this.parameterNames.size()) {
            throw new IndexOutOfBoundsException("Parameter index is out of range: " + index + ". Largest index is: " + (this.parameterNames.size() - 1));
        }
    }

    private void addBatchValues() {
        if (this.generatedColumns != null) {
            throw OracleStatementImpl.generatedValuesWithBatch();
        }
        for (Object parameter : this.bindValues) {
            if (parameter == null) {
                throw OracleStatementImpl.parameterNotSet();
            }
            if (!(parameter instanceof Parameter.Out)) continue;
            throw OracleStatementImpl.outParameterWithBatch();
        }
        this.batch.add((Object[])this.bindValues.clone());
        Arrays.fill(this.bindValues, null);
    }

    private boolean isOutParameterPresent() {
        for (Object value : this.bindValues) {
            if (!(value instanceof Parameter.Out)) continue;
            return true;
        }
        return false;
    }

    private Object[] transferBinds() {
        this.requireAllParametersSet();
        Object[] currentBinds = (Object[])this.bindValues.clone();
        Arrays.fill(this.bindValues, null);
        return currentBinds;
    }

    private void requireAllParametersSet() {
        for (Object parameter : this.bindValues) {
            if (parameter != null) continue;
            throw OracleStatementImpl.parameterNotSet();
        }
    }

    private static IllegalStateException parameterNotSet() {
        return new IllegalStateException("One or more parameters are not set");
    }

    private static void requireSupportedJavaType(Object object) {
        if (object != null && SqlTypeMap.toJdbcType(object.getClass()) == null) {
            throw new IllegalArgumentException("Unsupported Java type:" + object.getClass());
        }
    }

    private static IllegalStateException outParameterWithGeneratedValues() {
        return new IllegalStateException("Statement can not return both out-parameters and generated values");
    }

    private static IllegalStateException outParameterWithBatch() {
        return new IllegalStateException("Batch execution with out parameters is not supported");
    }

    private static IllegalStateException generatedValuesWithBatch() {
        return new IllegalStateException("Batch execution returning generated values is not supported");
    }

    private final class JdbcReturningGenerated
    extends JdbcStatement {
        private JdbcReturningGenerated(PreparedStatement preparedStatement, Object[] binds) {
            super(preparedStatement, binds);
        }

        @Override
        protected Publisher<OracleResultImpl> executeJdbc() {
            return Mono.from(OracleStatementImpl.this.adapter.publishSQLExecution(this.preparedStatement)).flatMapMany(isResultSet -> {
                if (isResultSet.booleanValue()) {
                    return super.getResults(true);
                }
                return OracleStatementImpl.this.adapter.getLock().flatMap(() -> {
                    ResultSet generatedKeys = this.preparedStatement.getGeneratedKeys();
                    if (generatedKeys.isBeforeFirst()) {
                        return Mono.just((Object)OracleResultImpl.createGeneratedValuesResult(this.preparedStatement.getLargeUpdateCount(), generatedKeys, OracleStatementImpl.this.adapter)).concatWith(super.getResults(this.preparedStatement.getMoreResults(2)));
                    }
                    return super.getResults(false);
                });
            });
        }
    }

    private final class JdbcBatchInvalidBinds
    extends JdbcBatch {
        private final IllegalStateException missingBinds;

        private JdbcBatchInvalidBinds(PreparedStatement preparedStatement, Queue<Object[]> batch, IllegalStateException missingBinds) {
            super(preparedStatement, batch);
            this.missingBinds = missingBinds;
        }

        @Override
        protected Publisher<OracleResultImpl> executeJdbc() {
            return Flux.from(super.executeJdbc()).concatWithValues((Object[])new OracleResultImpl[]{OracleResultImpl.createErrorResult((R2dbcException)OracleR2dbcExceptions.newNonTransientException("One or more binds not set after calling add()", OracleStatementImpl.this.sql, this.missingBinds))});
        }
    }

    private class JdbcBatch
    extends JdbcStatement {
        private final Queue<Object[]> batch;
        private final int batchSize;

        private JdbcBatch(PreparedStatement preparedStatement, Queue<Object[]> batch) {
            super(preparedStatement, null);
            this.batch = batch;
            this.batchSize = batch.size();
        }

        @Override
        protected Publisher<Void> bind() {
            Publisher[] bindPublishers = new Publisher[this.batchSize];
            for (int i = 0; i < this.batchSize; ++i) {
                Publisher[] publisherArray = new Publisher[2];
                publisherArray[0] = this.bind(this.batch.remove());
                publisherArray[1] = OracleStatementImpl.this.adapter.getLock().run(this.preparedStatement::addBatch);
                bindPublishers[i] = Flux.concat((Publisher[])publisherArray);
            }
            return Flux.concat((Publisher[])bindPublishers);
        }

        @Override
        protected Publisher<OracleResultImpl> executeJdbc() {
            AtomicInteger index = new AtomicInteger(0);
            return Flux.from(OracleStatementImpl.this.adapter.publishBatchUpdate(this.preparedStatement)).collect(() -> new long[this.batchSize], (updateCounts, updateCount) -> {
                updateCounts[index.getAndIncrement()] = updateCount;
            }).map(OracleResultImpl::createBatchUpdateResult).onErrorResume(error -> error instanceof R2dbcException && error.getCause() instanceof BatchUpdateException, error -> Mono.just((Object)OracleResultImpl.createBatchUpdateErrorResult((BatchUpdateException)error.getCause())));
        }
    }

    private class JdbcCall
    extends JdbcStatement {
        private final int[] outBindIndexes;
        private final ReadablesMetadata.OutParametersMetadataImpl metadata;

        private JdbcCall(CallableStatement callableStatement, Object[] bindValues, List<String> parameterNames) {
            super(callableStatement, bindValues);
            this.outBindIndexes = IntStream.range(0, bindValues.length).filter(i -> bindValues[i] instanceof Parameter.Out).toArray();
            OutParameterMetadata[] metadataArray = new OutParameterMetadata[this.outBindIndexes.length];
            for (int i2 = 0; i2 < metadataArray.length; ++i2) {
                int bindIndex = this.outBindIndexes[i2];
                String name = Objects.requireNonNullElse(parameterNames.get(bindIndex), String.valueOf(i2));
                metadataArray[i2] = OracleReadableMetadataImpl.createParameterMetadata(name, ((Parameter)bindValues[bindIndex]).getType());
            }
            this.metadata = ReadablesMetadata.createOutParametersMetadata(metadataArray);
        }

        @Override
        protected Publisher<Void> bind() {
            return Flux.concat((Publisher[])new Publisher[]{super.bind(), this.registerOutParameters()});
        }

        private Publisher<Void> registerOutParameters() {
            return OracleStatementImpl.this.adapter.getLock().run(() -> {
                CallableStatement callableStatement = this.preparedStatement.unwrap(CallableStatement.class);
                for (int i : this.outBindIndexes) {
                    Type type = ((Parameter)this.binds[i]).getType();
                    SQLType jdbcType = SqlTypeMap.toJdbcType(type);
                    callableStatement.registerOutParameter(i + 1, jdbcType);
                }
            });
        }

        @Override
        protected Publisher<OracleResultImpl> executeJdbc() {
            return Flux.concat((Publisher[])new Publisher[]{super.executeJdbc(), Mono.just((Object)OracleResultImpl.createCallResult(OracleReadableImpl.createOutParameters(new JdbcOutParameters(), this.metadata, OracleStatementImpl.this.adapter), OracleStatementImpl.this.adapter))});
        }

        private final class JdbcOutParameters
        implements ReactiveJdbcAdapter.JdbcReadable {
            private JdbcOutParameters() {
            }

            @Override
            public <T> T getObject(int index, Class<T> type) {
                return (T)OracleR2dbcExceptions.fromJdbc(() -> JdbcCall.this.preparedStatement.unwrap(CallableStatement.class).getObject(JdbcCall.this.outBindIndexes[index] + 1, type));
            }
        }
    }

    private class JdbcStatement {
        protected final PreparedStatement preparedStatement;
        protected final Object[] binds;
        private Publisher<Void> deallocators = Mono.empty();

        private JdbcStatement(PreparedStatement preparedStatement, Object[] binds) {
            this.preparedStatement = preparedStatement;
            this.binds = binds;
        }

        final Publisher<OracleResultImpl> execute() {
            return Flux.usingWhen((Publisher)Mono.just(new ArrayList(1)), results -> Mono.from(this.bind()).thenMany(this.executeJdbc()).map(this::getWarnings).doOnNext(results::add).onErrorResume(R2dbcException.class, r2dbcException -> Mono.just((Object)OracleResultImpl.createErrorResult(r2dbcException))), this::deallocate);
        }

        protected Publisher<Void> bind() {
            return this.bind(this.binds);
        }

        protected final Publisher<Void> bind(Object[] binds) {
            return OracleStatementImpl.this.adapter.getLock().flatMap(() -> {
                LinkedList<Mono> bindPublishers = null;
                for (int i = 0; i < binds.length; ++i) {
                    SQLType jdbcType;
                    if (binds[i] instanceof Parameter.Out && !(binds[i] instanceof Parameter.In)) continue;
                    Object jdbcValue = this.convertBind(binds[i]);
                    SQLType sQLType = jdbcType = binds[i] instanceof Parameter ? SqlTypeMap.toJdbcType(((Parameter)binds[i]).getType()) : null;
                    if (jdbcValue instanceof Publisher) {
                        int indexFinal = i;
                        Mono bindPublisher = Mono.from((Publisher)((Publisher)jdbcValue)).doOnSuccess(allocatedValue -> this.setBind(indexFinal, allocatedValue, jdbcType)).then();
                        if (bindPublishers == null) {
                            bindPublishers = new LinkedList<Mono>();
                        }
                        bindPublishers.add(bindPublisher);
                        continue;
                    }
                    this.setBind(i, jdbcValue, jdbcType);
                }
                return bindPublishers == null ? Mono.empty() : Flux.concat(bindPublishers);
            });
        }

        protected Publisher<OracleResultImpl> executeJdbc() {
            return Mono.from(OracleStatementImpl.this.adapter.publishSQLExecution(this.preparedStatement)).flatMapMany(this::getResults);
        }

        protected final Publisher<OracleResultImpl> getResults(boolean isResultSet) {
            return OracleStatementImpl.this.adapter.getLock().flatMap(() -> {
                OracleResultImpl result = this.getCurrentResult(isResultSet);
                OracleResultImpl nextResult = this.getCurrentResult(this.preparedStatement.getMoreResults(2));
                if (nextResult == null) {
                    return Mono.justOrEmpty((Object)result);
                }
                ArrayList<OracleResultImpl> results = new ArrayList<OracleResultImpl>();
                if (result != null) {
                    results.add(result);
                }
                while (nextResult != null) {
                    results.add(nextResult);
                    nextResult = this.getCurrentResult(this.preparedStatement.getMoreResults(2));
                }
                return Flux.fromIterable(results);
            });
        }

        protected void addDeallocation(Publisher<Void> publisher) {
            this.deallocators = Flux.concatDelayError((Publisher[])new Publisher[]{this.deallocators, publisher});
        }

        private OracleResultImpl getCurrentResult(boolean isResultSet) {
            return OracleR2dbcExceptions.fromJdbc(() -> {
                if (isResultSet) {
                    return OracleResultImpl.createQueryResult(this.preparedStatement.getResultSet(), OracleStatementImpl.this.adapter);
                }
                long updateCount = this.preparedStatement.getLargeUpdateCount();
                return updateCount >= 0L ? OracleResultImpl.createUpdateCountResult(updateCount) : null;
            });
        }

        private OracleResultImpl getWarnings(OracleResultImpl result) {
            return OracleR2dbcExceptions.fromJdbc(() -> {
                SQLWarning warning = this.preparedStatement.getWarnings();
                this.preparedStatement.clearWarnings();
                return warning == null ? result : OracleResultImpl.createWarningResult(warning, result);
            });
        }

        private Publisher<Void> deallocate(Collection<OracleResultImpl> results) {
            AtomicInteger unconsumed = new AtomicInteger(results.size());
            Publisher<Void> closeStatement = OracleStatementImpl.this.adapter.getLock().run(() -> {
                if (unconsumed.decrementAndGet() == 0) {
                    this.preparedStatement.close();
                }
            });
            for (OracleResultImpl result : results) {
                if (result.onConsumed(closeStatement)) continue;
                unconsumed.decrementAndGet();
            }
            if (unconsumed.get() == 0) {
                this.addDeallocation(OracleStatementImpl.this.adapter.getLock().run(this.preparedStatement::close));
            }
            return this.deallocators;
        }

        private void setBind(int index, Object value, SQLType type) {
            OracleR2dbcExceptions.runJdbc(() -> {
                int jdbcIndex = index + 1;
                if (type != null) {
                    this.preparedStatement.setObject(jdbcIndex, value, type);
                } else {
                    this.preparedStatement.setObject(jdbcIndex, value);
                }
            });
        }

        private Object convertBind(Object value) {
            if (value == null || value == NULL_BIND) {
                return null;
            }
            if (value instanceof Parameter) {
                return this.convertBind(((Parameter)value).getValue());
            }
            if (value instanceof io.r2dbc.spi.Blob) {
                return this.convertBlobBind((io.r2dbc.spi.Blob)value);
            }
            if (value instanceof Clob) {
                return this.convertClobBind((Clob)value);
            }
            if (value instanceof ByteBuffer) {
                return this.convertByteBufferBind((ByteBuffer)value);
            }
            return value;
        }

        private Publisher<Blob> convertBlobBind(io.r2dbc.spi.Blob r2dbcBlob) {
            return Mono.usingWhen(OracleStatementImpl.this.adapter.getLock().get(OracleStatementImpl.this.jdbcConnection::createBlob), jdbcBlob -> Mono.from(OracleStatementImpl.this.adapter.publishBlobWrite((Publisher<ByteBuffer>)r2dbcBlob.stream(), (Blob)jdbcBlob)).thenReturn(jdbcBlob), jdbcBlob -> {
                this.addDeallocation(OracleStatementImpl.this.adapter.publishBlobFree((Blob)jdbcBlob));
                return r2dbcBlob.discard();
            });
        }

        private Publisher<java.sql.Clob> convertClobBind(Clob r2dbcClob) {
            return Mono.usingWhen(OracleStatementImpl.this.adapter.getLock().get(OracleStatementImpl.this.jdbcConnection::createNClob), jdbcClob -> Mono.from(OracleStatementImpl.this.adapter.publishClobWrite((Publisher<? extends CharSequence>)r2dbcClob.stream(), (java.sql.Clob)jdbcClob)).thenReturn(jdbcClob), jdbcClob -> {
                this.addDeallocation(OracleStatementImpl.this.adapter.publishClobFree((java.sql.Clob)jdbcClob));
                return r2dbcClob.discard();
            });
        }

        private byte[] convertByteBufferBind(ByteBuffer byteBuffer) {
            ByteBuffer slice = byteBuffer.slice();
            byte[] byteArray = new byte[slice.remaining()];
            slice.get(byteArray);
            return byteArray;
        }
    }
}

