/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.OutParameterMetadata;
import io.r2dbc.spi.OutParametersMetadata;
import io.r2dbc.spi.ReadableMetadata;
import io.r2dbc.spi.RowMetadata;
import java.sql.ResultSetMetaData;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleReadableMetadataImpl;

class ReadablesMetadata<T extends ReadableMetadata> {
    private final List<T> metadataList;
    private final Map<String, Integer> nameIndexes = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);

    private ReadablesMetadata(T[] metadatas) {
        for (int i = 0; i < metadatas.length; ++i) {
            this.nameIndexes.putIfAbsent(metadatas[i].getName(), i);
        }
        this.metadataList = List.of(metadatas);
    }

    static RowMetadataImpl createRowMetadata(ResultSetMetaData resultSetMetaData) {
        int columnCount = OracleR2dbcExceptions.fromJdbc(resultSetMetaData::getColumnCount);
        ColumnMetadata[] columnMetadataArray = new ColumnMetadata[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnMetadataArray[i] = OracleReadableMetadataImpl.createColumnMetadata(resultSetMetaData, i);
        }
        return new RowMetadataImpl(columnMetadataArray);
    }

    static OutParametersMetadataImpl createOutParametersMetadata(OutParameterMetadata[] metadata) {
        return new OutParametersMetadataImpl(metadata);
    }

    protected final T get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index >= this.metadataList.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " exceeds the maximum index: " + this.metadataList.size());
        }
        return (T)((ReadableMetadata)this.metadataList.get(index));
    }

    protected final T get(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name is null");
        int index = this.getColumnIndex(name);
        if (index == -1) {
            throw new NoSuchElementException("No column found with name: " + name);
        }
        return (T)((ReadableMetadata)this.metadataList.get(index));
    }

    protected final List<T> getList() {
        return this.metadataList;
    }

    final int getColumnIndex(String name) {
        Integer index = this.nameIndexes.get(name);
        return index == null ? -1 : index;
    }

    static final class OutParametersMetadataImpl
    extends ReadablesMetadata<OutParameterMetadata>
    implements OutParametersMetadata {
        private OutParametersMetadataImpl(OutParameterMetadata[] columnMetadata) {
            super((ReadableMetadata[])columnMetadata);
        }

        public OutParameterMetadata getParameterMetadata(int index) {
            return (OutParameterMetadata)this.get(index);
        }

        public OutParameterMetadata getParameterMetadata(String name) {
            return (OutParameterMetadata)this.get(name);
        }

        public List<? extends OutParameterMetadata> getParameterMetadatas() {
            return this.getList();
        }
    }

    static final class RowMetadataImpl
    extends ReadablesMetadata<ColumnMetadata>
    implements RowMetadata {
        private RowMetadataImpl(ColumnMetadata[] columnMetadata) {
            super((ReadableMetadata[])columnMetadata);
        }

        public ColumnMetadata getColumnMetadata(int index) {
            return (ColumnMetadata)this.get(index);
        }

        public ColumnMetadata getColumnMetadata(String name) {
            return (ColumnMetadata)this.get(name);
        }

        public List<? extends ColumnMetadata> getColumnMetadatas() {
            return this.getList();
        }

        public boolean contains(String columnName) {
            return this.getColumnIndex(columnName) != -1;
        }
    }
}

