/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import java.util.ArrayList;
import java.util.List;

final class SqlParameterParser {
    private SqlParameterParser() {
    }

    static List<String> parse(String sql) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        int i = 0;
        block10: while (i < sql.length()) {
            switch (sql.charAt(i)) {
                case '-': {
                    i = SqlParameterParser.parseCommentLine(sql, i);
                    continue block10;
                }
                case '/': {
                    i = SqlParameterParser.parseCommentBlock(sql, i);
                    continue block10;
                }
                case '\'': {
                    i = SqlParameterParser.parseSingleQuote(sql, i);
                    continue block10;
                }
                case '\"': {
                    i = SqlParameterParser.parseDoubleQuote(sql, i);
                    continue block10;
                }
                case 'Q': 
                case 'q': {
                    i = SqlParameterParser.parseAlternativeQuote(sql, i);
                    continue block10;
                }
                case '{': {
                    i = SqlParameterParser.parseEscaped(sql, i);
                    continue block10;
                }
                case '?': {
                    ++i;
                    parameterNames.add(null);
                    continue block10;
                }
                case ':': {
                    String name = SqlParameterParser.parseNamedParameter(sql, i);
                    if (name.length() == 0) {
                        ++i;
                        continue block10;
                    }
                    i += name.length();
                    parameterNames.add(name);
                    continue block10;
                }
            }
            ++i;
        }
        return parameterNames;
    }

    private static int parseEscaped(String sql, int i) {
        if (++i == sql.length() || '\\' != sql.charAt(i)) {
            return i;
        }
        ++i;
        do {
            if ((i = sql.indexOf(92, i)) < 0) {
                return sql.length();
            }
            if (++i != sql.length()) continue;
            return sql.length();
        } while ('}' != sql.charAt(i));
        return i + 1;
    }

    private static int parseAlternativeQuote(String sql, int i) {
        if (++i == sql.length() || '\'' != sql.charAt(i)) {
            return i;
        }
        if (++i == sql.length()) {
            return sql.length();
        }
        char delimiter = sql.charAt(i);
        if (delimiter == ' ' || delimiter == '\t' || delimiter == '\n') {
            return i;
        }
        char terminal = SqlParameterParser.alternateQuoteTerminal(delimiter);
        ++i;
        do {
            if ((i = sql.indexOf(terminal, i)) >= 0 && ++i != sql.length()) continue;
            return sql.length();
        } while ('\'' != sql.charAt(i));
        return i + 1;
    }

    private static char alternateQuoteTerminal(char delimiter) {
        switch (delimiter) {
            case '(': {
                return ')';
            }
            case '{': {
                return '}';
            }
            case '[': {
                return ']';
            }
            case '<': {
                return '>';
            }
        }
        return delimiter;
    }

    private static String parseNamedParameter(String sql, int i) {
        int start = ++i;
        while (i < sql.length()) {
            boolean isAlphaNumUnderscore;
            char next = sql.charAt(i);
            boolean bl = isAlphaNumUnderscore = 'a' <= next && 'z' >= next || 'A' <= next && 'Z' >= next || '0' <= next && '9' >= next || '_' == next;
            if (!isAlphaNumUnderscore) break;
            ++i;
        }
        return sql.substring(start, i);
    }

    private static int parseDoubleQuote(String sql, int i) {
        return (i = sql.indexOf(34, i + 1)) >= 0 ? i + 1 : sql.length();
    }

    private static int parseSingleQuote(String sql, int i) {
        do {
            ++i;
            if ((i = sql.indexOf(39, i)) >= 0 && ++i != sql.length()) continue;
            return sql.length();
        } while ('\'' == sql.charAt(i));
        return i;
    }

    private static int parseCommentBlock(String sql, int i) {
        if (++i == sql.length() || '*' != sql.charAt(i)) {
            return i;
        }
        ++i;
        do {
            if ((i = sql.indexOf(42, i)) >= 0 && ++i != sql.length()) continue;
            return sql.length();
        } while ('/' != sql.charAt(i));
        return i + 1;
    }

    private static int parseCommentLine(String sql, int i) {
        if (++i == sql.length() || '-' != sql.charAt(i)) {
            return i;
        }
        return (i = sql.indexOf(10, i + 1)) >= 0 ? i + 1 : sql.length();
    }
}

