/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.Cipher;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.core.DSAPrivateKey;
import oracle.security.crypto.core.ECPrivateKey;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSA;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.OracleKSEntry;
import oracle.security.pki.OracleKSIdentityEntry$1;
import oracle.security.pki.OracleKSIdentityEntry$2;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;

class OracleKSIdentityEntry
extends OracleKSEntry {
    final PKCS12Bag a;
    Certificate[] b;
    private CertificateRequest d;
    int c = -1;

    OracleKSIdentityEntry(PKCS12Bag pKCS12Bag, Vector vector) {
        byte[] byArray;
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.a = null;
        ASN1Object aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
        if (aSN1Object instanceof ASN1OctetString) {
            try {
                byArray = ((ASN1OctetString)aSN1Object).getValue();
                this.d = new CertificateRequest(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byArray = pKCS12Bag.getLocalKeyID();
        this.c = OracleLocalKeyId.l(byArray);
        Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
        byte[] byArray2 = OracleLocalKeyId.c(OracleLocalKeyId.k(byArray), OracleLocalKeyId.l(byArray));
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
            if (!this.a(pKCS12CertBag.getLocalKeyID(), byArray2)) continue;
            vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
            vector.removeElementAt(i);
            if (!OraclePKIDebug.getDebugFlag()) break;
            try {
                OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
            }
            catch (Exception exception) {
                OraclePKIDebug.a("Found certificate - Cannot be converted to string");
            }
            break;
        }
        if (vector2.size() == 0) {
            OraclePKIDebug.a("No certificate found for cert req " + byArray);
            this.b = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
                    if (!x509Certificate.getIssuerDN().equals(pKCS12CertBag.getCert().getSubject())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("Cert chain incomplete for key " + this.a);
                break;
            }
            OraclePKIDebug.a("Cert chain determined");
            this.b = new Certificate[vector2.size()];
            this.b = vector2.toArray(this.b);
        }
    }

    OracleKSIdentityEntry(PKCS12Bag pKCS12Bag, Vector vector, Vector vector2) {
        Object object;
        PKCS12CertBag pKCS12CertBag;
        int n;
        Vector<OraclePKIX509CertImpl> vector3;
        if (!(pKCS12Bag instanceof PKCS12KeyBag) && !(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.a = pKCS12Bag;
        byte[] byArray = this.a.getLocalKeyID();
        this.c = OracleLocalKeyId.l(byArray);
        byte[] byArray2 = "abcxyz".getBytes();
        byte[] byArray3 = null;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = BigInteger.TEN;
        RSA rSA = new RSA();
        String string = null;
        String string2 = null;
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        if (pKCS12Bag instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)pKCS12Bag).getPrivateKey();
        } else if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)pKCS12Bag).getPrivateKey();
        }
        string = privateKey.getAlgorithm();
        if (string.equals("RSA")) {
            vector3 = null;
            try {
                vector3 = AccessController.doPrivileged(new OracleKSIdentityEntry$1(this));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
            n = Boolean.valueOf(vector3).booleanValue();
            if (n != 0) {
                try {
                    Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                    cipher.init(1, (Key)privateKey);
                    bigInteger = new BigInteger(cipher.doFinal(bigInteger3.toByteArray()));
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (OraclePKIDebug.getDebugFlag()) {
                        generalSecurityException.printStackTrace();
                    }
                }
            } else {
                rSA.setKey((RSAKey)((RSAPrivateKey)privateKey));
                bigInteger = rSA.performOp(bigInteger3);
            }
        } else if (string.equals("EC")) {
            try {
                vector3 = Signature.getInstance("SHA1withECDSA");
                ((Signature)((Object)vector3)).initSign((java.security.PrivateKey)privateKey);
                ((Signature)((Object)vector3)).update(byArray2, 0, byArray2.length);
                byArray3 = ((Signature)((Object)vector3)).sign();
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
        vector3 = new Vector<OraclePKIX509CertImpl>(vector.size());
        for (n = 0; n < vector.size(); ++n) {
            boolean bl = false;
            pKCS12CertBag = (PKCS12CertBag)vector.elementAt(n);
            publicKey = pKCS12CertBag.getCert().getPublicKey();
            string2 = publicKey.getAlgorithm();
            if (string.equals(string2)) {
                if (string2.equals("RSA")) {
                    block44: {
                        object = null;
                        try {
                            object = AccessController.doPrivileged(new OracleKSIdentityEntry$2(this));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw new RuntimeException(privilegedActionException);
                        }
                        boolean bl2 = Boolean.valueOf((String)object);
                        if (bl2) {
                            try {
                                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                                cipher.init(2, (Key)publicKey);
                                bigInteger2 = new BigInteger(cipher.doFinal(bigInteger.toByteArray()));
                                break block44;
                            }
                            catch (GeneralSecurityException generalSecurityException) {
                                if (!OraclePKIDebug.getDebugFlag()) continue;
                                generalSecurityException.printStackTrace();
                                continue;
                            }
                        }
                        rSA.setKey((RSAKey)((RSAPublicKey)publicKey));
                        bigInteger2 = rSA.performOp(bigInteger);
                    }
                    if (bigInteger2.equals(bigInteger3)) {
                        bl = true;
                    }
                } else if (string2.equals("EC")) {
                    try {
                        object = Signature.getInstance("SHA1withECDSA");
                        ((Signature)object).initVerify((java.security.PublicKey)publicKey);
                        ((Signature)object).update(byArray2, 0, byArray2.length);
                        bl = ((Signature)object).verify(byArray3);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        generalSecurityException.printStackTrace();
                    }
                }
            }
            if (this.a(pKCS12CertBag.getLocalKeyID(), byArray) && bl) {
                vector3.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                vector.removeElementAt(n);
                if (!OraclePKIDebug.getDebugFlag()) break;
                try {
                    OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
                }
                catch (Exception exception) {
                    OraclePKIDebug.a("Found certificate - Cannot be converted to string");
                }
                break;
            }
            if (!OracleLocalKeyId.j(byArray)) {
                if (!bl) continue;
                vector3.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                vector.removeElementAt(n);
                if (!OraclePKIDebug.getDebugFlag()) break;
                try {
                    OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
                }
                catch (Exception exception) {
                    OraclePKIDebug.a("Found certificate - Cannot be converted to string");
                }
                break;
            }
            if (OracleLocalKeyId.d(pKCS12CertBag.getLocalKeyID()) || !bl) continue;
            vector3.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
            vector.removeElementAt(n);
            if (!OraclePKIDebug.getDebugFlag()) break;
            try {
                OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
            }
            catch (Exception exception) {
                OraclePKIDebug.a("Found certificate - Cannot be converted to string");
            }
            break;
        }
        byte[] byArray4 = OracleLocalKeyId.d(OracleLocalKeyId.k(byArray), OracleLocalKeyId.l(byArray));
        for (int i = 0; i < vector2.size(); ++i) {
            pKCS12CertBag = (PKCS12SecretBag)vector2.elementAt(i);
            if (!this.a(pKCS12CertBag.getLocalKeyID(), byArray4) || !((object = pKCS12CertBag.getSecretValue()) instanceof ASN1OctetString)) continue;
            try {
                byte[] byArray5 = ((ASN1OctetString)object).getValue();
                this.d = new CertificateRequest(byArray5);
                vector2.removeElementAt(i);
                OraclePKIDebug.a("Found cert req " + this.d);
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (vector3.size() == 0) {
            OraclePKIDebug.a("No certificate found for key " + this.a.getLocalKeyID());
            this.b = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector3.lastElement();
            while (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    PKCS12CertBag pKCS12CertBag2 = (PKCS12CertBag)vector.elementAt(i);
                    if (!x509Certificate.getIssuerDN().equals(pKCS12CertBag2.getCert().getSubject())) continue;
                    bl = true;
                    vector3.addElement(new OraclePKIX509CertImpl(pKCS12CertBag2.getCert()));
                    x509Certificate = (X509Certificate)vector3.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("Cert chain incomplete for key " + this.a);
                break;
            }
            OraclePKIDebug.a("Cert chain determined");
            this.b = new Certificate[vector3.size()];
            this.b = vector3.toArray(this.b);
        }
    }

    String a(byte[] byArray) {
        return new String("personaNum:" + OracleLocalKeyId.k(byArray) + "  componentNum:" + OracleLocalKeyId.l(byArray));
    }

    @Override
    Key a() {
        PrivateKey privateKey = null;
        if (this.a instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)this.a).getPrivateKey();
        } else if (this.a instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)this.a).getPrivateKey();
        }
        if (privateKey instanceof RSAPrivateKey) {
            return new OraclePKIRSAPrivateKey((RSAPrivateKey)privateKey, this.d);
        }
        if (privateKey instanceof ECPrivateKey) {
            return new OraclePKIECPrivateKey((ECPrivateKey)privateKey, this.d);
        }
        if (privateKey instanceof DSAPrivateKey) {
            OraclePKIDebug.a("DSA Keys not supported");
            return null;
        }
        if (this.d != null && this.a == null) {
            return new OraclePKIRSAPrivateKey(null, this.d);
        }
        return null;
    }

    @Override
    Certificate b() {
        if (this.b == null) {
            return null;
        }
        return this.b[0];
    }

    @Override
    Certificate[] c() {
        if (this.b == null) {
            return null;
        }
        return (Certificate[])this.b.clone();
    }

    @Override
    boolean e() {
        return true;
    }

    @Override
    String f() {
        String string = null;
        Certificate certificate = this.b();
        if (certificate instanceof X509Certificate) {
            OraclePKIDebug.a("Certificate for private key is " + certificate);
            X500Name x500Name = new X500Name(((X509Certificate)certificate).getSubjectDN().getName());
            string = "CN=" + x500Name.getCommonName();
            if (x500Name.getCommonName() == null) {
                string = "OU=" + x500Name.getOrgUnitName();
            }
            return string;
        }
        return "";
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    byte[] h() {
        return this.a.getLocalKeyID();
    }

    int i() {
        return this.c;
    }
}

