/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public final class IssuerAndSerialNo
implements ASN1Object,
Externalizable {
    private X500Name issuer;
    private BigInteger serialNo;
    private ASN1Sequence contents;

    public IssuerAndSerialNo() {
    }

    public IssuerAndSerialNo(X500Name issuer, BigInteger serialNo) {
        this.issuer = issuer;
        this.serialNo = serialNo;
    }

    public IssuerAndSerialNo(X509 cert) {
        this(cert.getIssuer(), cert.getSerialNo());
    }

    public IssuerAndSerialNo(InputStream is) throws IOException {
        this.input(is);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof IssuerAndSerialNo)) {
            return false;
        }
        IssuerAndSerialNo iasn = (IssuerAndSerialNo)o;
        return Utils.areEqual((byte[])this.getEncoded(), (byte[])iasn.getEncoded());
    }

    public int hashCode() {
        return new String(this.getEncoded()).hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        buf.append("issuer = ");
        buf.append(this.issuer != null ? this.issuer.toString() : "null");
        buf.append(", serialNo = ");
        buf.append(this.serialNo != null ? this.serialNo.toString() : "null");
        buf.append('}');
        return buf.toString();
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream s = new ASN1SequenceInputStream(is);
        this.issuer = new X500Name((InputStream)s);
        this.serialNo = ASN1Integer.inputValue((InputStream)s);
        s.terminate();
        this.update();
    }

    public byte[] getEncoded() {
        return Utils.toBytes((Streamable)this);
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s = new ASN1Sequence();
            s.addElement((ASN1Object)this.issuer);
            s.addElement((ASN1Object)new ASN1Integer(this.serialNo));
            this.contents = s;
        }
        return this.contents;
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

