/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509PolicyInformation;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CertificatePoliciesExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_certificatePolicies;
    private Vector certPolicies;

    public CertificatePoliciesExtension() {
        super(TYPE);
    }

    public CertificatePoliciesExtension(X509PolicyInformation policy) {
        this(policy, false);
    }

    public CertificatePoliciesExtension(X509PolicyInformation policy, boolean critical) {
        super(TYPE, critical);
        this.certPolicies = new Vector();
        this.certPolicies.addElement(policy);
        this.setValue(this.toByteArray());
    }

    public CertificatePoliciesExtension(Vector policies) {
        this(policies, false);
    }

    public CertificatePoliciesExtension(Vector policies, boolean critical) {
        super(TYPE, critical);
        this.certPolicies = policies;
        this.setValue(this.toByteArray());
    }

    public CertificatePoliciesExtension(InputStream is) throws IOException {
        super(is);
    }

    public void addCertificatePolicy(X509PolicyInformation policy) {
        if (this.certPolicies == null) {
            this.certPolicies = new Vector();
        }
        this.certPolicies.addElement(policy);
        this.setValue(this.toByteArray());
    }

    public Vector getCertificatePolicies() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certPolicies;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Sequence(this.certPolicies));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            this.certPolicies = new Vector();
            while (sis.hasMoreData()) {
                this.certPolicies.addElement(new X509PolicyInformation((InputStream)sis));
            }
            sis.terminate();
            if (this.certPolicies.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("certificatePoliciesExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCertificatePolicies() != null) {
            s.append("certificatePolicies = {");
            boolean mid = false;
            int size = this.getCertificatePolicies().size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(((X509PolicyInformation)this.getCertificatePolicies().elementAt(i)).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

