/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.OIDRegistrar;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509Extension
implements ASN1Object,
Externalizable {
    public static final ASN1ObjectID id_netscape_ce = PKIX.id_netscape_ce;
    public static final ASN1ObjectID id_netscape_ce_type = PKIX.id_netscape_ce_type;
    public static final ASN1ObjectID id_set_ce = PKIX.id_set_ce;
    public static final ASN1ObjectID id_set_ce_type = PKIX.id_set_ce_type;
    protected boolean isDecoded = false;
    private ASN1ObjectID type;
    private boolean critical;
    private byte[] value;
    private ASN1Sequence contents = null;

    public X509Extension() {
    }

    protected X509Extension(ASN1ObjectID type) {
        this(type, false);
    }

    protected X509Extension(ASN1ObjectID type, boolean critical) {
        this.type = type;
        this.critical = critical;
    }

    public X509Extension(ASN1ObjectID type, byte[] value) {
        this(type, false, value);
    }

    public X509Extension(ASN1ObjectID type, ASN1Object value) {
        this(type, false, Utils.toBytes((Streamable)value));
    }

    public X509Extension(ASN1ObjectID type, boolean critical, byte[] value) {
        this.type = type;
        this.critical = critical;
        this.value = value;
    }

    public X509Extension(ASN1ObjectID type, boolean critical, ASN1Object value) {
        this(type, critical, Utils.toBytes((Streamable)value));
    }

    public X509Extension(InputStream is) throws IOException {
        this.input(is);
    }

    public static X509Extension inputInstance(InputStream is) throws IOException {
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        ASN1ObjectID type = new ASN1ObjectID((InputStream)sis);
        boolean critical = sis.getCurrentTag() == 1 ? ASN1Boolean.inputValue((InputStream)sis) : false;
        byte[] value = ASN1OctetString.inputValue((InputStream)sis);
        sis.terminate();
        Class target = OIDManager.getOIDManager().getMapping(type, "extension");
        if (target == null) {
            return new X509Extension(type, critical, value);
        }
        X509Extension ext = null;
        try {
            ext = (X509Extension)target.newInstance();
            ext.setCritical(critical);
            ext.setValue(value);
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex.toString());
        }
        catch (InstantiationException ex) {
            throw new IOException(ex.toString());
        }
        catch (ClassCastException ex) {
            throw new IOException(ex.toString());
        }
        return ext;
    }

    public boolean isRecognized() {
        return OIDManager.getOIDManager().getMapping(this.getType(), "extension") != null;
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public boolean getCritical() {
        return this.critical;
    }

    protected void setCritical(boolean critical) {
        this.critical = critical;
        this.reset();
    }

    public byte[] getValue() {
        return this.value;
    }

    protected void setValue(byte[] value) {
        this.value = value;
        this.reset();
        this.isDecoded = false;
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)this.type);
        if (this.critical) {
            s.addElement((ASN1Object)new ASN1Boolean(this.critical));
        }
        s.addElement((ASN1Object)new ASN1OctetString(this.value));
        this.contents = s;
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    public void input(InputStream is) throws IOException {
        this.reset();
        this.isDecoded = false;
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.type = new ASN1ObjectID((InputStream)sis);
        this.critical = sis.getCurrentTag() == 1 ? ASN1Boolean.inputValue((InputStream)sis) : false;
        this.value = ASN1OctetString.inputValue((InputStream)sis);
        sis.terminate();
    }

    public int length() {
        return this.outputASN1().length();
    }

    public String toString() {
        return "oid = " + this.type + ", critical = " + this.critical + ", value = " + Utils.toHexString((byte[])this.value);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }

    static {
        OIDRegistrar.mapExtensions();
    }
}

