/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.SREntropySource;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;

public abstract class EntropySource {
    private static EntropySource a;
    private static final Object b;

    protected EntropySource() {
    }

    public abstract byte generateByte();

    public synchronized byte[] generateBytes(byte[] byArray) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.generateByte();
        }
        return byArray;
    }

    public abstract void clear();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntropySource getDefault() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (a == null) {
            Object object = b;
            synchronized (object) {
                if (a == null) {
                    a = new SREntropySource();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(EntropySource entropySource) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        Object object = b;
        synchronized (object) {
            a = entropySource;
        }
    }

    static {
        b = new Object();
        FIPS_140_2.powerUpSelfTest();
    }
}

