/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.OIDManager;

public abstract class Signature {
    protected byte[] a;
    protected byte[] b;

    protected Signature() {
    }

    public abstract void setAlgID(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    public abstract AlgorithmIdentifier getAlgID();

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        throw new IllegalStateException("Method not valid for " + this.getClass().getName());
    }

    public static Signature getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        Signature signature;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "signature");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            signature = (Signature)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Signature.");
        }
        signature.setAlgID(algorithmIdentifier);
        return signature;
    }

    public static Signature getInstance(PrivateKey privateKey) throws SignatureException {
        Signature signature;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(privateKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new SignatureException("Cannot find a signature algorithm for this key with " + privateKey.getAlgID().getOID());
        }
        try {
            signature = (Signature)clazz.newInstance();
            signature.setPrivateKey(privateKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new SignatureException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return signature;
    }

    public static Signature getInstance(PublicKey publicKey) throws AuthenticationException {
        Signature signature;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(publicKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new AuthenticationException("Can not find a signature algorithm for this key with " + publicKey.getAlgID().getOID());
        }
        try {
            signature = (Signature)clazz.newInstance();
            signature.setPublicKey(publicKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        return signature;
    }

    public abstract void setPublicKey(PublicKey var1) throws InvalidKeyException;

    public abstract void setPrivateKey(PrivateKey var1) throws InvalidKeyException;

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
    }

    public abstract byte[] sign() throws SignatureException;

    public abstract boolean verify() throws AuthenticationException;

    public void setDocument(byte[] byArray) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.setHash(null);
        this.b = byArray;
    }

    public byte[] getDocument() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public byte[] getSigBytes() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return (byte[])this.a.clone();
    }

    public void setSigBytes(byte[] byArray) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.a = byArray;
    }

    public abstract void setHash(byte[] var1);

    public abstract String algName();

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

