// Copyright (c) 2007-2020 VMware, Inc. or its affiliates.  All rights reserved.
//
// This software, the RabbitMQ Java client library, is triple-licensed under the
// Mozilla Public License 1.1 ("MPL"), the GNU General Public License version 2
// ("GPL") and the Apache License version 2 ("ASL"). For the MPL, please see
// LICENSE-MPL-RabbitMQ. For the GPL, please see LICENSE-GPL2.  For the ASL,
// please see LICENSE-APACHE2.
//
// This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
// either express or implied. See the LICENSE file for specific language governing
// rights and limitations of this software.
//
// If you have any questions regarding licensing, please contact us at
// info@rabbitmq.com.

package com.rabbitmq.client.impl.recovery;

import com.rabbitmq.client.ShutdownSignalException;

/**
 * Used internally to indicate when connection recovery can
 * begin.
 * This is package-local by design.
 *
 * @see <a href="https://github.com/rabbitmq/rabbitmq-java-client/issues/135">Issue 135 on GitHub</a>
 */
public interface RecoveryCanBeginListener {
    void recoveryCanBegin(ShutdownSignalException cause);
}
