/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.AbstractRegExFunction;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnTokenize
extends AbstractRegExFunction {
    private static Collection<SeqType> _expected_args = null;

    public FnTokenize() {
        super(new QName("tokenize"), 2, 3);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnTokenize.tokenize(args);
    }

    public static ResultSequence tokenize(Collection<ResultSequence> args) throws DynamicError {
        Collection<ResultSequence> cargs = Function.convert_arguments(args, FnTokenize.expected_args());
        ResultBuffer rs = new ResultBuffer();
        Iterator<ResultSequence> argiter = cargs.iterator();
        ResultSequence arg1 = argiter.next();
        String str1 = "";
        if (!arg1.empty()) {
            str1 = ((XSString)arg1.first()).value();
        }
        ResultSequence arg2 = argiter.next();
        String pattern = ((XSString)arg2.first()).value();
        String flags = null;
        if (argiter.hasNext()) {
            ResultSequence flagRS = null;
            flagRS = argiter.next();
            flags = flagRS.first().getStringValue();
            if ("smix".indexOf(flags) == -1 && flags.length() > 0) {
                throw DynamicError.regex_flags_error(null);
            }
        }
        try {
            ArrayList<String> ret = FnTokenize.tokenize(pattern, flags, str1);
            Iterator<String> retIter = ret.iterator();
            while (retIter.hasNext()) {
                rs.add(new XSString(retIter.next()));
            }
        }
        catch (PatternSyntaxException err) {
            throw DynamicError.regex_error(null, err);
        }
        return rs.getSequence();
    }

    private static ArrayList<String> tokenize(String pattern, String flags, String src) throws DynamicError {
        Matcher matcher = FnTokenize.regex(pattern, flags, src);
        ArrayList<String> tokens = new ArrayList<String>();
        int startpos = 0;
        int endpos = src.length();
        while (matcher.find()) {
            String delim = matcher.group();
            if (delim.length() == 0) {
                throw DynamicError.regex_match_zero_length(null);
            }
            String token = src.substring(startpos, matcher.start());
            startpos = matcher.end();
            tokens.add(token);
        }
        if (startpos < endpos) {
            String token = src.substring(startpos, endpos);
            tokens.add(token);
        }
        return tokens;
    }

    public static synchronized Collection<SeqType> expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList<SeqType>();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }
}

