/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.eclipse.wst.xml.xpath2.api.CollationProvider;
import org.eclipse.wst.xml.xpath2.api.Function;
import org.eclipse.wst.xml.xpath2.api.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.StaticVariableResolver;
import org.eclipse.wst.xml.xpath2.api.typesystem.ItemType;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.function.FnFunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.function.XSCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;
import org.w3c.dom.Node;

public class StaticContextBuilder
implements StaticContext {
    public static final String XPATH_FUNCTIONS_NS = "http://www.w3.org/2005/xpath-functions";
    private boolean _xpath1_compatible = false;
    private String _default_namespace = "";
    private String _default_function_namespace = "http://www.w3.org/2005/xpath-functions";
    private TypeDefinition _initialContextType = null;
    private String _defaultCollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private Map<String, String> _namespaces = new HashMap<String, String>();
    private Map<String, FunctionLibrary> _functionLibraries = new HashMap<String, FunctionLibrary>();
    private URI _base_uri;
    private Map<QName, ItemType> _variableTypes;
    private Map<String, Short> _variableCardinality;
    private Map<String, TypeDefinition> _collectionTypes;
    private Set<QName> _hiddenFunctions;
    private TypeModel _typeModel;
    private static Comparator<String> CODEPOINT_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    private CollationProvider _collationProvider;

    public StaticContextBuilder() {
        this._functionLibraries.put(XPATH_FUNCTIONS_NS, new FnFunctionLibrary());
        this._functionLibraries.put("http://www.w3.org/2001/XMLSchema", new XSCtrLibrary());
        this._variableTypes = new HashMap<QName, ItemType>();
        this._variableCardinality = new HashMap<String, Short>();
        this._collectionTypes = new HashMap<String, TypeDefinition>();
        this._hiddenFunctions = new HashSet<QName>();
        this._collationProvider = new CollationProvider(){

            @Override
            public String getDefaultCollation() {
                return StaticContextBuilder.this._defaultCollation;
            }

            @Override
            public Comparator<String> getCollation(String uri) {
                if ("http://www.w3.org/2005/xpath-functions/collation/codepoint".equals(uri)) {
                    return CODEPOINT_COMPARATOR;
                }
                return null;
            }
        };
    }

    @Override
    public boolean isXPath1Compatible() {
        return this._xpath1_compatible;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            @Override
            public Iterator<String> getPrefixes(String ns) {
                LinkedList prefixes = new LinkedList();
                for (Map.Entry entry : StaticContextBuilder.this._namespaces.entrySet()) {
                    if (!((String)entry.getValue()).equals(ns)) continue;
                    prefixes.add(entry.getKey());
                }
                return prefixes.iterator();
            }

            @Override
            public String getPrefix(String ns) {
                for (Map.Entry entry : StaticContextBuilder.this._namespaces.entrySet()) {
                    if (!entry.getValue().equals(ns)) continue;
                    return (String)entry.getKey();
                }
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                String ns = (String)StaticContextBuilder.this._namespaces.get(prefix);
                if (ns == null) {
                    ns = "";
                }
                return ns;
            }
        };
    }

    @Override
    public String getDefaultNamespace() {
        return this._default_namespace;
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this._default_function_namespace;
    }

    @Override
    public TypeModel getTypeModel() {
        if (this._typeModel != null) {
            return this._typeModel;
        }
        return new TypeModel(){

            @Override
            public TypeDefinition getType(Node node) {
                return null;
            }

            @Override
            public TypeDefinition lookupType(String namespace, String typeName) {
                return null;
            }

            @Override
            public TypeDefinition lookupElementDeclaration(String namespace, String elementName) {
                return null;
            }

            @Override
            public TypeDefinition lookupAttributeDeclaration(String namespace, String attributeName) {
                return null;
            }
        };
    }

    @Override
    public Function resolveFunction(QName name, int arity) {
        if (this._hiddenFunctions.contains(name)) {
            return null;
        }
        FunctionLibrary flib = this._functionLibraries.get(name.getNamespaceURI());
        if (flib != null) {
            return flib.resolveFunction(name.getLocalPart(), arity);
        }
        return null;
    }

    @Override
    public URI getBaseUri() {
        return this._base_uri;
    }

    @Override
    public Map<String, FunctionLibrary> getFunctionLibraries() {
        return this._functionLibraries;
    }

    @Override
    public TypeDefinition getCollectionType(String collectionName) {
        return this._collectionTypes.get(collectionName);
    }

    @Override
    public TypeDefinition getInitialContextType() {
        return this._initialContextType;
    }

    public StaticContextBuilder withNamespace(String prefix, String uri) {
        this._namespaces.put(prefix, uri);
        return this;
    }

    public StaticContextBuilder withDefaultNamespace(String uri) {
        this._default_namespace = uri;
        return this;
    }

    public StaticContextBuilder withXPath1Compatibility(boolean compatible) {
        this._xpath1_compatible = compatible;
        return this;
    }

    public StaticContextBuilder withTypeModel(TypeModel tm) {
        this._typeModel = tm;
        return this;
    }

    public StaticContextBuilder withoutFunction(QName functionToSuppress) {
        this._hiddenFunctions.add(functionToSuppress);
        return this;
    }

    public StaticContextBuilder withoutFunction(QName ... functionsToSuppress) {
        for (QName name : functionsToSuppress) {
            this._hiddenFunctions.add(name);
        }
        return this;
    }

    @Override
    public TypeDefinition getDefaultCollectionType() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public StaticVariableResolver getInScopeVariables() {
        return new StaticVariableResolver(){

            @Override
            public boolean isVariablePresent(QName name) {
                return StaticContextBuilder.this._variableTypes.containsKey(name);
            }

            @Override
            public ItemType getVariableType(QName name) {
                return (ItemType)StaticContextBuilder.this._variableTypes.get(name);
            }
        };
    }

    @Override
    public CollationProvider getCollationProvider() {
        return this._collationProvider;
    }

    public StaticContextBuilder withCollationProvider(CollationProvider cp) {
        this._collationProvider = cp;
        return this;
    }

    public StaticContextBuilder withVariable(QName qName, ItemType type) {
        this._variableTypes.put(qName, type);
        return this;
    }

    public StaticContextBuilder withBaseUri(String string) throws URISyntaxException {
        this._base_uri = new URI(string);
        return this;
    }

    public StaticContextBuilder withFunctionLibrary(String namespace, FunctionLibrary fl) {
        this._functionLibraries.put(namespace, fl);
        return this;
    }

    public StaticContextBuilder withDefaultCollation(String uri) {
        this._defaultCollation = uri;
        return this;
    }

    @Override
    public ItemType getDocumentType(URI documentUri) {
        return null;
    }
}

