/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.adapter.spring;

import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.SapIdToken;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityContext {
    static final Logger LOGGER = LoggerFactory.getLogger(SpringSecurityContext.class);

    private SpringSecurityContext() {
    }

    @Nullable
    public static Token getToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(authentication) && authentication.isAuthenticated()) {
            try {
                if (authentication.getDetails() != null && authentication.getDetails().getClass().getName().equals("org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails")) {
                    LOGGER.debug("Try to fetch token from deprecated Springs Auth2 client library.");
                    return SpringSecurityContext.getTokenFromDeprecatedLib(authentication);
                }
                if (authentication.getPrincipal() == null) {
                    return null;
                }
                String principalClass = authentication.getPrincipal().getClass().getName();
                LOGGER.debug("Try to fetch token from SecurityContextHolder.getPrincipal() of type {}.", (Object)authentication.getPrincipal().getClass().getName());
                if (principalClass.startsWith("com.sap.cloud.security.xsuaa.token.")) {
                    return SpringSecurityContext.getSpringXsuaaToken(authentication);
                }
                if (principalClass.startsWith("com.sap.cloud.security.token.")) {
                    return (Token)authentication.getPrincipal();
                }
                if (principalClass.startsWith("org.springframework.security.oauth2.core.oidc.user")) {
                    return SpringSecurityContext.getSpringOidcIdToken(authentication);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Does not yet support (Tokens of class: {})", authentication.getPrincipal().getClass());
            }
        } else {
            LOGGER.debug("Spring SecurityContextHolder does not contain a token which was authenticated ({})", (Object)authentication);
        }
        return null;
    }

    @Nullable
    static Token getTokenFromDeprecatedLib(Authentication authentication) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getTokenValue = authentication.getDetails().getClass().getMethod("getTokenValue", new Class[0]);
        String encodedToken = (String)getTokenValue.invoke(authentication.getDetails(), new Object[0]);
        XsuaaTokenWithGrantedAuthorities xsuaaToken = new XsuaaTokenWithGrantedAuthorities(encodedToken, authentication.getAuthorities());
        if (xsuaaToken.isXsuaaToken()) {
            return xsuaaToken;
        }
        return new SapIdToken(encodedToken);
    }

    static Token getSpringXsuaaToken(Authentication authentication) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method getAppToken = authentication.getPrincipal().getClass().getMethod("getAppToken", new Class[0]);
        String encodedToken = (String)getAppToken.invoke(authentication.getPrincipal(), new Object[0]);
        return Token.create((String)encodedToken);
    }

    static Token getSpringOidcIdToken(Authentication authentication) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getIdToken = authentication.getPrincipal().getClass().getMethod("getIdToken", new Class[0]);
        Object oidcToken = getIdToken.invoke(authentication.getPrincipal(), new Object[0]);
        Method getTokenValue = oidcToken.getClass().getMethod("getTokenValue", new Class[0]);
        String encodedToken = (String)getTokenValue.invoke(oidcToken, new Object[0]);
        return Token.create((String)encodedToken);
    }

    @Nullable
    public static AccessToken getAccessToken() {
        Token token = SpringSecurityContext.getToken();
        return token instanceof AccessToken ? (AccessToken)token : null;
    }

    public static void clear() {
        SecurityContextHolder.clearContext();
    }

    private static class XsuaaTokenWithGrantedAuthorities
    extends XsuaaToken {
        private final Collection<? extends GrantedAuthority> authorities;

        public XsuaaTokenWithGrantedAuthorities(String tokenValue, @Nullable Collection<? extends GrantedAuthority> authorities) {
            super(tokenValue);
            this.authorities = authorities;
        }

        @Override
        public boolean hasLocalScope(@Nonnull String scope) {
            return this.authorities.contains(new SimpleGrantedAuthority(scope));
        }
    }
}

