/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.xsuaa.Assertions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XsuaaScopeConverter
implements ScopeConverter {
    private final Pattern globalScopePattern;

    public XsuaaScopeConverter(String appId) {
        Assertions.assertHasText((String)appId, (String)"appId must not be null or empty.");
        this.globalScopePattern = Pattern.compile(appId + "\\.(.+)");
    }

    @Override
    public Set<String> convert(Collection<String> scopes) {
        LinkedHashSet<String> convertedScopes = new LinkedHashSet<String>();
        for (String scope : scopes) {
            String convertedScope = this.convertToLocalScope(scope);
            if (convertedScope == null) continue;
            convertedScopes.add(convertedScope);
        }
        return convertedScopes;
    }

    private String convertToLocalScope(String scope) {
        Matcher matcher = this.globalScopePattern.matcher(scope);
        if (matcher.matches()) {
            return matcher.group(matcher.groupCount());
        }
        return null;
    }
}

