/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation;

import com.sap.cloud.security.token.validation.ValidationListener;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombiningValidator<T>
implements Validator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombiningValidator.class);
    private final List<Validator<T>> validators;
    private final Set<ValidationListener> validationListeners = new HashSet<ValidationListener>();

    public CombiningValidator(List<Validator<T>> validators) {
        Assertions.assertNotNull(validators, (String)"validators must not be null.");
        this.validators = validators;
    }

    public CombiningValidator(Validator<T> ... validators) {
        Assertions.assertNotNull(validators, (String)"validators must not be null.");
        this.validators = Arrays.asList(validators);
    }

    @Override
    public ValidationResult validate(T t) {
        for (Validator<T> validator : this.validators) {
            ValidationResult result = validator.validate(t);
            if (!result.isErroneous()) continue;
            this.debugLog(t, validator);
            this.validationListeners.forEach(listener -> listener.onValidationError(result));
            return result;
        }
        return this.createValidationResult();
    }

    public List<Validator<T>> getValidators() {
        return this.validators;
    }

    public String toString() {
        StringBuilder validatorNames = new StringBuilder();
        for (Validator<T> v : this.validators) {
            validatorNames.append(v.getClass().getName()).append(',');
        }
        return validatorNames.toString();
    }

    public void registerValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    private void debugLog(T t, Validator<T> validator) {
        if (LOGGER.isDebugEnabled()) {
            String objectType = t == null ? "null" : t.getClass().getName();
            LOGGER.debug("Validator that caused the failed validation: {}", (Object)validator.getClass().getName());
            LOGGER.debug("Object of type {} that caused the failed validation: {}{}", new Object[]{objectType, System.lineSeparator(), t});
        }
    }

    private ValidationResult createValidationResult() {
        if (this.validators.isEmpty()) {
            ValidationResult result = ValidationResults.createInvalid("CombiningValidator must contain at least one validator!");
            this.validationListeners.forEach(listener -> listener.onValidationError(result));
            return result;
        }
        this.validationListeners.forEach(ValidationListener::onValidationSuccess);
        return ValidationResults.createValid();
    }
}

